/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.util;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;

public class GraphicsUtilities {
    private static BufferedImage shadowImage;
    private static int animationShadowSize;

    private GraphicsUtilities() {
    }

    private static GraphicsConfiguration getGraphicsConfiguration() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    private static boolean isHeadless() {
        return GraphicsEnvironment.isHeadless();
    }

    public static BufferedImage createColorModelCompatibleImage(BufferedImage image) {
        ColorModel cm = image.getColorModel();
        return new BufferedImage(cm, cm.createCompatibleWritableRaster(image.getWidth(), image.getHeight()), cm.isAlphaPremultiplied(), null);
    }

    public static BufferedImage createCompatibleImage(BufferedImage image) {
        return GraphicsUtilities.createCompatibleImage(image, image.getWidth(), image.getHeight());
    }

    public static BufferedImage createCompatibleImage(BufferedImage image, int width, int height) {
        return GraphicsUtilities.isHeadless() ? new BufferedImage(width, height, image.getType()) : GraphicsUtilities.getGraphicsConfiguration().createCompatibleImage(width, height, image.getTransparency());
    }

    public static BufferedImage createCompatibleImage(int width, int height) {
        return GraphicsUtilities.isHeadless() ? new BufferedImage(width, height, 1) : GraphicsUtilities.getGraphicsConfiguration().createCompatibleImage(width, height);
    }

    public static BufferedImage createCompatibleTranslucentImage(int width, int height) {
        return GraphicsUtilities.isHeadless() ? new BufferedImage(width, height, 2) : GraphicsUtilities.getGraphicsConfiguration().createCompatibleImage(width, height, 3);
    }

    public static BufferedImage loadCompatibleImage(URL resource) throws IOException {
        BufferedImage image = ImageIO.read(resource);
        return GraphicsUtilities.toCompatibleImage(image);
    }

    public static BufferedImage toCompatibleImage(BufferedImage image) {
        if (GraphicsUtilities.isHeadless()) {
            return image;
        }
        if (image.getColorModel().equals(GraphicsUtilities.getGraphicsConfiguration().getColorModel())) {
            return image;
        }
        BufferedImage compatibleImage = GraphicsUtilities.getGraphicsConfiguration().createCompatibleImage(image.getWidth(), image.getHeight(), image.getTransparency());
        Graphics g2 = compatibleImage.getGraphics();
        g2.drawImage(image, 0, 0, null);
        g2.dispose();
        return compatibleImage;
    }

    public static BufferedImage createThumbnailFast(BufferedImage image, int newSize) {
        int height;
        int width = image.getWidth();
        if (width > (height = image.getHeight())) {
            if (newSize >= width) {
                throw new IllegalArgumentException("newSize must be lower than the image width");
            }
            if (newSize <= 0) {
                throw new IllegalArgumentException("newSize must be greater than 0");
            }
            float ratio = (float)width / (float)height;
            width = newSize;
            height = (int)((float)newSize / ratio);
        } else {
            if (newSize >= height) {
                throw new IllegalArgumentException("newSize must be lower than the image height");
            }
            if (newSize <= 0) {
                throw new IllegalArgumentException("newSize must be greater than 0");
            }
            float ratio = (float)height / (float)width;
            height = newSize;
            width = (int)((float)newSize / ratio);
        }
        BufferedImage temp = GraphicsUtilities.createCompatibleImage(image, width, height);
        Graphics2D g2 = temp.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.drawImage(image, 0, 0, temp.getWidth(), temp.getHeight(), null);
        g2.dispose();
        return temp;
    }

    public static BufferedImage createThumbnailFast(BufferedImage image, int newWidth, int newHeight) {
        if (newWidth >= image.getWidth() || newHeight >= image.getHeight()) {
            throw new IllegalArgumentException("newWidth and newHeight cannot be greater than the image dimensions");
        }
        if (newWidth <= 0 || newHeight <= 0) {
            throw new IllegalArgumentException("newWidth and newHeight must be greater than 0");
        }
        BufferedImage temp = GraphicsUtilities.createCompatibleImage(image, newWidth, newHeight);
        Graphics2D g2 = temp.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.drawImage(image, 0, 0, temp.getWidth(), temp.getHeight(), null);
        g2.dispose();
        return temp;
    }

    public static BufferedImage createThumbnail(BufferedImage image, int newSize) {
        boolean isWidthGreater;
        int width = image.getWidth();
        int height = image.getHeight();
        boolean isTranslucent = image.getTransparency() != 1;
        boolean bl = isWidthGreater = width > height;
        if (isWidthGreater) {
            if (newSize >= width) {
                throw new IllegalArgumentException("newSize must be lower than the image width");
            }
        } else if (newSize >= height) {
            throw new IllegalArgumentException("newSize must be lower than the image height");
        }
        if (newSize <= 0) {
            throw new IllegalArgumentException("newSize must be greater than 0");
        }
        float ratioWH = (float)width / (float)height;
        float ratioHW = (float)height / (float)width;
        BufferedImage thumb = image;
        BufferedImage temp = null;
        Graphics2D g2 = null;
        int previousWidth = width;
        int previousHeight = height;
        do {
            if (isWidthGreater) {
                if ((width /= 2) < newSize) {
                    width = newSize;
                }
                height = (int)((float)width / ratioWH);
            } else {
                if ((height /= 2) < newSize) {
                    height = newSize;
                }
                width = (int)((float)height / ratioHW);
            }
            if (temp == null || isTranslucent) {
                temp = GraphicsUtilities.createCompatibleImage(image, width, height);
                g2 = temp.createGraphics();
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            }
            g2.drawImage(thumb, 0, 0, width, height, 0, 0, previousWidth, previousHeight, null);
            previousWidth = width;
            previousHeight = height;
            thumb = temp;
        } while (newSize != (isWidthGreater ? width : height));
        g2.dispose();
        if (width != thumb.getWidth() || height != thumb.getHeight()) {
            temp = GraphicsUtilities.createCompatibleImage(image, width, height);
            g2 = temp.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2.drawImage(thumb, 0, 0, width, height, null);
            g2.dispose();
            thumb = temp;
        }
        return thumb;
    }

    public static BufferedImage createThumbnail(BufferedImage image, int newWidth, int newHeight) {
        boolean isTranslucent;
        int width = image.getWidth();
        int height = image.getHeight();
        boolean bl = isTranslucent = image.getTransparency() != 1;
        if (newWidth >= width || newHeight >= height) {
            throw new IllegalArgumentException("newWidth and newHeight cannot be greater than the image dimensions");
        }
        if (newWidth <= 0 || newHeight <= 0) {
            throw new IllegalArgumentException("newWidth and newHeight must be greater than 0");
        }
        BufferedImage thumb = image;
        BufferedImage temp = null;
        Graphics2D g2 = null;
        int previousWidth = width;
        int previousHeight = height;
        do {
            if (width > newWidth && (width /= 2) < newWidth) {
                width = newWidth;
            }
            if (height > newHeight && (height /= 2) < newHeight) {
                height = newHeight;
            }
            if (temp == null || isTranslucent) {
                temp = GraphicsUtilities.createCompatibleImage(image, width, height);
                g2 = temp.createGraphics();
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            }
            g2.drawImage(thumb, 0, 0, width, height, 0, 0, previousWidth, previousHeight, null);
            previousWidth = width;
            previousHeight = height;
            thumb = temp;
        } while (width != newWidth || height != newHeight);
        g2.dispose();
        if (width != thumb.getWidth() || height != thumb.getHeight()) {
            temp = GraphicsUtilities.createCompatibleImage(image, width, height);
            g2 = temp.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2.drawImage(thumb, 0, 0, width, height, null);
            g2.dispose();
            thumb = temp;
        }
        return thumb;
    }

    public static int[] getPixels(BufferedImage img, int x2, int y2, int w2, int h2, int[] pixels) {
        if (w2 == 0 || h2 == 0) {
            return new int[0];
        }
        if (pixels == null) {
            pixels = new int[w2 * h2];
        } else if (pixels.length < w2 * h2) {
            throw new IllegalArgumentException("pixels array must have a length >= w*h");
        }
        int imageType = img.getType();
        if (imageType == 2 || imageType == 1) {
            WritableRaster raster = img.getRaster();
            return (int[])raster.getDataElements(x2, y2, w2, h2, pixels);
        }
        return img.getRGB(x2, y2, w2, h2, pixels, 0, w2);
    }

    public static void setPixels(BufferedImage img, int x2, int y2, int w2, int h2, int[] pixels) {
        if (pixels == null || w2 == 0 || h2 == 0) {
            return;
        }
        if (pixels.length < w2 * h2) {
            throw new IllegalArgumentException("pixels array must have a length >= w*h");
        }
        int imageType = img.getType();
        if (imageType == 2 || imageType == 1) {
            WritableRaster raster = img.getRaster();
            raster.setDataElements(x2, y2, w2, h2, pixels);
        } else {
            img.setRGB(x2, y2, w2, h2, pixels, 0, w2);
        }
    }

    public static void drawDropShadow(Component comp, Graphics2D g2d, int x2, int y2, int width) {
        if (shadowImage == null) {
            shadowImage = GraphicsUtilities.createShadowImage();
        }
        Composite composite = g2d.getComposite();
        g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
        g2d.setPaint(new TexturePaint(shadowImage, new Rectangle(0, y2, shadowImage.getWidth(), shadowImage.getHeight())));
        g2d.fillRect(x2, y2, width, shadowImage.getHeight());
        g2d.setComposite(composite);
    }

    public static void drawDropShadow(Component comp, Graphics2D g2d, int x2, int y2, int width, int height) {
        if (shadowImage == null) {
            shadowImage = GraphicsUtilities.createShadowImage();
        }
        Composite composite = g2d.getComposite();
        g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
        g2d.setPaint(new TexturePaint(shadowImage, new Rectangle(0, y2, shadowImage.getWidth(), height)));
        g2d.fillRect(x2, y2, width, height);
        g2d.setComposite(composite);
    }

    private static BufferedImage createShadowImage() {
        if (shadowImage == null) {
            int cornerSize = 12;
            Color shadowColor = Color.BLACK;
            float shadowOpacity = 0.5f;
            int rectWidth = cornerSize + 1;
            RoundRectangle2D.Double rect = new RoundRectangle2D.Double(0.0, 0.0, rectWidth, rectWidth, cornerSize, cornerSize);
            int imageWidth = rectWidth + animationShadowSize * 2;
            BufferedImage image = GraphicsUtilities.createCompatibleTranslucentImage(imageWidth, imageWidth);
            Graphics2D buffer = (Graphics2D)image.getGraphics();
            buffer.setPaint(new Color(shadowColor.getRed(), shadowColor.getGreen(), shadowColor.getBlue(), (int)(shadowOpacity * 255.0f)));
            buffer.translate(animationShadowSize, animationShadowSize);
            buffer.fill(rect);
            buffer.dispose();
            float blurry = 1.0f / (float)(animationShadowSize * animationShadowSize);
            float[] blurKernel = new float[animationShadowSize * animationShadowSize];
            for (int i2 = 0; i2 < blurKernel.length; ++i2) {
                blurKernel[i2] = blurry;
            }
            ConvolveOp blur = new ConvolveOp(new Kernel(animationShadowSize, animationShadowSize, blurKernel));
            BufferedImage targetImage = GraphicsUtilities.createCompatibleTranslucentImage(imageWidth, imageWidth);
            ((Graphics2D)targetImage.getGraphics()).drawImage(image, blur, -(animationShadowSize / 2), -(animationShadowSize / 2));
            int x2 = cornerSize + 1;
            int y2 = rectWidth;
            int w2 = 1;
            int h2 = animationShadowSize;
            shadowImage = GraphicsUtilities.getSubImage(targetImage, x2, y2, w2, h2);
        }
        return shadowImage;
    }

    private static BufferedImage getSubImage(BufferedImage img, int x2, int y2, int w2, int h2) {
        BufferedImage ret = GraphicsUtilities.createCompatibleTranslucentImage(w2, h2);
        Graphics2D g2 = ret.createGraphics();
        g2.drawImage(img, 0, 0, w2, h2, x2, y2, x2 + w2, y2 + h2, null);
        g2.dispose();
        return ret;
    }

    static {
        animationShadowSize = 10;
    }
}

