/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.timeline;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.dateline.AbstractDatelineModel;
import com.dlsc.flexgantt.model.dateline.TimeGranularity;
import com.dlsc.flexgantt.swing.timeline.AbstractDatelineRenderer;
import com.dlsc.flexgantt.swing.timeline.Dateline;
import com.dlsc.flexgantt.swing.timeline.TimeGranularityDatelineModel;
import java.awt.Component;

public class TimeGranularityDatelineRenderer<T extends TimeGranularityDatelineModel>
extends AbstractDatelineRenderer<T> {
    public TimeGranularityDatelineRenderer() {
        this.setOpaque(true);
    }

    @Override
    public Component getDatelineRendererComponent(Dateline dateline, T model, ITimeSpan timeSpan, boolean major, boolean focus) {
        super.getDatelineRendererComponent(dateline, model, timeSpan, major, focus);
        if (major) {
            TimeGranularity tg = ((TimeGranularityDatelineModel)model).getMajorTimeGranularity();
            this.setText(((TimeGranularityDatelineModel)model).getMajorDateString(tg, timeSpan.getStartTime()));
            this.setForeground(this.getMajorForeground(dateline, timeSpan.getStartTime()));
            this.setBackground(this.getMajorBackground(dateline, timeSpan.getStartTime()));
        } else {
            TimeGranularity tg = (TimeGranularity)((AbstractDatelineModel)model).getGranularity();
            this.setText(((TimeGranularityDatelineModel)model).getMinorDateString(tg, timeSpan.getStartTime()));
            this.setForeground(this.getMinorForeground(dateline, timeSpan.getStartTime()));
            this.setBackground(this.getMinorBackground(dateline, timeSpan.getStartTime()));
        }
        this.setEnabled(dateline.isEnabled());
        return this;
    }
}

