/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.selector;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.MessageTypeId;
import com.dlsc.flexgantt.swing.selector.Selector;
import com.dlsc.flexgantt.util.Messages;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.border.EmptyBorder;

public class TimeGranularityGotoSelector
extends Selector
implements ActionListener {
    private JSpinner spinner;
    private AbstractGanttChart ganttChart;

    public TimeGranularityGotoSelector(JComponent parentComponent, AbstractGanttChart gc2) {
        super(Messages.getString("TimeGranularityGotoSelector.TITLE"), parentComponent, Selector.Location.LEFT);
        if (gc2 == null) {
            throw new IllegalArgumentException("Gantt chart can not be NULL");
        }
        this.ganttChart = gc2;
        JPanel content = new JPanel();
        content.setLayout(new BorderLayout(5, 5));
        this.spinner = new JSpinner(new SpinnerDateModel());
        this.spinner.setValue(new Date(this.getInitialTime()));
        content.add("Center", this.spinner);
        JButton apply = new JButton(Messages.getString("TimeGranularityGotoSelector.APPLY"));
        apply.addActionListener(this);
        apply.setOpaque(false);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(0, 0, 0));
        buttonPanel.add(apply);
        buttonPanel.setOpaque(false);
        content.add("South", buttonPanel);
        content.setBorder(new EmptyBorder(10, 10, 10, 10));
        content.setOpaque(false);
        this.setContentComponent(content);
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        long time;
        SpinnerDateModel model = (SpinnerDateModel)this.spinner.getModel();
        Date date = model.getDate();
        ITimeSpan horizon = this.ganttChart.getTimeSpan();
        if (horizon.contains(time = date.getTime())) {
            this.ganttChart.showTime(time, true);
        } else {
            this.ganttChart.showMessage(Messages.getString("TimeGranularityGotoSelector.UNABLE_TO_SHOW_TIME") + "\n" + Messages.getString("TimeGranularityGotoSelector.OUTSIDE_OF_HORIZON"), MessageTypeId.WARNING);
        }
    }

    protected long getInitialTime() {
        Calendar c2 = Calendar.getInstance(this.ganttChart.getDatelineModel().getTimeZone());
        long time = c2.getTimeInMillis();
        ITimeSpan horizon = this.ganttChart.getTimeSpan();
        if (horizon.contains(time)) {
            return time;
        }
        return horizon.getStartTime();
    }

    protected JSpinner createSpinner() {
        return new JSpinner(new SpinnerDateModel());
    }
}

