/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.selector;

import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.IGridComponent;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.selector.ActionSelector;
import com.dlsc.flexgantt.swing.selector.BookmarksSelector;
import com.dlsc.flexgantt.swing.selector.ColumnChooserSelector;
import com.dlsc.flexgantt.swing.selector.GranularitySelector;
import com.dlsc.flexgantt.swing.selector.GridSelector;
import com.dlsc.flexgantt.swing.selector.ISelectorFactory;
import com.dlsc.flexgantt.swing.selector.LayerSelector;
import com.dlsc.flexgantt.swing.selector.OverviewSelector;
import com.dlsc.flexgantt.swing.selector.PagingSelector;
import com.dlsc.flexgantt.swing.selector.Selector;
import com.dlsc.flexgantt.swing.selector.SimpleGranularityGotoSelector;
import com.dlsc.flexgantt.swing.selector.SimpleGranularityHorizonSelector;
import com.dlsc.flexgantt.swing.selector.TimeZoneSelector;
import javax.swing.JComponent;

public class SimpleGranularitySelectorFactory
implements ISelectorFactory {
    private static SimpleGranularitySelectorFactory instance;

    protected SimpleGranularitySelectorFactory() {
    }

    public static SimpleGranularitySelectorFactory getInstance() {
        if (instance == null) {
            instance = new SimpleGranularitySelectorFactory();
        }
        return instance;
    }

    @Override
    public Selector createSelector(AbstractGanttChart gc2, JComponent parentComponent, ISelectorFactory.SelectorID id2) {
        switch (id2) {
            case ACTIONS: {
                return new ActionSelector(parentComponent, gc2);
            }
            case COLUMNS: {
                return new ColumnChooserSelector(parentComponent, gc2);
            }
            case GOTO: {
                return new SimpleGranularityGotoSelector(parentComponent, gc2);
            }
            case TIMEZONE: {
                return new TimeZoneSelector(parentComponent, gc2);
            }
            case PAGES: {
                return new PagingSelector(parentComponent, gc2);
            }
            case LAYERS: {
                return new LayerSelector(parentComponent, gc2.getLayerContainers());
            }
            case OVERVIEW: {
                return new OverviewSelector(parentComponent, gc2.getLayerContainers());
            }
            case GRANULARITY: {
                return new GranularitySelector(parentComponent, gc2.getDateline());
            }
            case HORIZON: {
                return new SimpleGranularityHorizonSelector(parentComponent, gc2.getDateline());
            }
        }
        throw new IllegalArgumentException("unsupported selector type (id = " + (Object)((Object)id2) + ") for Gantt charts");
    }

    @Override
    public Selector createSelector(LayerContainer layerContainer, JComponent parentComponent, ISelectorFactory.SelectorID id2) {
        switch (id2) {
            case BOOKMARKS: {
                return new BookmarksSelector(parentComponent, layerContainer);
            }
            case GRID: {
                return new GridSelector(parentComponent, layerContainer);
            }
        }
        throw new IllegalArgumentException("unsupported selector type (id = " + (Object)((Object)id2) + ") for layer containers");
    }

    @Override
    public Selector createSelector(IGridComponent gridComponent, JComponent parentComponent, ISelectorFactory.SelectorID id2) {
        switch (id2) {
            case GRID: {
                return new GridSelector(parentComponent, gridComponent);
            }
        }
        throw new IllegalArgumentException("unsupported selector type (id = " + (Object)((Object)id2) + ") for the given grid component");
    }
}

