/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer.system;

import com.dlsc.flexgantt.model.gantt.IGanttChartModel;
import com.dlsc.flexgantt.model.gantt.ILayer;
import com.dlsc.flexgantt.model.gantt.IRelationship;
import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.policy.layer.IPopupPolicy;
import com.dlsc.flexgantt.swing.ObjectBounds;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.system.AbstractSystemLayer;
import com.dlsc.flexgantt.swing.layer.system.DefaultPopupRenderer;
import com.dlsc.flexgantt.swing.layer.system.DragLayer;
import com.dlsc.flexgantt.swing.layer.system.IPopupRenderer;
import com.dlsc.flexgantt.swing.layer.system.RelationshipLayer;
import com.dlsc.flexgantt.swing.layer.timeline.TimelineObjectLayer;
import com.dlsc.flexgantt.swing.treetable.TreeTable;
import com.dlsc.flexgantt.swing.treetable.TreeTableNode;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.TreePath;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;
import org.jdesktop.animation.timing.TimingTargetAdapter;

public class PopupLayer
extends AbstractSystemLayer
implements MouseListener,
MouseMotionListener,
KeyEventDispatcher {
    private static final Logger LOGGER = Logger.getLogger(PopupLayer.class.getName());
    private Point mouseHitPoint;
    private Point offset = new Point(3, 3);
    private Point pinnedOffset = new Point(-12, -3);
    private ObjectBounds objectBounds;
    private TreePath treePath;
    private final Map<Object, TimelineObjectPath> pinnedPopups;
    private final Map<Class, IPopupRenderer> popupRendererMap;
    private final Map<Class, IPopupRenderer> popupRendererCache;
    private boolean extendedPopup;
    private Animator animator;
    private float popupVisibility = 0.0f;
    private boolean animating = true;
    private final KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
    private IRelationship relationship;
    private Point relationshipHitPoint;
    private boolean showingTimlineObjectPopups = true;
    private boolean showingRelationshipObjectPopups = false;
    private boolean showingTreeNodePopups = true;
    private int animationDelay = 1000;
    private int animationDuration = 300;

    public PopupLayer(LayerContainer lc2) {
        super("Popup", lc2);
        lc2.addMouseListener(this);
        lc2.addMouseMotionListener(this);
        lc2.getTreeTable().addMouseListener(this);
        lc2.getTreeTable().addMouseMotionListener(this);
        this.pinnedPopups = new HashMap<Object, TimelineObjectPath>();
        this.popupRendererMap = new HashMap<Class, IPopupRenderer>(10);
        this.popupRendererCache = new HashMap<Class, IPopupRenderer>(10);
        this.setPopupRenderer(Object.class, new DefaultPopupRenderer());
        this.keyboardFocusManager.addKeyEventDispatcher(this);
    }

    public void setShowingRelationshipObjectPopups(boolean showing) {
        this.showingRelationshipObjectPopups = showing;
    }

    public boolean isShowingRelationshipObjectPopups() {
        return this.showingRelationshipObjectPopups;
    }

    public void setShowingTimlineObjectPopups(boolean showing) {
        this.showingTimlineObjectPopups = showing;
    }

    public boolean isShowingTimlineObjectPopups() {
        return this.showingTimlineObjectPopups;
    }

    public void setShowingTreeNodePopups(boolean showing) {
        this.showingTreeNodePopups = showing;
    }

    public boolean isShowingTreeNodePopups() {
        return this.showingTreeNodePopups;
    }

    @Override
    public boolean isVisible() {
        return this.getTreeTable().getAnimationNode() == null && super.isVisible();
    }

    public Point getOffset() {
        return this.offset;
    }

    public void setOffset(Point offset) {
        if (offset == null) {
            throw new IllegalArgumentException("offset can not be NULL");
        }
        this.offset = offset;
    }

    public Point getPinnedOffset() {
        return this.pinnedOffset;
    }

    public void setPinnedOffset(Point offset) {
        if (this.pinnedOffset == null) {
            throw new IllegalArgumentException("offset can not be NULL");
        }
        this.pinnedOffset = offset;
    }

    public void addPinnedPopup(TimelineObjectPath path) {
        if (path == null) {
            throw new IllegalArgumentException("path can not be NULL");
        }
        this.pinnedPopups.put(path, path);
        this.repaint();
    }

    public void removePinnedPopup(TimelineObjectPath path) {
        if (path == null) {
            throw new IllegalArgumentException("path can not be NULL");
        }
        this.pinnedPopups.remove(path);
        this.repaint();
    }

    public void clearPinnedPopups() {
        this.pinnedPopups.clear();
        this.repaint();
    }

    public List<TimelineObjectPath> getPinnedPopups() {
        return new ArrayList<TimelineObjectPath>(this.pinnedPopups.values());
    }

    public void setPinnedPopups(List<TimelineObjectPath> paths) {
        if (paths == null) {
            throw new IllegalArgumentException("paths can not be NULL");
        }
        this.pinnedPopups.clear();
        for (TimelineObjectPath path : paths) {
            this.addPinnedPopup(path);
        }
    }

    @Override
    protected void paintLayer(Graphics g2) {
        super.paintLayer(g2);
        DragLayer dl = this.layerContainer.getSystemLayer(DragLayer.class);
        if (!dl.isDragging()) {
            Composite composite;
            TimelineObjectPath path;
            Graphics2D g2d = (Graphics2D)g2;
            Composite comp = g2d.getComposite();
            g2d.setComposite(AlphaComposite.getInstance(3, this.alpha));
            TreeTable table = this.getTreeTable();
            for (TimelineObjectPath path2 : this.pinnedPopups.values()) {
                if (!table.isTreePathExpanded(path2)) continue;
                this.paintTimelineObjectPathPopup(g2, path2, true);
            }
            if (this.objectBounds != null && !this.pinnedPopups.containsValue(path = this.objectBounds.getPath())) {
                Composite composite2 = g2d.getComposite();
                g2d.setComposite(AlphaComposite.getInstance(3, this.popupVisibility * this.alpha));
                this.paintTimelineObjectPathPopup(g2, this.objectBounds.getPath(), false);
                g2d.setComposite(composite2);
            }
            if (this.treePath != null && table.isTreePathExpanded(this.treePath)) {
                composite = g2d.getComposite();
                g2d.setComposite(AlphaComposite.getInstance(3, this.popupVisibility * this.alpha));
                this.paintTreePathPopup(g2, this.treePath, false);
                g2d.setComposite(composite);
            }
            if (this.relationship != null) {
                composite = g2d.getComposite();
                g2d.setComposite(AlphaComposite.getInstance(3, this.popupVisibility * this.alpha));
                this.paintRelationshipPopup(g2, this.relationship);
                g2d.setComposite(composite);
            }
            g2d.setComposite(comp);
        }
    }

    protected void paintTimelineObjectPathPopup(Graphics g2, TimelineObjectPath path, boolean pinned) {
        if (this.isShowingTimlineObjectPopups()) {
            IPopupPolicy policy = this.getLayerPolicyProvider().getPolicy(IPopupPolicy.class);
            IGanttChartModel model = this.getModel();
            ILayer layer = path.getLayer();
            TimelineObjectLayer layerUI = this.layerContainer.getTimelineObjectLayer(layer);
            ObjectBounds bounds = layerUI.getObjectBounds(path);
            if (bounds != null) {
                Object popupObject = policy.getPopupValue(path, model, this.extendedPopup && !pinned);
                Object titleObject = policy.getPopupTitleValue(path, model);
                if (popupObject != null) {
                    IPopupRenderer renderer = this.getPopupRenderer(popupObject.getClass());
                    Component comp = renderer.getPopupRendererComponent(this, titleObject, popupObject, path, model, pinned);
                    if (comp != null) {
                        Dimension dim = comp.getPreferredSize();
                        Point p2 = null;
                        p2 = pinned ? new Point(bounds.x + this.pinnedOffset.x, bounds.y + bounds.height + this.pinnedOffset.y) : this.calculateTimelineObjectPopupLocation(bounds, comp);
                        this.layerContainer.getRendererPane().paintComponent(g2, comp, this.layerContainer, p2.x, p2.y, dim.width, dim.height, true);
                    }
                } else if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("renderer does not provide a component");
                }
            }
        }
    }

    private Point calculateTimelineObjectPopupLocation(ObjectBounds bounds, Component popup) {
        int preferredWidth;
        int spaceRight;
        int x2 = this.mouseHitPoint.x;
        int y2 = bounds.y + bounds.height + this.offset.y;
        Rectangle visible = this.layerContainer.getVisibleRect();
        int spaceBelow = visible.y + visible.height - y2;
        int preferredHeight = popup.getPreferredSize().height;
        if (spaceBelow < preferredHeight) {
            y2 = bounds.y - preferredHeight - this.offset.y;
        }
        if ((spaceRight = visible.x + visible.width - x2) < (preferredWidth = popup.getPreferredSize().width)) {
            x2 = visible.x + visible.width - preferredWidth;
        }
        x2 = Math.max(x2, visible.x);
        y2 = Math.max(y2, visible.y);
        return new Point(x2, y2);
    }

    protected void paintTreePathPopup(Graphics g2, TreePath path, boolean pinned) {
        TreeTable table;
        if (this.isShowingTreeNodePopups() && (table = this.getTreeTable()).isTreePathExpanded(path)) {
            IPopupPolicy policy = this.getLayerPolicyProvider().getPolicy(IPopupPolicy.class);
            IGanttChartModel model = this.getModel();
            Object popupObject = policy.getPopupValue(path, model, this.extendedPopup && !pinned);
            Object titleObject = policy.getPopupTitleValue(path, model);
            if (popupObject != null) {
                IPopupRenderer renderer = this.getPopupRenderer(popupObject.getClass());
                Component comp = renderer.getPopupRendererComponent(this, titleObject, popupObject, path, model, pinned);
                if (comp != null) {
                    Dimension dim = comp.getPreferredSize();
                    Point p2 = null;
                    int row = table.getRowForPath(path);
                    if (row != -1) {
                        Rectangle rect = this.layerContainer.getVisibleRect();
                        TreeTableNode node = table.getTreeTableNodes().get(row);
                        p2 = pinned ? new Point(rect.x + 5, node.getY()) : new Point(rect.x + 5, this.mouseHitPoint.y);
                        this.layerContainer.getRendererPane().paintComponent(g2, comp, this.layerContainer, p2.x, p2.y, dim.width, dim.height, true);
                    }
                }
            } else if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("renderer does not provide a component");
            }
        }
    }

    protected void paintRelationshipPopup(Graphics g2, IRelationship relationship) {
        if (this.isShowingRelationshipObjectPopups()) {
            IPopupPolicy policy = this.getLayerPolicyProvider().getPolicy(IPopupPolicy.class);
            IGanttChartModel model = this.getModel();
            Object popupObject = policy.getPopupValue(relationship, model, this.extendedPopup);
            Object titleObject = policy.getPopupTitleValue(relationship, model);
            if (popupObject != null) {
                IPopupRenderer renderer = this.getPopupRenderer(popupObject.getClass());
                Component comp = renderer.getPopupRendererComponent(this, titleObject, popupObject, relationship, model);
                if (comp != null) {
                    Dimension dim = comp.getPreferredSize();
                    this.layerContainer.getRendererPane().paintComponent(g2, comp, this.layerContainer, this.relationshipHitPoint.x, this.relationshipHitPoint.y, dim.width, dim.height, true);
                }
            } else if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("renderer does not provide a component");
            }
        }
    }

    @Override
    public void setVisible(boolean b2) {
        super.setVisible(b2);
        if (b2) {
            LOGGER.fine("adding popup layer mouse motion listener");
            this.layerContainer.addMouseMotionListener(this);
        } else {
            LOGGER.fine("removing popup layer mouse motion listener");
            this.layerContainer.removeMouseMotionListener(this);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e2) {
        boolean repaint = false;
        Point point = e2.getPoint();
        ObjectBounds prevBounds = this.objectBounds;
        TreePath previousPath = this.treePath;
        if (e2.getSource().equals(this.layerContainer)) {
            this.treePath = null;
            this.objectBounds = this.layerContainer.getObjectBoundsAt(point.x, point.y);
            LOGGER.fine("previous bounds: " + prevBounds);
            if (this.objectBounds == null && prevBounds != null || this.objectBounds != null && !this.objectBounds.equals(prevBounds)) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("active bounds is different than previous bounds");
                    LOGGER.fine("repainting layer");
                }
                repaint = true;
            }
            RelationshipLayer rl = this.layerContainer.getSystemLayer(RelationshipLayer.class);
            List<IRelationship> relationships = rl.getRelationshipsAt(e2.getX(), e2.getY());
            this.relationship = null;
            if (!relationships.isEmpty()) {
                this.relationshipHitPoint = e2.getPoint();
                this.relationship = relationships.get(0);
            }
        } else if (e2.getSource().equals(this.getTreeTable())) {
            this.objectBounds = null;
            TreeTable table = this.getTreeTable();
            int row = table.getRowAt(point.y);
            if (row >= 0) {
                this.treePath = this.getTreeTable().getTreePath(row);
                LOGGER.fine("previous path: " + previousPath);
                if (this.treePath == null && previousPath != null || this.treePath != null && !this.treePath.equals(previousPath)) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("active tree path is different than previous tree path");
                        LOGGER.fine("repainting layer");
                    }
                    repaint = true;
                }
            }
        }
        if (repaint) {
            this.extendedPopup = e2.isShiftDown();
            this.mouseHitPoint = point;
            if (this.objectBounds != null || this.treePath != null) {
                if (this.animator != null && this.animator.isRunning()) {
                    this.animator.stop();
                }
                TimingTargetAdapter fadeIn = new TimingTargetAdapter(){

                    @Override
                    public void timingEvent(float fraction) {
                        PopupLayer.this.popupVisibility = fraction;
                        PopupLayer.this.repaint();
                    }
                };
                if (this.isAnimating() && (prevBounds == null && this.objectBounds != null || previousPath == null && this.treePath != null || this.popupVisibility < 1.0f)) {
                    this.popupVisibility = 0.0f;
                    this.animator = this.createAnimator(fadeIn);
                    this.animator.start();
                    this.repaint();
                } else {
                    this.popupVisibility = 1.0f;
                    this.repaint();
                }
            } else {
                this.repaint();
            }
        }
    }

    protected Animator createAnimator(TimingTarget fadeIn) {
        Animator animator = new Animator(this.animationDuration, fadeIn);
        animator.setStartDelay(this.animationDelay);
        return animator;
    }

    public void setAnimationDuration(int animationDuration) {
        if (animationDuration < 1) {
            throw new IllegalArgumentException("animation duration has to be larger than 0 but was " + animationDuration);
        }
        this.animationDuration = animationDuration;
    }

    public int getAnimationDuration() {
        return this.animationDuration;
    }

    public void setAnimationDelay(int animationDelay) {
        this.animationDelay = animationDelay;
    }

    public int getAnimationDelay() {
        return this.animationDelay;
    }

    @Override
    public void mouseDragged(MouseEvent e2) {
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
    }

    @Override
    public void mouseExited(MouseEvent e2) {
        this.objectBounds = null;
        this.treePath = null;
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e2) {
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
    }

    public void setPopupRenderer(Class objectType, IPopupRenderer renderer) {
        if (objectType == null) {
            throw new IllegalArgumentException("the object type can not be NULL");
        }
        this.popupRendererCache.clear();
        this.popupRendererMap.put(objectType, renderer);
    }

    public IPopupRenderer getPopupRenderer(Class cl) {
        if (cl == null) {
            return null;
        }
        IPopupRenderer renderer = this.popupRendererCache.get(cl);
        if (renderer != null) {
            return renderer;
        }
        renderer = this.popupRendererMap.get(cl);
        if (renderer != null) {
            this.popupRendererCache.put(cl, renderer);
            return renderer;
        }
        renderer = this.getPopupRenderer(cl.getSuperclass());
        this.popupRendererCache.put(cl, renderer);
        return renderer;
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e2) {
        if (this.objectBounds != null) {
            TimelineObjectPath path = this.objectBounds.getPath();
            if (e2.getID() == 401 && e2.getKeyCode() == 10) {
                this.addPinnedPopup(path);
                this.layerContainer.getGanttChart().setPopupVisible(true);
                this.repaint();
            }
        }
        if (e2.getKeyCode() == 16) {
            boolean wasExtended = this.extendedPopup;
            this.extendedPopup = e2.getID() == 401;
            if (this.extendedPopup != wasExtended) {
                this.repaint();
            }
        }
        return false;
    }

    public boolean isAnimating() {
        return this.animating;
    }

    public void setAnimating(boolean animating) {
        this.animating = animating;
    }

    @Override
    public void tearDown() {
        super.tearDown();
        this.keyboardFocusManager.removeKeyEventDispatcher(this);
    }
}

