/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer.system;

import com.dlsc.flexgantt.command.ICommand;
import com.dlsc.flexgantt.icons.IconId;
import com.dlsc.flexgantt.icons.IconRegistry;
import com.dlsc.flexgantt.model.gantt.IGanttChartModel;
import com.dlsc.flexgantt.model.gantt.RelationshipType;
import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.policy.IPolicyProvider;
import com.dlsc.flexgantt.policy.layer.IRelationshipPolicy;
import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.ObjectBounds;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.system.AbstractSystemLayer;
import com.dlsc.flexgantt.swing.util.PathCalculator;
import com.dlsc.flexgantt.util.Messages;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.GeneralPath;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JOptionPane;

public class LinkLayer
extends AbstractSystemLayer
implements MouseListener,
MouseMotionListener {
    private static final Logger LOGGER = Logger.getLogger(LinkLayer.class.getName());
    private HandleLocation startHandle;
    private HandleLocation endHandle;
    private ObjectBounds sourceBounds;
    private ObjectBounds targetBounds;
    private Rectangle startHandleLeft;
    private Rectangle startHandleRight;
    private Rectangle endHandleLeft;
    private Rectangle endHandleRight;
    private Icon leftSourceHandleIcon = IconRegistry.getIcon(IconId.LINK_SOURCE_HANDLE_LEFT);
    private Icon leftSourceHandleIconFocus = IconRegistry.getIcon(IconId.LINK_SOURCE_HANDLE_LEFT_FOCUS);
    private Icon rightSourceHandleIcon = IconRegistry.getIcon(IconId.LINK_SOURCE_HANDLE_RIGHT);
    private Icon rightSourceHandleIconFocus = IconRegistry.getIcon(IconId.LINK_SOURCE_HANDLE_RIGHT_FOCUS);
    private Icon leftTargetHandleIcon = IconRegistry.getIcon(IconId.LINK_TARGET_HANDLE_LEFT);
    private Icon leftTargetHandleIconFocus = IconRegistry.getIcon(IconId.LINK_TARGET_HANDLE_LEFT_FOCUS);
    private Icon rightTargetHandleIcon = IconRegistry.getIcon(IconId.LINK_TARGET_HANDLE_RIGHT);
    private Icon rightTargetHandleIconFocus = IconRegistry.getIcon(IconId.LINK_TARGET_HANDLE_RIGHT_FOCUS);
    private boolean linking;
    private int handleIconOffset = 0;
    private PathCalculator pathCalculator;
    private int proximity = 10;
    private Stroke lineStroke = new BasicStroke(2.0f);
    private Point mouseLocation;

    public LinkLayer(LayerContainer lc2) {
        super("Link Layer", lc2);
        this.pathCalculator = new PathCalculator();
        lc2.addMouseListener(this);
        lc2.addMouseMotionListener(this);
    }

    public void setLineStroke(Stroke lineStroke) {
        this.lineStroke = lineStroke;
    }

    public Stroke getLineStroke() {
        return this.lineStroke;
    }

    public void setProximity(int proximity) {
        if (proximity < 0) {
            throw new IllegalArgumentException("proximity has to be larger than 0");
        }
        this.proximity = proximity;
    }

    public int getProximity() {
        return this.proximity;
    }

    public void setPathCalculator(PathCalculator calculator) {
        if (calculator == null) {
            throw new IllegalArgumentException("calculator can not be NULL");
        }
        this.pathCalculator = calculator;
    }

    public PathCalculator getPathCalculator() {
        return this.pathCalculator;
    }

    public void setHandleIconOffset(int handleIconOffset) {
        this.handleIconOffset = handleIconOffset;
    }

    public int getHandleIconOffset() {
        return this.handleIconOffset;
    }

    protected Icon getHandleIcon(ObjectBounds bounds, boolean source, boolean left, boolean focus) {
        if (source) {
            if (left) {
                if (focus) {
                    return this.leftSourceHandleIconFocus;
                }
                return this.leftSourceHandleIcon;
            }
            if (focus) {
                return this.rightSourceHandleIconFocus;
            }
            return this.rightSourceHandleIcon;
        }
        if (left) {
            if (focus) {
                return this.leftTargetHandleIconFocus;
            }
            return this.leftTargetHandleIcon;
        }
        if (focus) {
            return this.rightTargetHandleIconFocus;
        }
        return this.rightTargetHandleIcon;
    }

    protected int calculateHandleIconOffset(Icon icon, boolean source, boolean left) {
        if (left) {
            return this.handleIconOffset;
        }
        return -this.handleIconOffset;
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && this.layerContainer.isLinkingEnabled();
    }

    @Override
    protected void paintLayer(Graphics g2) {
        super.paintLayer(g2);
        if (this.sourceBounds != null && !this.isLinking()) {
            this.paintHandle(g2, this.startHandleLeft, this.sourceBounds, true, true, this.isFocused(this.startHandleLeft));
            this.paintHandle(g2, this.startHandleRight, this.sourceBounds, true, false, this.isFocused(this.startHandleRight));
        }
        if (this.targetBounds != null) {
            this.paintHandle(g2, this.endHandleLeft, this.targetBounds, false, true, this.isFocused(this.endHandleLeft));
            this.paintHandle(g2, this.endHandleRight, this.targetBounds, false, false, this.isFocused(this.endHandleRight));
        }
        if (this.isLinking()) {
            ObjectBounds sourceRect = this.sourceBounds;
            Rectangle targetRect = null;
            if (this.targetBounds == null) {
                Point p2 = this.layerContainer.getMousePosition();
                targetRect = new Rectangle(p2.x, p2.y, 1, 1);
            } else {
                targetRect = this.targetBounds;
            }
            GeneralPath path = null;
            RelationshipType type = this.getCurrentRelationshipType();
            if (type != null) {
                switch (type) {
                    case END_TO_END: {
                        path = this.pathCalculator.calculatePathEndToEnd(sourceRect, targetRect);
                        break;
                    }
                    case END_TO_START: {
                        path = this.pathCalculator.calculatePathEndToStart(sourceRect, targetRect);
                        break;
                    }
                    case START_TO_END: {
                        path = this.pathCalculator.calculatePathStartToEnd(sourceRect, targetRect);
                        break;
                    }
                    case START_TO_START: {
                        path = this.pathCalculator.calculatePathStartToStart(sourceRect, targetRect);
                    }
                }
            } else {
                path = this.calculatePath();
            }
            Graphics2D g2d = (Graphics2D)g2.create();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setColor(Color.BLACK);
            g2d.setStroke(this.lineStroke);
            g2d.draw(path);
            g2d.dispose();
        }
    }

    private GeneralPath calculatePath() {
        GeneralPath path = new GeneralPath();
        if (this.mouseLocation != null && this.sourceBounds != null) {
            switch (this.startHandle) {
                case START: {
                    int x2 = this.sourceBounds.x;
                    int y2 = this.sourceBounds.y + this.sourceBounds.height / 2;
                    path.moveTo(x2, y2);
                    path.lineTo(x2 - 8, y2);
                    path.lineTo(this.mouseLocation.x, this.mouseLocation.y);
                    break;
                }
                default: {
                    int x3 = this.sourceBounds.x + this.sourceBounds.width;
                    int y3 = this.sourceBounds.y + this.sourceBounds.height / 2;
                    path.moveTo(x3, y3);
                    path.lineTo(x3 + 8, y3);
                    path.lineTo(this.mouseLocation.x, this.mouseLocation.y);
                }
            }
        }
        return path;
    }

    private boolean isFocused(Rectangle rect) {
        return this.mouseLocation != null && rect.contains(this.mouseLocation);
    }

    protected void paintHandle(Graphics g2, Rectangle r2, ObjectBounds bounds, boolean source, boolean left, boolean focus) {
        if (r2 != null) {
            Icon icon = null;
            icon = source ? (left ? this.getHandleIcon(bounds, source, left, focus) : this.getHandleIcon(bounds, source, left, focus)) : (left ? this.getHandleIcon(bounds, source, left, focus) : this.getHandleIcon(bounds, source, left, focus));
            if (icon != null) {
                int offset = this.calculateHandleIconOffset(icon, source, left);
                icon.paintIcon(this.layerContainer, g2, r2.x + offset, r2.y);
            }
        }
    }

    public boolean isLinking() {
        return this.linking;
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
        IGanttChartModel model;
        TimelineObjectPath path;
        IPolicyProvider pp;
        IRelationshipPolicy rp;
        ObjectBounds bounds;
        if (!e2.isConsumed() && e2.getButton() == 1 && this.layerContainer.isLinkingEnabled() && (bounds = this.layerContainer.getObjectBoundsAt(e2.getX(), e2.getY(), this.proximity)) != null && !bounds.equals(this.sourceBounds) && bounds != null && (rp = (pp = this.getLayerPolicyProvider()).getPolicy(IRelationshipPolicy.class)).isRelationshipSource(path = bounds.getPath(), model = this.getModel())) {
            this.sourceBounds = bounds;
            RelationshipType[] types = rp.getSupportedRelationshipTypes(path, model);
            if (types == null) {
                throw new IllegalArgumentException("relationship policy returned NULL for supported relationship types even though timeline object is a possible relationship source");
            }
            for (RelationshipType t2 : types) {
                if (t2.equals((Object)RelationshipType.START_TO_END) || t2.equals((Object)RelationshipType.START_TO_START)) {
                    this.startHandleLeft = this.calculateBox(this.sourceBounds, true, true);
                    continue;
                }
                this.startHandleRight = this.calculateBox(this.sourceBounds, true, false);
            }
            this.mouseLocation = e2.getPoint();
            this.repaint();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
    }

    @Override
    public void mouseExited(MouseEvent e2) {
        this.sourceBounds = null;
        this.repaint();
    }

    public boolean isLinkStartLocation(Point p2) {
        return this.startHandleLeft != null && this.startHandleLeft.contains(p2) || this.startHandleRight != null && this.startHandleRight.contains(p2);
    }

    private HandleLocation getHandleLocation(Point p2) {
        if (this.startHandleLeft != null && this.startHandleLeft.contains(p2)) {
            return HandleLocation.START;
        }
        if (this.startHandleRight != null && this.startHandleRight.contains(p2)) {
            return HandleLocation.END;
        }
        if (this.endHandleLeft != null && this.endHandleLeft.contains(p2)) {
            return HandleLocation.START;
        }
        if (this.endHandleRight != null && this.endHandleRight.contains(p2)) {
            return HandleLocation.END;
        }
        return null;
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        if (this.isLinkStartLocation(e2.getPoint()) && this.layerContainer.isLinkingEnabled()) {
            e2.consume();
            this.linking = true;
            this.startHandle = this.getHandleLocation(e2.getPoint());
            this.repaint();
        } else {
            this.stopLinking();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
        if (this.layerContainer.isLinkingEnabled()) {
            this.createRelationship();
            this.stopLinking();
        }
    }

    private void stopLinking() {
        this.sourceBounds = null;
        this.targetBounds = null;
        this.startHandleLeft = null;
        this.startHandleRight = null;
        this.endHandleLeft = null;
        this.endHandleRight = null;
        this.startHandle = null;
        this.endHandle = null;
        this.linking = false;
        this.mouseLocation = null;
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e2) {
        if (this.sourceBounds != null && this.layerContainer.isLinkingEnabled()) {
            Rectangle rect;
            this.mouseLocation = e2.getPoint();
            ObjectBounds bounds = this.layerContainer.getObjectBoundsAt(e2.getX(), e2.getY(), this.proximity);
            if (bounds != this.targetBounds && bounds != null) {
                IPolicyProvider pp = this.getLayerPolicyProvider();
                IRelationshipPolicy rp = pp.getPolicy(IRelationshipPolicy.class);
                TimelineObjectPath path = bounds.getPath();
                IGanttChartModel model = this.getModel();
                if (rp.isRelationshipTarget(this.sourceBounds.getPath(), path, model)) {
                    this.targetBounds = bounds;
                    RelationshipType[] types = rp.getSupportedRelationshipTypes(path, model);
                    if (types == null) {
                        throw new IllegalArgumentException("relationship policy returned NULL for supported relationship types even though timeline object is a possible relationship source");
                    }
                    for (RelationshipType t2 : types) {
                        if (t2.equals((Object)RelationshipType.START_TO_END) || t2.equals((Object)RelationshipType.START_TO_START)) {
                            this.endHandleLeft = this.calculateBox(this.targetBounds, false, true);
                            this.endHandle = this.getHandleLocation(e2.getPoint());
                            continue;
                        }
                        this.endHandleRight = this.calculateBox(this.targetBounds, false, false);
                        this.endHandle = this.getHandleLocation(e2.getPoint());
                    }
                }
            }
            if (this.targetBounds != null && !(rect = this.createProximityRectangle(this.targetBounds)).contains(e2.getPoint())) {
                this.targetBounds = null;
            }
            LOGGER.fine("startHandle = " + (Object)((Object)this.startHandle) + ", endHandle = " + (Object)((Object)this.endHandle));
            this.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e2) {
        if (this.sourceBounds != null && this.layerContainer.isLinkingEnabled()) {
            this.mouseLocation = e2.getPoint();
            this.repaint();
        }
    }

    private Rectangle createProximityRectangle(Rectangle r2) {
        Rectangle rect = new Rectangle(r2);
        rect.translate(-this.proximity, -this.proximity);
        rect.grow(2 * this.proximity, 2 * this.proximity);
        return rect;
    }

    protected Rectangle calculateBox(ObjectBounds bounds, boolean source, boolean left) {
        if (bounds == null) {
            return null;
        }
        Rectangle r2 = new Rectangle();
        if (source) {
            if (left) {
                Icon icon = this.getHandleIcon(bounds, source, left, this.isFocused(bounds));
                r2.x = bounds.x - icon.getIconWidth();
                r2.y = bounds.y + bounds.height / 2 - icon.getIconHeight() / 2;
                r2.width = icon.getIconWidth();
                r2.height = icon.getIconHeight();
            } else {
                Icon icon = this.getHandleIcon(bounds, source, left, this.isFocused(bounds));
                r2.x = bounds.x + bounds.width;
                r2.y = bounds.y + bounds.height / 2 - icon.getIconHeight() / 2;
                r2.width = icon.getIconWidth();
                r2.height = icon.getIconHeight();
            }
        } else if (left) {
            Icon icon = this.getHandleIcon(bounds, source, left, this.isFocused(bounds));
            r2.x = bounds.x - icon.getIconWidth();
            r2.y = bounds.y + bounds.height / 2 - icon.getIconHeight() / 2;
            r2.width = icon.getIconWidth();
            r2.height = icon.getIconHeight();
        } else {
            Icon icon = this.getHandleIcon(bounds, source, left, this.isFocused(bounds));
            r2.x = bounds.x + bounds.width;
            r2.y = bounds.y + bounds.height / 2 - icon.getIconHeight() / 2;
            r2.width = icon.getIconWidth();
            r2.height = icon.getIconHeight();
        }
        return r2;
    }

    private void createRelationship() {
        if (this.sourceBounds != null && this.targetBounds != null) {
            IPolicyProvider pp = this.getLayerPolicyProvider();
            IRelationshipPolicy rp = pp.getPolicy(IRelationshipPolicy.class);
            IGanttChartModel model = this.getModel();
            TimelineObjectPath sourcePath = this.sourceBounds.getPath();
            TimelineObjectPath targetPath = this.targetBounds.getPath();
            if (rp.isRelationshipSource(sourcePath, model)) {
                if (rp.isRelationshipTarget(sourcePath, targetPath, model)) {
                    RelationshipType relType = this.getCurrentRelationshipType();
                    if (relType != null) {
                        ICommand cmd = rp.getCreateRelationshipCommand(sourcePath, targetPath, relType, this.layerContainer.getModel());
                        AbstractGanttChart gc2 = this.layerContainer.getGanttChart();
                        gc2.commandExecute(cmd);
                    }
                } else {
                    String msg = Messages.getString("LassoLayer.LINK_TO_TARGET_NOT_POSSIBLE");
                    String title = Messages.getString("LassoLayer.ERROR_DIALOG_TITLE");
                    JOptionPane.showMessageDialog(this.layerContainer.getGanttChart(), msg, title, 0);
                }
            } else {
                String msg = Messages.getString("LassoLayer.LINK_FROM_SOURCE_NOT_POSSIBLE");
                String title = Messages.getString("LassoLayer.ERROR_DIALOG_TITLE");
                JOptionPane.showMessageDialog(this.layerContainer.getGanttChart(), msg, title, 0);
            }
        }
    }

    private RelationshipType getCurrentRelationshipType() {
        if (this.startHandle == null || this.endHandle == null) {
            return null;
        }
        if (this.startHandle == HandleLocation.START && this.endHandle == HandleLocation.START) {
            return RelationshipType.START_TO_START;
        }
        if (this.startHandle == HandleLocation.END && this.endHandle == HandleLocation.END) {
            return RelationshipType.END_TO_END;
        }
        if (this.startHandle == HandleLocation.END && this.endHandle == HandleLocation.START) {
            return RelationshipType.END_TO_START;
        }
        if (this.startHandle == HandleLocation.START && this.endHandle == HandleLocation.END) {
            return RelationshipType.START_TO_END;
        }
        return null;
    }

    private static enum HandleLocation {
        START,
        END;

    }
}

