/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer.system;

import com.dlsc.flexgantt.model.gantt.IGanttChartModel;
import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.policy.IPolicyProvider;
import com.dlsc.flexgantt.policy.layer.IDragAndDropPolicy;
import com.dlsc.flexgantt.policy.layer.IEditTimelineObjectPolicy;
import com.dlsc.flexgantt.swing.ObjectBounds;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.system.DragLayer;
import com.dlsc.flexgantt.swing.layer.system.IEditModeController;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultEditModeController
implements IEditModeController {
    private static final Logger LOGGER = Logger.getLogger(DefaultEditModeController.class.getName());

    @Override
    public IEditModeController.EditMode getEditMode(DragLayer layer, ObjectBounds bounds, MouseEvent e2) {
        LayerContainer layerContainer = layer.getLayerContainer();
        IPolicyProvider policyProvider = layerContainer.getPolicyProvider();
        TimelineObjectPath path = bounds.getPath();
        IGanttChartModel model = bounds.getModel();
        IDragAndDropPolicy dndPolicy = policyProvider.getPolicy(IDragAndDropPolicy.class);
        IEditTimelineObjectPolicy editPolicy = policyProvider.getPolicy(IEditTimelineObjectPolicy.class);
        int dndAction = dndPolicy.getDragActions(path, model);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("drag and drop policy = " + dndPolicy);
            LOGGER.fine("timeline object edit policy = " + editPolicy);
            LOGGER.fine("supported drag actions = " + dndAction);
            LOGGER.fine("isDragLocation = " + this.isDragLocation(bounds, e2, editPolicy));
            LOGGER.fine("isChangeStartTimeLocation = " + this.isChangeStartTimeLocation(bounds, e2, editPolicy));
            LOGGER.fine("isChangeEndTimeLocation = " + this.isChangeEndTimeLocation(bounds, e2, editPolicy));
        }
        if (dndAction != 0 && this.isDragLocation(bounds, e2, editPolicy)) {
            if (editPolicy.isStartTimeChangeable(path, model)) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("returning edit mode " + (Object)((Object)IEditModeController.EditMode.CHANGE_NODE_AND_TIME_SPAN));
                }
                return IEditModeController.EditMode.CHANGE_NODE_AND_TIME_SPAN;
            }
            LOGGER.fine("returning edit mode " + (Object)((Object)IEditModeController.EditMode.CHANGE_NODE));
            return IEditModeController.EditMode.CHANGE_NODE;
        }
        if (editPolicy.isDurationChangeable(path, model) && this.isChangeEndTimeLocation(bounds, e2, editPolicy)) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("returning edit mode " + (Object)((Object)IEditModeController.EditMode.CHANGE_END_TIME));
            }
            return IEditModeController.EditMode.CHANGE_END_TIME;
        }
        if (editPolicy.isDurationChangeable(path, model) && editPolicy.isStartTimeChangeable(path, model) && this.isChangeStartTimeLocation(bounds, e2, editPolicy)) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("returning edit mode " + (Object)((Object)IEditModeController.EditMode.CHANGE_START_TIME));
            }
            return IEditModeController.EditMode.CHANGE_START_TIME;
        }
        if (editPolicy.isStartTimeChangeable(path, model) && this.isDragLocation(bounds, e2, editPolicy)) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("returning edit mode " + (Object)((Object)IEditModeController.EditMode.CHANGE_TIME_SPAN));
            }
            return IEditModeController.EditMode.CHANGE_TIME_SPAN;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("returning edit mode " + (Object)((Object)IEditModeController.EditMode.NONE));
        }
        return IEditModeController.EditMode.NONE;
    }

    protected boolean isDragLocation(ObjectBounds bounds, MouseEvent evt, IEditTimelineObjectPolicy editPolicy) {
        return bounds.contains(evt.getPoint()) && !this.isChangeEndTimeLocation(bounds, evt, editPolicy) && !this.isChangeStartTimeLocation(bounds, evt, editPolicy);
    }

    protected boolean isChangeEndTimeLocation(ObjectBounds bounds, MouseEvent evt, IEditTimelineObjectPolicy editPolicy) {
        IGanttChartModel model;
        TimelineObjectPath path = bounds.getPath();
        if (editPolicy.isDurationChangeable(path, model = bounds.getModel()) && !this.isUsingDragOverrideModifiers(evt)) {
            Point p2 = evt.getPoint();
            int rightSide = bounds.x + bounds.width - 1;
            return p2.x <= rightSide && p2.x >= rightSide - Math.min(10, bounds.width / 2);
        }
        return false;
    }

    protected boolean isChangeStartTimeLocation(ObjectBounds bounds, MouseEvent evt, IEditTimelineObjectPolicy editPolicy) {
        IGanttChartModel model;
        TimelineObjectPath path = bounds.getPath();
        if (editPolicy.isDurationChangeable(path, model = bounds.getModel()) && editPolicy.isStartTimeChangeable(path, model) && !this.isUsingDragOverrideModifiers(evt)) {
            Point p2 = evt.getPoint();
            return p2.x >= bounds.x && p2.x <= bounds.x + Math.min(10, bounds.width / 2);
        }
        return false;
    }

    protected boolean isUsingDragOverrideModifiers(MouseEvent evt) {
        return evt.isAltDown();
    }
}

