/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer;

import com.dlsc.flexgantt.command.ICommand;
import com.dlsc.flexgantt.icons.IconId;
import com.dlsc.flexgantt.icons.IconRegistry;
import com.dlsc.flexgantt.model.gantt.IGanttChartModel;
import com.dlsc.flexgantt.model.gantt.ILayer;
import com.dlsc.flexgantt.policy.IPolicyProvider;
import com.dlsc.flexgantt.policy.layer.IEditLayerPolicy;
import com.dlsc.flexgantt.swing.layer.AbstractCustomLayer;
import com.dlsc.flexgantt.swing.layer.AbstractLayer;
import com.dlsc.flexgantt.swing.layer.ILayerContainerListener;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.LayerContainerEvent;
import com.dlsc.flexgantt.swing.layer.timeline.TimelineObjectLayer;
import com.dlsc.flexgantt.util.Messages;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LayerPalette
extends Box
implements ILayerContainerListener,
PropertyChangeListener {
    private final LayerContainer lc;
    private boolean repaintingImmediately = true;

    public LayerPalette(LayerContainer lc2) {
        super(1);
        if (lc2 == null) {
            throw new IllegalArgumentException("layer container can not be NULL");
        }
        this.lc = lc2;
        this.lc.addLayerContainerListener(this);
        this.lc.addPropertyChangeListener(this);
        this.init();
    }

    public boolean isRepaintingImmediately() {
        return this.repaintingImmediately;
    }

    public void setRepaintingImmediately(boolean immediately) {
        this.repaintingImmediately = immediately;
    }

    private void init() {
        for (Component comp : this.getComponents()) {
            if (!(comp instanceof LayerPanel)) continue;
            ((LayerPanel)comp).tearDown();
        }
        this.removeAll();
        ILayer[] layers = this.lc.getLayers();
        for (int i2 = layers.length - 1; i2 >= 0; --i2) {
            if (!layers[i2].isFeatureEnabled(ILayer.Feature.SHOW_IN_PALETTE)) continue;
            AbstractLayer layerUI = null;
            layerUI = layers[i2].isCustomLayer() ? this.lc.getCustomLayer(layers[i2]) : this.lc.getTimelineObjectLayer(layers[i2]);
            if (layerUI == null) continue;
            LayerPanel lp = new LayerPanel(this.lc, layerUI, layers[i2]);
            this.add(lp);
        }
        this.add(LayerPalette.createGlue());
        JPanel buttonPanel = new JPanel(){

            @Override
            public Dimension getMaximumSize() {
                return super.getPreferredSize();
            }
        };
        buttonPanel.setLayout(new FlowLayout(1));
        buttonPanel.setOpaque(false);
        JButton showAll = new JButton(Messages.getString("LayerPalette.SHOW_ALL_BUTTON"));
        JButton hideAll = new JButton(Messages.getString("LayerPalette.HIDE_ALL_BUTTON"));
        showAll.setOpaque(false);
        hideAll.setOpaque(false);
        final LayerContainer flc = this.lc;
        showAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                for (ILayer layer : flc.getLayers()) {
                    flc.showLayer(layer);
                }
            }
        });
        hideAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                for (ILayer layer : flc.getLayers()) {
                    flc.hideLayer(layer);
                }
            }
        });
        buttonPanel.add("West", showAll);
        buttonPanel.add("East", hideAll);
        this.add(buttonPanel);
        this.revalidate();
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(super.getMaximumSize().width, super.getPreferredSize().height);
    }

    @Override
    public void layerContainerChanged(LayerContainerEvent evt) {
        this.init();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource().equals(this.lc) && evt.getPropertyName().equals("model")) {
            this.init();
        }
    }

    private class LayerPanel
    extends JPanel
    implements PropertyChangeListener {
        private final JCheckBox box;
        private final AbstractLayer layer;
        private final JSlider slider;

        public LayerPanel(final LayerContainer lc2, final AbstractLayer layerUI, final ILayer layer) {
            this.layer = layerUI;
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.box = new JCheckBox(layerUI.getName());
            this.box.setSelected(layerUI.isVisible());
            this.box.setOpaque(false);
            this.slider = new JSlider(0, 0, 100, (int)(layerUI.getAlpha() * 100.0f));
            this.slider.setPreferredSize(new Dimension(100, 20));
            this.slider.setOpaque(false);
            this.add("Center", this.box);
            JPanel controls = new JPanel();
            FlowLayout fl = new FlowLayout(0);
            controls.setLayout(fl);
            controls.add(this.slider);
            controls.setOpaque(false);
            this.add("East", controls);
            this.box.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    if (LayerPanel.this.box.isSelected()) {
                        lc2.showLayer(layer);
                    } else {
                        lc2.hideLayer(layer);
                    }
                }
            });
            this.slider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e2) {
                    if (LayerPalette.this.isRepaintingImmediately() || !LayerPanel.this.slider.getValueIsAdjusting()) {
                        layerUI.setAlpha((float)LayerPanel.this.slider.getValue() / 100.0f);
                    }
                }
            });
            ILayer modelLayer = null;
            if (layerUI instanceof TimelineObjectLayer) {
                TimelineObjectLayer tol = (TimelineObjectLayer)layerUI;
                modelLayer = tol.getLayer();
            } else if (layerUI instanceof AbstractCustomLayer) {
                AbstractCustomLayer acl = (AbstractCustomLayer)layerUI;
                modelLayer = acl.getLayer();
            }
            this.add("West", new JLabel(lc2.getLayerIcon(modelLayer)));
            if (modelLayer != null) {
                ILayer[] layers;
                if (!modelLayer.isFeatureEnabled(ILayer.Feature.TRANSPARENCY)) {
                    this.slider.setVisible(false);
                }
                JLabel upButton = new JLabel("");
                upButton.setIcon(IconRegistry.getIcon(IconId.ARROW_UP));
                upButton.setOpaque(false);
                JLabel downButton = new JLabel("");
                downButton.setIcon(IconRegistry.getIcon(IconId.ARROW_DOWN));
                downButton.setOpaque(false);
                controls.add(upButton);
                controls.add(downButton);
                IPolicyProvider pp = lc2.getPolicyProvider();
                final IEditLayerPolicy ep = pp.getPolicy(IEditLayerPolicy.class);
                final IGanttChartModel model = lc2.getModel();
                final ILayer fModelLayer = modelLayer;
                if (modelLayer.isFeatureEnabled(ILayer.Feature.DELETION)) {
                    JLabel deleteButton = new JLabel("");
                    deleteButton.setOpaque(false);
                    deleteButton.setIcon(IconRegistry.getIcon(IconId.DELETE));
                    controls.add(deleteButton);
                    deleteButton.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent e2) {
                            ICommand cmd = ep.getRemoveLayerCommand(fModelLayer, model);
                            lc2.getGanttChart().commandExecute(cmd);
                        }
                    });
                }
                if (modelLayer == (layers = lc2.getLayers())[0]) {
                    downButton.setIcon(new Icon(){
                        private final Icon icon = IconRegistry.getIcon(IconId.ARROW_DOWN);

                        @Override
                        public int getIconHeight() {
                            return this.icon.getIconHeight();
                        }

                        @Override
                        public int getIconWidth() {
                            return this.icon.getIconWidth();
                        }

                        @Override
                        public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
                        }
                    });
                } else {
                    downButton.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent e2) {
                            lc2.moveBack(fModelLayer);
                        }
                    });
                }
                if (modelLayer == layers[layers.length - 1]) {
                    upButton.setIcon(new Icon(){
                        private final Icon icon = IconRegistry.getIcon(IconId.ARROW_UP);

                        @Override
                        public int getIconHeight() {
                            return this.icon.getIconHeight();
                        }

                        @Override
                        public int getIconWidth() {
                            return this.icon.getIconWidth();
                        }

                        @Override
                        public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
                        }
                    });
                } else {
                    upButton.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent e2) {
                            lc2.moveForward(fModelLayer);
                        }
                    });
                }
            }
            layerUI.addPropertyChangeListener(this);
        }

        @Override
        public Dimension getMaximumSize() {
            return new Dimension(super.getMaximumSize().width, super.getPreferredSize().height);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("visible")) {
                this.box.setSelected(this.layer.isVisible());
            } else if (evt.getPropertyName().equals("alpha")) {
                this.slider.setValue((int)(this.layer.getAlpha() * 100.0f));
            }
        }

        public void tearDown() {
            this.layer.removePropertyChangeListener(this);
        }
    }
}

