/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.dateline.DatelineModelEvent;
import com.dlsc.flexgantt.model.dateline.IDatelineModel;
import com.dlsc.flexgantt.model.dateline.IDatelineModelListener;
import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.IComponentFactory;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.LayerContainerRowHeader;
import com.dlsc.flexgantt.swing.layer.LayerContainerScrollPaneLayout;
import com.dlsc.flexgantt.swing.timeline.Dateline;
import com.dlsc.flexgantt.swing.timeline.Eventline;
import com.dlsc.flexgantt.swing.timeline.Timeline;
import com.dlsc.flexgantt.swing.treetable.TreeTable;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.border.Border;

public class LayerContainerScrollPane
extends JScrollPane
implements IDatelineModelListener,
PropertyChangeListener {
    private LayerContainer layerContainer;
    private Timeline timeline;
    private boolean primary;
    private AbstractGanttChart ganttChart;
    private ITimeSpan previousSpan;

    public LayerContainerScrollPane(LayerContainer lc2, LayerContainerRowHeader rowHeader, Timeline timeline, boolean primary) {
        String[] corners;
        this.layerContainer = lc2;
        this.layerContainer.addPropertyChangeListener(this);
        this.timeline = timeline;
        this.primary = primary;
        this.ganttChart = lc2.getGanttChart();
        this.setLayout(new LayerContainerScrollPaneLayout());
        IComponentFactory compFactory = this.ganttChart.getComponentFactory();
        for (String str : corners = new String[]{"UPPER_LEFT_CORNER", "UPPER_RIGHT_CORNER", "LOWER_LEFT_CORNER", "LOWER_RIGHT_CORNER"}) {
            this.setCorner(str, compFactory.createLayerContainerCorner(lc2, str));
        }
        if (primary) {
            this.setColumnHeaderView(timeline);
        }
        this.setRowHeaderView(rowHeader);
        this.getRowHeader().setVisible(false);
        this.setWheelScrollingEnabled(true);
        this.setViewportView(lc2);
        this.setHorizontalScrollBarPolicy(32);
        this.setVerticalScrollBarPolicy(22);
        this.getViewport().setScrollMode(1);
        if (this.getColumnHeader() != null) {
            this.getColumnHeader().setScrollMode(1);
        }
        this.getHorizontalScrollBar().setEnabled(!this.ganttChart.isTimeNowScrolling());
        Dateline dateline = timeline.getDateline();
        dateline.addPropertyChangeListener(this);
        IDatelineModel model = dateline.getModel();
        model.addDatelineModelListener(this);
        Eventline eventline = timeline.getEventline();
        eventline.addPropertyChangeListener(this);
        this.ganttChart.addPropertyChangeListener(this);
        this.getRowHeader().setScrollMode(1);
        this.updateUnitIncrements();
    }

    public LayerContainer getLayerContainer() {
        return this.layerContainer;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    @Override
    public Dimension getMinimumSize() {
        int width = this.getVerticalScrollBar().getPreferredSize().width;
        int height = 0;
        height = this.primary ? this.timeline.getPreferredSize().height : this.getHorizontalScrollBar().getPreferredSize().height;
        Border border = this.getBorder();
        if (border != null) {
            Insets insets = this.getBorder().getBorderInsets(this);
            width += insets.right + insets.left;
            height += insets.top + insets.bottom;
        }
        return new Dimension(width, height);
    }

    public Timeline getTimeline() {
        return this.timeline;
    }

    @Override
    public void datelineModelWillChange(DatelineModelEvent evt) {
        this.previousSpan = null;
        switch (evt.getId()) {
            case GRANULARITY_CHANGED: 
            case TIME_SPAN_CHANGED: 
            case TIME_ZONE_CHANGED: 
            case ZOOM_CHANGED: {
                Dateline dateline = this.timeline.getDateline();
                if (!dateline.isShowing()) break;
                this.previousSpan = dateline.getVisibleTimeSpan();
                break;
            }
        }
    }

    @Override
    public void datelineModelChanged(DatelineModelEvent e2) {
        switch (e2.getId()) {
            case DATELINE_WIDTH_CHANGED: {
                this.timeline.setSize(this.timeline.getPreferredSize());
                this.layerContainer.setSize(this.layerContainer.getPreferredSize());
                this.timeline.invalidate();
                this.layerContainer.invalidate();
                this.validate();
                this.adjustViewportLocation();
                break;
            }
            case REQUESTED_VISIBLE_TIME_SPAN_CHANGED: {
                if (!this.isPrimary()) break;
                ITimeSpan requested = e2.getRequestedVisibleTimeSpan();
                long center = requested.getStartTime() + requested.getDuration() / 2L;
                this.ganttChart.showTime(center, true);
                break;
            }
            case GRANULARITY_CHANGED: 
            case TIME_SPAN_CHANGED: 
            case TIME_ZONE_CHANGED: 
            case ZOOM_CHANGED: 
            case SELECTED_TIME_SPAN_CHANGED: {
                this.repaint();
            }
        }
        this.updateUnitIncrements();
    }

    private void adjustViewportLocation() {
        Dateline dateline = this.timeline.getDateline();
        if (this.previousSpan != null) {
            switch (dateline.getZoomStrategy()) {
                case CHANGE_VISIBLE_END_TIME: {
                    this.ganttChart.showTime(this.previousSpan.getStartTime(), false);
                    break;
                }
                case CHANGE_VISIBLE_START_AND_END_TIME: {
                    long start = this.previousSpan.getStartTime();
                    long end = this.previousSpan.getEndTime();
                    long center = start + (end - start) / 2L;
                    this.ganttChart.showTime(center, true);
                }
            }
        }
    }

    private void updateUnitIncrements() {
        IDatelineModel model = this.ganttChart.getDatelineModel();
        ITimeSpan span = model.getTimeSpanAt(0, false);
        int x1 = model.getTimeLocation(span.getStartTime());
        int x2 = model.getTimeLocation(span.getEndTime());
        JScrollBar hBar = this.getHorizontalScrollBar();
        hBar.setUnitIncrement(x2 - x1);
        TreeTable table = this.layerContainer.getTreeTable();
        JScrollBar vBar = this.getVerticalScrollBar();
        vBar.setUnitIncrement(table.getDefaultRowHeight());
    }

    public LayerContainerRowHeader getLayerContainerRowHeader() {
        return (LayerContainerRowHeader)this.getRowHeader().getView();
    }

    public AbstractGanttChart getGanttChart() {
        return this.ganttChart;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource().equals(this.timeline.getDateline())) {
            if (evt.getPropertyName().equals("datelineModel")) {
                IDatelineModel oldModel = (IDatelineModel)evt.getOldValue();
                oldModel.removeDatelineModelListener(this);
                IDatelineModel newModel = (IDatelineModel)evt.getNewValue();
                newModel.addDatelineModelListener(this);
            }
        } else if (evt.getSource().equals(this.timeline.getEventline())) {
            if (this.ganttChart.isTimeNowScrolling() && evt.getPropertyName().equals("timeNow")) {
                long timeNow = this.timeline.getEventline().getTimeNow();
                int x2 = this.timeline.getDateline().getTimeLocation(timeNow);
                Rectangle visible = this.layerContainer.getVisibleRect();
                this.layerContainer.scrollRectToVisible(new Rectangle(x2 - visible.width / 2, visible.y, visible.width, visible.height));
            }
        } else if (evt.getSource().equals(this.ganttChart)) {
            if (evt.getPropertyName().equals("timeNowScrolling")) {
                this.getHorizontalScrollBar().setEnabled(!this.ganttChart.isTimeNowScrolling());
            }
        } else if (evt.getSource().equals(this.layerContainer) && evt.getPropertyName().equals("gridGranularity")) {
            this.invalidate();
            this.validate();
        }
    }
}

