/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer;

import com.dlsc.flexgantt.model.gantt.CapacityLine;
import com.dlsc.flexgantt.model.gantt.IResourceNode;
import com.dlsc.flexgantt.swing.layer.DefaultLayerContainerRowHeaderRenderer;
import com.dlsc.flexgantt.swing.layer.LayerContainerRowHeader;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.List;

public class DefaultResourceNodeRowHeaderRenderer
extends DefaultLayerContainerRowHeaderRenderer {
    private IResourceNode resourceNode;

    @Override
    public Component getRowHeaderRendererComponent(LayerContainerRowHeader header, Object node, Object value, int depth, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus, boolean newNodePosition) {
        super.getRowHeaderRendererComponent(header, node, value, depth, selected, expanded, leaf, row, hasFocus, newNodePosition);
        this.resourceNode = (IResourceNode)value;
        return this;
    }

    @Override
    protected void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        g2.setColor(this.getForeground());
        this.paintLines(g2, false);
        this.paintLines(g2, true);
    }

    protected void paintLines(Graphics g2, boolean major) {
        Graphics2D g2d = (Graphics2D)g2.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int width = this.getWidth();
        int height = this.getHeight();
        List<CapacityLine> capLines = this.resourceNode.getCapacityLines(height, major);
        int xx = width - 3;
        for (CapacityLine line : capLines) {
            String label;
            int y2 = this.resourceNode.getCapacityLocation(height, line.getCapacity());
            if (major) {
                g2d.drawLine(xx - 5, y2, xx, y2);
            } else {
                g2d.drawLine(xx - 2, y2, xx, y2);
            }
            if ((label = line.getLabel()) == null) continue;
            FontMetrics fm = g2d.getFontMetrics();
            int strWidth = fm.stringWidth(label);
            int ascent = fm.getAscent();
            int strLocation = Math.min(height - 3, Math.max(ascent, y2 + ascent / 2));
            g2d.drawString(label, xx - strWidth - 5, strLocation);
        }
        g2d.dispose();
    }

    protected Color getLineColor(CapacityLine line) {
        LayerContainerRowHeader header = this.getRowHeader();
        return header.getForeground();
    }
}

