/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing;

import com.dlsc.flexgantt.swing.IMessage;
import com.dlsc.flexgantt.swing.MessageTypeId;
import java.util.Calendar;
import java.util.Date;

public class Message
implements IMessage {
    private MessageTypeId id;
    private String text;
    private Date time;
    private Object details;

    public Message(MessageTypeId id2, String text, Object details, Date time) {
        if (id2 == null) {
            throw new IllegalArgumentException("message ID can not be NULL");
        }
        if (text == null) {
            throw new IllegalArgumentException("message text can not be NULL");
        }
        if (time == null) {
            throw new IllegalArgumentException("message time can not be NULL");
        }
        this.id = id2;
        this.text = text;
        this.details = details;
        this.time = new Date(time.getTime());
    }

    public Message(MessageTypeId id2, String text, Date time) {
        this(id2, text, null, time);
    }

    public Message(MessageTypeId id2, String text, Object details) {
        this(id2, text, details, Calendar.getInstance().getTime());
    }

    public Message(MessageTypeId id2, String text) {
        this(id2, text, null, Calendar.getInstance().getTime());
    }

    public Message(String text, Object details) {
        this(MessageTypeId.ERROR, text, details, Calendar.getInstance().getTime());
    }

    public Message(String text) {
        this(MessageTypeId.INFORMATION, text, null, Calendar.getInstance().getTime());
    }

    @Override
    public MessageTypeId getMessageTypeId() {
        return this.id;
    }

    @Override
    public String getMessageText() {
        return this.text;
    }

    @Override
    public Object getMessageDetails() {
        return this.details;
    }

    @Override
    public Date getMessageTime() {
        return new Date(this.time.getTime());
    }

    public String toString() {
        return this.getMessageText();
    }
}

