/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing;

import com.dlsc.flexgantt.command.AbstractCompoundCommand;
import com.dlsc.flexgantt.command.CommandStackEvent;
import com.dlsc.flexgantt.command.ICommand;
import com.dlsc.flexgantt.command.ICommandStack;
import com.dlsc.flexgantt.command.ICommandStackListener;
import com.dlsc.flexgantt.model.treetable.ITreeTableModel;
import com.dlsc.flexgantt.model.treetable.ITreeTableModelListener;
import com.dlsc.flexgantt.model.treetable.TreeTableModelEvent;
import com.dlsc.flexgantt.policy.IPolicyProvider;
import com.dlsc.flexgantt.policy.treetable.INodeEditPolicy;
import com.dlsc.flexgantt.policy.treetable.IRowPolicy;
import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.DefaultRowHeaderMenuProvider;
import com.dlsc.flexgantt.swing.GanttChartControl;
import com.dlsc.flexgantt.swing.treetable.DefaultTreeTableSelectionModel;
import com.dlsc.flexgantt.swing.treetable.IRowHeaderMenuProvider;
import com.dlsc.flexgantt.swing.treetable.IRowHeaderRenderer;
import com.dlsc.flexgantt.swing.treetable.ITreeTableSelectionModel;
import com.dlsc.flexgantt.swing.treetable.TreeTable;
import com.dlsc.flexgantt.swing.treetable.TreeTableNode;
import com.dlsc.flexgantt.swing.util.ColorUtil;
import com.dlsc.flexgantt.swing.util.CustomizableLineBorder;
import com.dlsc.flexgantt.swing.util.GraphicsUtilities;
import com.dlsc.flexgantt.swing.util.TableUtils;
import com.dlsc.flexgantt.util.Messages;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.CellRendererPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class AbstractRowHeader<T extends IRowHeaderRenderer>
extends GanttChartControl
implements ITreeTableModelListener,
ICommandStackListener,
TreeExpansionListener,
MouseListener,
MouseMotionListener,
PropertyChangeListener,
TreeSelectionListener {
    private static final Cursor CURSOR_DEFAULT = new Cursor(0);
    private static final Cursor CURSOR_RESIZE = new Cursor(8);
    private TreeTable table;
    private int dragStart = -1;
    private int dragEnd = -1;
    private TreeTableNode dragNode;
    private boolean dragShift;
    private CellRendererPane rendererPane = new CellRendererPane();
    private int focusRow = -1;
    private Color gridColor = ColorUtil.getGridColor();
    private Map<Class, T> rendererMap = new HashMap<Class, T>(10);
    private Map<Class, T> rendererCache = new HashMap<Class, T>();
    private IRowHeaderMenuProvider menuProvider;
    private JPopupMenu popup;
    private boolean focusEnabled = false;

    protected AbstractRowHeader(TreeTable table) {
        super(table.getGanttChart());
        this.table = table;
        this.table.getModel().addTreeTableModelListener(this);
        this.table.addTreeExpansionListener(this);
        this.table.addPropertyChangeListener(this);
        this.table.getSelectionModel().addTreeSelectionListener(this);
        AbstractGanttChart gc2 = this.getGanttChart();
        gc2.getCommandStack().addCommandStackListener(this);
        gc2.addPropertyChangeListener(this);
        this.setCursor(CURSOR_DEFAULT);
        this.setOpaque(true);
        this.setLayout(null);
        this.setBorder(new CustomizableLineBorder(false, false, false, true));
        this.add(this.rendererPane);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(table);
        this.setMenuProvider(new DefaultRowHeaderMenuProvider());
    }

    public void setFocusEnabled(boolean enabled) {
        this.focusEnabled = enabled;
    }

    public boolean isFocusEnabled() {
        return this.focusEnabled;
    }

    public TreeTable getTreeTable() {
        return this.table;
    }

    @Override
    protected void paintComponent(Graphics g2) {
        int row;
        super.paintComponent(g2);
        Graphics2D g2d = (Graphics2D)g2;
        Rectangle clip = g2d.getClipBounds();
        List<TreeTableNode> nodes = this.table.getTreeTableNodes();
        int w2 = this.getWidth();
        int y2 = 0;
        int fadeCount = 0;
        Composite comp = g2d.getComposite();
        if (row != -1) {
            if (nodes != null && row < nodes.size()) {
                TreeTableNode node = nodes.get(row);
                y2 = node.getY();
                int clipLine = 0;
                boolean drawShadow = false;
                for (row = this.table.getRowAt(Math.max(0, clip.y)); row < nodes.size(); ++row) {
                    if (this.table.getNodeAnimationController().isUsingTransparency() && fadeCount > 0) {
                        g2d.setComposite(AlphaComposite.getInstance(3, (float)this.table.getAnimationPercentage()));
                    }
                    --fadeCount;
                    node = nodes.get(row);
                    int rowHeight = node.getHeight();
                    g2.clipRect(0, Math.max(clipLine, y2), this.getWidth(), this.getHeight());
                    this.paintCellRenderer(g2, node, 0, y2, w2, rowHeight - 1, row);
                    g2.setColor(this.gridColor);
                    g2d.setComposite(comp);
                    g2.drawLine(0, (y2 += rowHeight) - 1, w2, y2 - 1);
                    if (y2 > clip.y + clip.height) break;
                    TreeTableNode animationNode = this.table.getAnimationNode();
                    if (node != animationNode) continue;
                    fadeCount = animationNode.getTotalChildrenCount();
                    drawShadow = true;
                    clipLine = y2;
                    y2 -= (int)((double)animationNode.getTotalChildrenHeight() * (1.0 - this.table.getAnimationPercentage()));
                }
                g2d.setClip(clip);
                fadeCount = 0;
                if (drawShadow && this.table.getNodeAnimationController().isShadowVisible()) {
                    GraphicsUtilities.drawDropShadow(this, g2d, 0, clipLine, this.getWidth());
                }
            }
        } else {
            row = this.table.getRowCount();
        }
        this.paintUnusedRows(g2, clip, y2, row);
        g2.setClip(clip);
    }

    protected void paintUnusedRows(Graphics g2, Rectangle clip, int y2, int row) {
        int w2 = this.getWidth();
        int defaultRowHeight = this.table.getDefaultRowHeight();
        do {
            this.paintUnusedRow(g2, y2, w2, defaultRowHeight, row);
            g2.setColor(this.gridColor);
            g2.drawLine(0, y2 - 1, w2, y2 - 1);
            ++row;
        } while ((y2 += defaultRowHeight) <= clip.y + clip.height);
    }

    protected void paintUnusedRow(Graphics g2, int y2, int width, int height, int row) {
    }

    private void paintCellRenderer(Graphics g2, TreeTableNode node, int x2, int y2, int width, int height, int row) {
        Object modelNode = node.getModelNode();
        Object headerValue = this.getGanttChart().getModel().getRowHeaderValue(modelNode);
        if (headerValue == null) {
            throw new IllegalArgumentException("header values may never be NULL, affected node = " + modelNode);
        }
        AbstractRowHeader renderer = this.getRowHeaderRenderer(headerValue.getClass());
        boolean focused = this.isFocused(row);
        Component comp = renderer.getRowHeaderRendererComponent((AbstractRowHeader)this, node.getModelNode(), headerValue, node.getDepth(), this.table.isPathSelected(node.getPath()), node.isExpanded(), node.isLeaf(), row, focused, node.isNewEntryPlaceholder());
        this.rendererPane.paintComponent(g2, comp, this, x2, y2, width, height, true);
    }

    protected boolean isFocused(int row) {
        if (this.dragStart != -1 && this.dragEnd != -1) {
            TreeTableNode node = this.table.getTreeTableNodes().get(row);
            int y1 = node.getY();
            int h2 = node.getHeight();
            int y2 = y1 + h2;
            int min = Math.min(this.dragStart, this.dragEnd);
            int max = Math.max(this.dragStart, this.dragEnd);
            if (y1 >= min && y1 <= max || y2 >= min && y2 <= max || y1 >= min && y2 <= max || y1 < min && y2 > max) {
                return true;
            }
        }
        if (row == this.focusRow) {
            return this.isFocusEnabled();
        }
        return false;
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
        if (e2.getSource().equals(this) && !this.maybeShowPopup(e2) && SwingUtilities.isLeftMouseButton(e2)) {
            int row = this.table.getRowAt(e2.getY());
            if (row == -1) {
                if (!e2.isShiftDown() && !e2.isControlDown()) {
                    this.table.clearSelection();
                }
            } else {
                List<TreeTableNode> nodes = this.table.getTreeTableNodes();
                if (this.getCursor().equals(CURSOR_DEFAULT) && e2.getClickCount() == 1) {
                    TreePath path;
                    ITreeTableSelectionModel selectionModel;
                    TreeTableNode node = nodes.get(row);
                    if (this.table.isEditing()) {
                        this.table.getCellEditor().stopCellEditing();
                    }
                    if ((selectionModel = this.table.getSelectionModel()).isPathSelected(path = node.getPath())) {
                        if (e2.isControlDown()) {
                            this.table.removeSelectionPath(path);
                        } else if (!e2.isShiftDown()) {
                            this.table.clearSelection();
                        } else {
                            int leadRow = Math.max(0, selectionModel.getLeadSelectionRow());
                            int lastRow = this.table.getRowsForPaths(new TreePath[]{path})[0];
                            this.addSelectionInterval(leadRow, lastRow);
                        }
                    } else {
                        int leadRow = Math.max(0, selectionModel.getLeadSelectionRow());
                        int lastRow = this.table.getRowsForPaths(new TreePath[]{path})[0];
                        if (e2.isShiftDown()) {
                            this.addSelectionInterval(leadRow, lastRow);
                        } else if (e2.isControlDown()) {
                            IPolicyProvider pp = this.table.getPolicyProvider();
                            INodeEditPolicy nep = pp.getPolicy(INodeEditPolicy.class);
                            if (nep.isSelectable(path.getLastPathComponent(), this.table.getModel())) {
                                this.table.addSelectionPath(path);
                            }
                        } else {
                            this.table.setSelectionPath(path);
                        }
                    }
                }
            }
        }
    }

    private void addSelectionInterval(int leadRow, int lastRow) {
        int a2 = Math.min(leadRow, lastRow);
        int b2 = Math.max(leadRow, lastRow);
        LinkedList<TreePath> pathList = new LinkedList<TreePath>();
        IPolicyProvider pp = this.table.getPolicyProvider();
        INodeEditPolicy nep = pp.getPolicy(INodeEditPolicy.class);
        for (int i2 = a2; i2 <= b2; ++i2) {
            TreePath treePath = this.table.getTreePath(i2);
            if (!nep.isSelectable(treePath.getLastPathComponent(), this.table.getModel())) continue;
            pathList.add(treePath);
        }
        int listSize = pathList.size();
        if (listSize > 0) {
            TreePath[] selectionPaths = new TreePath[listSize];
            pathList.toArray(selectionPaths);
            this.table.addSelectionPaths(selectionPaths);
        }
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        this.getGanttChart().requestFocus();
        if (e2.getSource().equals(this)) {
            this.getGanttChart().requestFocusInWindow();
            this.dragStart = e2.getY();
            if (!this.maybeShowPopup(e2) && SwingUtilities.isLeftMouseButton(e2) && this.getCursor() == CURSOR_RESIZE) {
                this.dragNode = this.table.getTreeTableNodeAt(e2.getY());
                this.dragShift = e2.isShiftDown();
            }
            this.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
        if (e2.getSource().equals(this)) {
            if (!this.maybeShowPopup(e2) && this.getCursor() == CURSOR_RESIZE) {
                AbstractGanttChart gc2 = this.getGanttChart();
                gc2.setRowResizePosition(-1);
                IPolicyProvider provider = this.table.getPolicyProvider();
                IRowPolicy rp = provider.getPolicy(IRowPolicy.class);
                ITreeTableModel model = this.table.getModel();
                Object obj = this.dragNode.getModelNode();
                int newHeight = this.getResizedHeight(e2, this.dragNode);
                InternalRowResizeCompoundCommand cc2 = new InternalRowResizeCompoundCommand(Messages.getString("AbstractRowHeader.InternalRowResizeCompoundCommand.NAME"), this);
                if (this.dragShift) {
                    ITreeTableSelectionModel selModel = this.table.getSelectionModel();
                    if (selModel.getSelectionCount() > 0) {
                        for (TreePath path : selModel.getSelectionPaths()) {
                            Object modelObject = path.getLastPathComponent();
                            int height = this.assertProposedHeightWithinAllowedBounds(modelObject, newHeight);
                            ICommand rc2 = rp.getRowResizeCommand(modelObject, model, height);
                            cc2.addCommand(rc2);
                        }
                    } else {
                        List<TreeTableNode> nodes = this.table.getTreeTableNodes();
                        for (TreeTableNode element : nodes) {
                            Object modelObject = element.getModelNode();
                            int height = this.assertProposedHeightWithinAllowedBounds(modelObject, newHeight);
                            ICommand rc3 = rp.getRowResizeCommand(modelObject, model, height);
                            cc2.addCommand(rc3);
                            this.table.setDefaultRowHeight(height);
                        }
                    }
                } else {
                    cc2.addCommand(rp.getRowResizeCommand(obj, model, newHeight));
                }
                this.getGanttChart().commandExecute(cc2);
            } else {
                int max;
                int min;
                TreeTableNode[] nodes;
                if (this.dragStart != -1 && this.dragEnd != -1 && (nodes = this.table.getTreeTableNodesBetween(min = Math.min(this.dragStart, this.dragEnd), max = Math.max(this.dragStart, this.dragEnd))) != null) {
                    if (!e2.isShiftDown() && !e2.isControlDown()) {
                        this.table.clearSelection();
                    }
                    IPolicyProvider pp = this.table.getPolicyProvider();
                    INodeEditPolicy nep = pp.getPolicy(INodeEditPolicy.class);
                    for (TreeTableNode node : nodes) {
                        if (!nep.isSelectable(node.getModelNode(), this.table.getModel())) continue;
                        this.table.addSelectionPath(node.getPath());
                    }
                }
                this.dragStart = -1;
                this.dragEnd = -1;
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
    }

    @Override
    public void mouseExited(MouseEvent e2) {
        if (e2.getSource().equals(this)) {
            this.focusRow = -1;
            this.repaint();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e2) {
        if (e2.getSource().equals(this)) {
            if (this.getCursor() == CURSOR_RESIZE) {
                AbstractGanttChart gc2 = this.getGanttChart();
                Point p1 = gc2.getLocationOnScreen();
                Point p2 = this.getLocationOnScreen();
                gc2.setRowResizePosition(e2.getY() + (p2.y - p1.y));
            } else {
                this.dragEnd = e2.getY();
                this.repaint();
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e2) {
        if (e2.getSource().equals(this)) {
            int row = this.table.getRowAt(e2.getY());
            if (row != -1) {
                List<TreeTableNode> nodes = this.table.getTreeTableNodes();
                TreeTableNode node = nodes.get(row);
                Object modelNode = node.getModelNode();
                IPolicyProvider provider = this.table.getPolicyProvider();
                IRowPolicy rp = provider.getPolicy(IRowPolicy.class);
                if (this.table.isResizingEnabled() && e2.getY() >= node.getY() + node.getHeight() - 4 && rp.isRowResizable(modelNode, this.table.getModel())) {
                    this.setCursor(CURSOR_RESIZE);
                    return;
                }
            }
            if (row != this.focusRow) {
                this.focusRow = row;
                this.repaint();
            }
            this.setCursor(CURSOR_DEFAULT);
        }
    }

    private int getResizedHeight(MouseEvent e2, TreeTableNode node) {
        int dragDelta = e2.getY() - this.dragStart;
        IPolicyProvider provider = this.table.getPolicyProvider();
        IRowPolicy rp = provider.getPolicy(IRowPolicy.class);
        Object obj = node.getModelNode();
        ITreeTableModel model = this.table.getModel();
        int height = rp.getRowHeight(obj, model) + dragDelta;
        return this.assertProposedHeightWithinAllowedBounds(node.getModelNode(), height);
    }

    private int assertProposedHeightWithinAllowedBounds(Object obj, int height) {
        IPolicyProvider provider = this.table.getPolicyProvider();
        IRowPolicy rp = provider.getPolicy(IRowPolicy.class);
        ITreeTableModel model = this.table.getModel();
        int heightMinimum = rp.getRowHeightMinimum(obj, model);
        int heightMaximum = rp.getRowHeightMaximum(obj, model);
        int result = Math.max(2, Math.max(height, heightMinimum));
        if (heightMaximum > 0) {
            result = Math.max(2, Math.min(height, heightMaximum));
        }
        return result;
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractRowHeader.this.revalidate();
                AbstractRowHeader.this.repaint();
            }
        });
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractRowHeader.this.revalidate();
                AbstractRowHeader.this.repaint();
            }
        });
    }

    @Override
    public void commandStackChanged(CommandStackEvent evt) {
        switch (evt.getId()) {
            case COMMAND_EXECUTED: 
            case COMMAND_FAILED: 
            case COMMAND_UNDONE: {
                ICommand cmd = evt.getCommand();
                Class<?> cl = cmd.getClass();
                if (cl.equals(InternalRowResizeCompoundCommand.class)) {
                    InternalRowResizeCompoundCommand cc2 = (InternalRowResizeCompoundCommand)cmd;
                    if (!cc2.getRowHeader().equals(this)) break;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AbstractRowHeader.this.table.updateNodes();
                            AbstractRowHeader.this.revalidate();
                            AbstractRowHeader.this.repaint();
                        }
                    });
                    break;
                }
                this.repaint();
                break;
            }
            case COMMAND_CANCELED: 
            case COMMAND_STARTED: {
                this.repaint();
            }
        }
    }

    @Override
    public void treeNodeKeyChanged(TreeTableModelEvent e2) {
    }

    @Override
    public void treeNodeValueChanged(TreeTableModelEvent e2) {
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e2) {
        this.repaint();
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e2) {
        this.revalidate();
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e2) {
        this.revalidate();
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e2) {
        this.revalidate();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if (evt.getSource().equals(this.table)) {
            if (evt.getPropertyName().equals("treeTableModel")) {
                ITreeTableModel oldModel = (ITreeTableModel)evt.getOldValue();
                ITreeTableModel newModel = (ITreeTableModel)evt.getNewValue();
                oldModel.removeTreeTableModelListener(this);
                newModel.addTreeTableModelListener(this);
                this.repaint();
            } else if (evt.getPropertyName().equals("treeTableSelectionModel")) {
                DefaultTreeTableSelectionModel oldModel = (DefaultTreeTableSelectionModel)evt.getOldValue();
                DefaultTreeTableSelectionModel newModel = (DefaultTreeTableSelectionModel)evt.getNewValue();
                oldModel.removeTreeSelectionListener(this);
                newModel.addTreeSelectionListener(this);
            } else if (evt.getPropertyName().equals("creationEnabled")) {
                this.repaint();
            } else if (evt.getPropertyName().equals("rootVisible")) {
                this.repaint();
            }
        } else if (evt.getSource().equals(this.getGanttChart()) && evt.getPropertyName().equals("commandStack")) {
            ICommandStack oldStack = (ICommandStack)evt.getOldValue();
            ICommandStack newStack = (ICommandStack)evt.getNewValue();
            oldStack.removeCommandStackListener(this);
            newStack.addCommandStackListener(this);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e2) {
        TableUtils.repaintAfterValueChanged(this, this.table, e2);
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setGridColor(Color color) {
        this.gridColor = color;
    }

    public void setRowHeaderRenderer(Class objectType, T renderer) {
        if (objectType == null) {
            throw new IllegalArgumentException("the row value object type can not be NULL");
        }
        if (renderer == null) {
            throw new IllegalArgumentException("the row header renderer can not be NULL");
        }
        this.rendererCache.clear();
        this.rendererMap.put(objectType, renderer);
    }

    public T getRowHeaderRenderer(Class cl) {
        if (cl == null) {
            return null;
        }
        IRowHeaderRenderer renderer = (IRowHeaderRenderer)this.rendererCache.get(cl);
        if (renderer != null) {
            return (T)renderer;
        }
        renderer = (IRowHeaderRenderer)this.rendererMap.get(cl);
        if (renderer != null) {
            this.rendererCache.put(cl, renderer);
            return (T)renderer;
        }
        renderer = this.getRowHeaderRenderer(cl.getSuperclass());
        this.rendererCache.put(cl, renderer);
        return (T)renderer;
    }

    public IRowHeaderMenuProvider getMenuProvider() {
        return this.menuProvider;
    }

    public void setMenuProvider(IRowHeaderMenuProvider provider) {
        this.menuProvider = provider;
    }

    protected boolean maybeShowPopup(MouseEvent evt) {
        if (evt.isPopupTrigger() && !evt.isConsumed()) {
            ITreeTableSelectionModel selectionModel;
            int row = this.table.getRowAt(evt.getY());
            TreePath path = null;
            if (row > -1) {
                path = this.table.getTreePath(row);
            }
            if (path != null && !(selectionModel = this.table.getSelectionModel()).isPathSelected(path)) {
                selectionModel.clearSelection();
                IPolicyProvider pp = this.table.getPolicyProvider();
                INodeEditPolicy nep = pp.getPolicy(INodeEditPolicy.class);
                if (nep.isSelectable(path.getLastPathComponent(), this.table.getModel())) {
                    selectionModel.addSelectionPath(path);
                }
            }
            this.popup = null;
            this.popup = this.menuProvider != null ? this.menuProvider.getPopupMenu(this, evt, path) : this.getComponentPopupMenu();
            if (this.popup != null) {
                this.popup.show(this, evt.getX(), evt.getY());
                return true;
            }
        }
        return false;
    }

    public Map<Class, T> getRendererMap() {
        return this.rendererMap;
    }

    public void setRendererMap(Map<Class, T> map) {
        if (map == null) {
            throw new IllegalArgumentException("renderer map can not be NULL");
        }
        this.rendererMap = map;
    }

    class InternalRowResizeCompoundCommand
    extends AbstractCompoundCommand<ICommand> {
        private AbstractRowHeader header;

        public InternalRowResizeCompoundCommand(String name, AbstractRowHeader header) {
            super(name);
            this.header = header;
        }

        public AbstractRowHeader getRowHeader() {
            return this.header;
        }
    }
}

