/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.msproject.util;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;

public class TableHeaderUtils {
    private static final CellRendererPane CELL_RENDER_PANE = new CellRendererPane();
    public static final int NO_COLUMN = -1;
    public static Image gradient;

    private TableHeaderUtils() {
    }

    public static void makeHeaderFillEmptySpace(JTable table) {
        table.getTableHeader().setBorder(TableHeaderUtils.createTableHeaderEmptyColumnPainter(table));
    }

    public static void paintHeader(Graphics graphics, JTable table, int x2, int width) {
        TableCellRenderer renderer = table.getTableHeader().getDefaultRenderer();
        Component component = renderer.getTableCellRendererComponent(table, "", false, false, -1, table.getColumnCount());
        component.setBounds(0, 0, width, table.getTableHeader().getHeight());
        ((JComponent)component).setOpaque(false);
        CELL_RENDER_PANE.paintComponent(graphics, component, null, x2, 0, width, table.getTableHeader().getHeight(), true);
    }

    private static Border createTableHeaderEmptyColumnPainter(final JTable table) {
        return new AbstractBorder(){

            @Override
            public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
                JViewport viewport = (JViewport)table.getParent();
                if (viewport != null && table.getWidth() < viewport.getWidth()) {
                    int startX = table.getWidth();
                    int emptyColumnWidth = viewport.getWidth() - table.getWidth();
                    g2.drawImage(gradient, startX, 0, emptyColumnWidth, height, table);
                }
            }
        };
    }

    static {
        try {
            gradient = ImageIO.read(TableHeaderUtils.class.getResource("bizlaftableheadergradient.png"));
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }
}

