/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.msproject.model.tasksheet;

import com.dlsc.flexgantt.msproject.MSProjectUtil;
import java.util.Iterator;
import java.util.List;
import net.sf.mpxj.Column;
import net.sf.mpxj.DataType;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.Table;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.mpp.AbstractView;
import org.jdesktop.swingx.treetable.AbstractTreeTableModel;

public class TaskSheetTreeTableModel
extends AbstractTreeTableModel {
    private Table table;
    private int hierarchicalColumn = 0;

    public TaskSheetTreeTableModel(ProjectFile projectFile, AbstractView view) {
        super(projectFile);
        this.setTable(view.getTable());
        if (this.table == null) {
            for (Table table : projectFile.getTables()) {
                if (table.getResourceFlag()) continue;
                this.setTable(table);
                break;
            }
            if (this.table.getResourceFlag()) {
                throw new IllegalArgumentException("resource tables can not be used for a task sheet");
            }
        }
    }

    public int getColumn(TaskField field) {
        for (int i2 = 0; i2 < this.table.getColumns().size(); ++i2) {
            Column c2 = this.table.getColumns().get(i2);
            if (c2.getFieldType() == null || !c2.getFieldType().equals(field)) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public int getHierarchicalColumn() {
        return this.hierarchicalColumn;
    }

    @Override
    public int getColumnCount() {
        return this.table.getColumns().size();
    }

    @Override
    public String getColumnName(int column) {
        return this.table.getColumns().get(column).getTitle();
    }

    @Override
    public Class<?> getColumnClass(int column) {
        List<Column> columns = this.table.getColumns();
        Column col = columns.get(column);
        FieldType fType = col.getFieldType();
        if (fType != null) {
            DataType dType = fType.getDataType();
            return MSProjectUtil.getDataTypeClass(dType);
        }
        return Object.class;
    }

    @Override
    public Object getValueAt(Object node, int columnIndex) {
        if (node instanceof Task && columnIndex < this.table.getColumns().size()) {
            Column col = this.table.getColumns().get(columnIndex);
            Task task = (Task)node;
            TaskField field = (TaskField)col.getFieldType();
            if (field == null) {
                return "NULL";
            }
            switch (field) {
                case RESOURCE_NAMES: {
                    List<ResourceAssignment> list = task.getResourceAssignments();
                    int count = list.size();
                    if (count <= 0) break;
                    StringBuilder sb2 = new StringBuilder();
                    for (int i2 = 0; i2 < count; ++i2) {
                        ResourceAssignment assign = list.get(i2);
                        Resource res = assign.getResource();
                        if (res == null) continue;
                        sb2.append(res.getName());
                        if (i2 >= count - 1) continue;
                        sb2.append(", ");
                    }
                    return sb2.toString();
                }
                case RESOURCE_INITIALS: {
                    List<ResourceAssignment> list = task.getResourceAssignments();
                    int count = list.size();
                    if (count <= 0) break;
                    StringBuilder sb3 = new StringBuilder();
                    for (int i3 = 0; i3 < count; ++i3) {
                        ResourceAssignment assign = list.get(i3);
                        Resource res = assign.getResource();
                        if (res == null) continue;
                        sb3.append(res.getInitials());
                        if (i3 >= count - 1) continue;
                        sb3.append(", ");
                    }
                    return sb3.toString();
                }
            }
            Object value = ((Task)node).getCurrentValue(col.getFieldType());
            return value;
        }
        return "";
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent instanceof ProjectFile) {
            return ((ProjectFile)parent).getChildTasks().get(index);
        }
        return ((Task)parent).getChildTasks().get(index);
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent instanceof ProjectFile) {
            return ((ProjectFile)parent).getChildTasks().size();
        }
        return ((Task)parent).getChildTasks().size();
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent instanceof ProjectFile) {
            return ((ProjectFile)parent).getChildTasks().indexOf(child);
        }
        return ((Task)parent).getChildTasks().indexOf(child);
    }

    public void setTable(Table t2) {
        Column column;
        TaskField ft;
        this.table = t2;
        this.hierarchicalColumn = 0;
        Iterator<Column> iterator = this.table.getColumns().iterator();
        while (iterator.hasNext() && ((ft = (TaskField)(column = iterator.next()).getFieldType()) == null || !ft.equals(TaskField.NAME))) {
            ++this.hierarchicalColumn;
        }
    }
}

