/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.msproject.model.resourcesheet;

import com.dlsc.flexgantt.msproject.MSProjectUtil;
import com.dlsc.flexgantt.msproject.model.gantt.ID;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import net.sf.mpxj.Column;
import net.sf.mpxj.DataType;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.Table;
import net.sf.mpxj.mpp.AbstractView;

public class ResourceSheetTableModel
extends AbstractTableModel {
    private ProjectFile projectFile;
    private Table table;

    public ResourceSheetTableModel(ProjectFile projectFile, AbstractView view) {
        this.projectFile = projectFile;
        this.table = view.getTable();
        if (this.table == null || !this.table.getResourceFlag()) {
            for (Table table : projectFile.getTables()) {
                if (!table.getResourceFlag()) continue;
                this.table = table;
                break;
            }
            if (!this.table.getResourceFlag()) {
                throw new IllegalArgumentException("task tables can not be used for a resource sheet");
            }
        }
    }

    public void setTable(Table table) {
        this.table = table;
        this.fireTableStructureChanged();
    }

    public Table getTable() {
        return this.table;
    }

    @Override
    public int getColumnCount() {
        return this.table.getColumns().size();
    }

    @Override
    public String getColumnName(int column) {
        return this.table.getColumns().get(column).getTitle();
    }

    public Column getColumn(int column) {
        return this.table.getColumns().get(column);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        List<Column> columns = this.table.getColumns();
        Column col = columns.get(columnIndex);
        FieldType fieldType = col.getFieldType();
        if (fieldType.equals(ResourceField.ID)) {
            return ID.class;
        }
        DataType dataType = fieldType.getDataType();
        Class cl = MSProjectUtil.getDataTypeClass(dataType);
        return cl;
    }

    @Override
    public int getRowCount() {
        return this.projectFile.getResources().size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Column col = this.table.getColumns().get(columnIndex);
        Object obj = ((Resource)this.projectFile.getResources().get(rowIndex)).getCurrentValue(col.getFieldType());
        if (col.getFieldType().equals(ResourceField.ID)) {
            System.out.println("wrapping id " + obj);
            return new ID((Integer)obj);
        }
        return obj;
    }
}

