/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.msproject.model.gantt;

import com.dlsc.flexgantt.icons.IconId;
import com.dlsc.flexgantt.icons.IconRegistry;
import com.dlsc.flexgantt.model.gantt.DefaultGanttChartNode;
import com.dlsc.flexgantt.model.gantt.DefaultTimelineObject;
import com.dlsc.flexgantt.model.treetable.TreeTableColumn;
import com.dlsc.flexgantt.msproject.model.gantt.MSProjectTaskGanttChartModel;
import com.dlsc.flexgantt.msproject.model.gantt.MSProjectTaskTimelineObject;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.tree.TreePath;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;

public class MSProjectTaskGanttChartNode
extends DefaultGanttChartNode<Task, DefaultTimelineObject> {
    private static final Logger LOGGER = Logger.getLogger(MSProjectTaskGanttChartNode.class.getName());

    public MSProjectTaskGanttChartNode(Task task, MSProjectTaskGanttChartModel model) {
        super(task, true);
        this.setKeyEditable(true);
        this.setRowHeight(Math.max(20, IconRegistry.getIconDimension().height) + 2);
        if (task != null) {
            List<Task> tasks = task.getChildTasks();
            for (Task child : tasks) {
                this.add(model.getTaskNode(child));
            }
            if (this.getChildCount() > 0) {
                this.setAllowsChildren(true);
            } else {
                this.setAllowsChildren(false);
            }
            MSProjectTaskTimelineObject activity = MSProjectTaskTimelineObject.getTaskActivity(task);
            this.addTimelineObject(MSProjectTaskGanttChartModel.BASIC_LAYER, activity);
            this.setToolTipText(task.getName());
        }
    }

    @Override
    public Object getKey() {
        Task task = (Task)this.getTypedUserObject();
        if (task != null) {
            return task.getName();
        }
        return null;
    }

    public TreePath getTreePath() {
        TreePath path = null;
        DefaultGanttChartNode parentNode = (DefaultGanttChartNode)this.parent;
        if (parentNode == null || !(parentNode instanceof MSProjectTaskGanttChartNode)) {
            return new TreePath(this);
        }
        path = ((MSProjectTaskGanttChartNode)parentNode).getTreePath();
        return path.pathByAddingChild(this);
    }

    public Task getTask() {
        return (Task)this.getTypedUserObject();
    }

    @Override
    public Object getColumnValue(int index) {
        Task task = (Task)this.getTypedUserObject();
        TaskField field = TaskField.getInstance(index);
        if (task != null && field != null) {
            switch (field) {
                case NOTES: {
                    if (!task.getNotes().equals("")) {
                        return IconRegistry.getIcon(IconId.NOTE);
                    }
                    return null;
                }
                case CONSTRAINT_TYPE: {
                    if (task.getConstraintDate() != null) {
                        return IconRegistry.getIcon(IconId.CONSTRAINED);
                    }
                    return null;
                }
            }
            switch (field) {
                case RESOURCE_NAMES: {
                    List<ResourceAssignment> list = task.getResourceAssignments();
                    int count = list.size();
                    if (count <= 0) break;
                    StringBuilder sb2 = new StringBuilder();
                    for (int i2 = 0; i2 < count; ++i2) {
                        ResourceAssignment assign = list.get(i2);
                        Resource res = assign.getResource();
                        if (res == null) continue;
                        sb2.append(res.getName());
                        if (i2 >= count - 1) continue;
                        sb2.append(", ");
                    }
                    return sb2.toString();
                }
                case RESOURCE_INITIALS: {
                    List<ResourceAssignment> list = task.getResourceAssignments();
                    int count = list.size();
                    if (count <= 0) break;
                    StringBuilder sb3 = new StringBuilder();
                    for (int i3 = 0; i3 < count; ++i3) {
                        ResourceAssignment assign = list.get(i3);
                        Resource res = assign.getResource();
                        if (res == null) continue;
                        sb3.append(res.getInitials());
                        if (i3 >= count - 1) continue;
                        sb3.append(", ");
                    }
                    return sb3.toString();
                }
            }
            return task.getCachedValue(field);
        }
        return null;
    }

    @Override
    public void setColumnValue(Object value, int index) {
        Task task = (Task)this.getTypedUserObject();
        TaskField field = TaskField.getInstance(index);
        task.set((FieldType)field, value);
    }

    @Override
    public String getToolTipText(TreeTableColumn column) {
        if (column.getModelIndex() == 0) {
            return this.getTask().getNotes();
        }
        Date date = this.getTask().getConstraintDate();
        if (date != null) {
            switch (this.getTask().getConstraintType()) {
                case AS_LATE_AS_POSSIBLE: {
                    return "As late as possible";
                }
                case AS_SOON_AS_POSSIBLE: {
                    return "As soon as possible";
                }
                case FINISH_NO_EARLIER_THAN: {
                    return "Finish no earlier than " + date;
                }
                case FINISH_NO_LATER_THAN: {
                    return "Finish no later than " + date;
                }
                case MUST_FINISH_ON: {
                    return "Must finish on " + date;
                }
                case MUST_START_ON: {
                    return "Must start on " + date;
                }
                case START_NO_EARLIER_THAN: {
                    return "Start no earlier than " + date;
                }
                case START_NO_LATER_THAN: {
                    return "Start no later than " + date;
                }
            }
        }
        return super.getToolTipText(column);
    }

    @Override
    public void setKey(Object key) {
        super.setKey(key);
        if (key != null && this.getTask() != null) {
            this.getTask().setName(this.toString());
            this.setToolTipText(this.toString());
        }
    }

    @Override
    public Object getRowHeaderValue() {
        if (this.getTask() != null) {
            return this.getTask().getID();
        }
        return "?";
    }

    @Override
    public String toString() {
        Task task = this.getTask();
        if (task != null) {
            return this.getTask().getName();
        }
        return "ROOT";
    }

    @Override
    public boolean isValueEditable(int index) {
        return true;
    }

    @Override
    public Object getPopupObject(boolean extended) {
        Task task = (Task)this.getTypedUserObject();
        if (task != null) {
            if (extended) {
                return task.getName() + " (extended)";
            }
            return task.getName();
        }
        return null;
    }
}

