/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.msproject.model.gantt;

import com.dlsc.flexgantt.model.gantt.DefaultRelationship;
import com.dlsc.flexgantt.model.gantt.ILayer;
import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.model.treetable.ITreeTableNode;
import com.dlsc.flexgantt.msproject.model.gantt.MSProjectAbstractGanttChartModel;
import com.dlsc.flexgantt.msproject.model.gantt.MSProjectTaskGanttChartNode;
import com.dlsc.flexgantt.msproject.model.gantt.MSProjectTaskTimelineObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.tree.TreePath;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Relation;
import net.sf.mpxj.Table;
import net.sf.mpxj.Task;
import net.sf.mpxj.listener.FieldListener;

public class MSProjectTaskGanttChartModel
extends MSProjectAbstractGanttChartModel {
    private static final Logger LOGGER = Logger.getLogger(MSProjectTaskGanttChartModel.class.getName());
    private Table table;
    private Map<Task, MSProjectTaskGanttChartNode> map = new HashMap<Task, MSProjectTaskGanttChartNode>();
    private Map<Integer, MSProjectTaskGanttChartNode> idMap = new HashMap<Integer, MSProjectTaskGanttChartNode>();

    public MSProjectTaskGanttChartModel(ProjectFile file) {
        super(file);
        for (Table table : file.getTables()) {
            if (table.getResourceFlag()) continue;
            this.table = table;
            break;
        }
        if (this.table.getResourceFlag()) {
            throw new IllegalArgumentException("resource tables can not be used for a task sheet");
        }
        this.init();
    }

    private void init() {
        BASIC_LAYER.addFeature(ILayer.Feature.TIMELINE_OBJECT_DESCRIPTIONS);
        MSProjectTaskGanttChartNode rootNode = new MSProjectTaskGanttChartNode(null, this);
        rootNode.setKey("ROOT" + this.hashCode());
        this.setRoot(rootNode);
        ProjectFile file = this.getProjectFile();
        List<Task> taskList = file.getChildTasks();
        if (taskList.size() > 0) {
            for (final Task task : taskList) {
                rootNode.add(this.getTaskNode(task));
                task.addFieldListener(new FieldListener(){

                    @Override
                    public void fieldChange(FieldContainer container, FieldType type, Object oldValue, Object newValue) {
                        MSProjectTaskGanttChartNode node = MSProjectTaskGanttChartModel.this.getTaskNode(task);
                        MSProjectTaskGanttChartModel.this.nodeChanged(node);
                    }
                });
            }
        }
        for (final Task task : taskList) {
            this.createRelationships(file, task);
        }
    }

    @Override
    public void setRoot(ITreeTableNode root) {
        System.out.println("somebody reset the root to " + root);
        super.setRoot(root);
    }

    private void createRelationships(ProjectFile projectFile, Task sourceTask) {
        DefaultRelationship<MSProjectTaskTimelineObject> relationship;
        TreePath targetPath;
        MSProjectTaskGanttChartNode targetNode;
        MSProjectTaskTimelineObject targetObject;
        Task targetTask;
        int taskId;
        LOGGER.fine("creating relationships for task: " + sourceTask.getName());
        MSProjectTaskTimelineObject sourceObject = MSProjectTaskTimelineObject.getTaskActivity(sourceTask);
        MSProjectTaskGanttChartNode sourceNode = this.getTaskNode(sourceTask);
        TreePath sourcePath = sourceNode.getTreePath();
        List<Relation> list = sourceTask.getPredecessors();
        if (list != null) {
            for (Relation relation : list) {
                taskId = relation.getTargetTask().getID();
                targetTask = projectFile.getTaskByID(taskId);
                LOGGER.fine("to task: " + targetTask.getName());
                targetObject = MSProjectTaskTimelineObject.getTaskActivity(targetTask);
                targetNode = this.getTaskNode(targetTask);
                targetPath = targetNode.getTreePath();
                relationship = new DefaultRelationship<MSProjectTaskTimelineObject>(new TimelineObjectPath<MSProjectTaskTimelineObject>(targetPath, targetObject, (ILayer)BASIC_LAYER), new TimelineObjectPath<MSProjectTaskTimelineObject>(sourcePath, sourceObject, (ILayer)BASIC_LAYER));
                this.addRelationship(relationship);
            }
        } else {
            LOGGER.fine("task has no predecessors");
        }
        list = sourceTask.getSuccessors();
        if (list != null) {
            for (Relation relation : list) {
                taskId = relation.getTargetTask().getID();
                targetTask = projectFile.getTaskByID(taskId);
                LOGGER.fine("to task: " + targetTask.getName());
                targetObject = MSProjectTaskTimelineObject.getTaskActivity(targetTask);
                targetNode = this.getTaskNode(targetTask);
                targetPath = targetNode.getTreePath();
                relationship = new DefaultRelationship<MSProjectTaskTimelineObject>(new TimelineObjectPath<MSProjectTaskTimelineObject>(sourcePath, sourceObject, (ILayer)BASIC_LAYER), new TimelineObjectPath<MSProjectTaskTimelineObject>(targetPath, targetObject, (ILayer)BASIC_LAYER));
                this.addRelationship(relationship);
            }
        } else {
            LOGGER.fine("task has no successors");
        }
        List<Task> taskList = sourceTask.getChildTasks();
        for (int i2 = 0; i2 < taskList.size(); ++i2) {
            Task task = taskList.get(i2);
            this.createRelationships(projectFile, task);
        }
    }

    public synchronized MSProjectTaskGanttChartNode getTaskNode(Task task) {
        MSProjectTaskGanttChartNode node = this.map.get(task);
        if (node == null) {
            node = new MSProjectTaskGanttChartNode(task, this);
            this.map.put(task, node);
            System.out.println("adding " + task.getUniqueID() + " to hashmap");
            this.idMap.put(task.getUniqueID(), node);
        }
        return node;
    }

    public synchronized MSProjectTaskGanttChartNode getTaskNodeByID(Integer id2) {
        return this.idMap.get(id2);
    }
}

