/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.msproject.model.gantt;

import com.dlsc.flexgantt.msproject.model.gantt.MSProjectAbstractGanttChartModel;
import com.dlsc.flexgantt.msproject.model.gantt.MSProjectResourceGanttChartNode;
import com.dlsc.flexgantt.msproject.model.gantt.MSProjectTaskGanttChartModel;
import java.util.logging.Logger;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceContainer;
import net.sf.mpxj.Table;

public class MSProjectResourceGanttChartModel
extends MSProjectAbstractGanttChartModel {
    private static final Logger LOGGER = Logger.getLogger(MSProjectResourceGanttChartModel.class.getName());
    private Table table;
    private MSProjectTaskGanttChartModel taskModel;

    public MSProjectResourceGanttChartModel(ProjectFile file, MSProjectTaskGanttChartModel taskModel) {
        super(file);
        this.taskModel = taskModel;
        for (Table table : file.getTables()) {
            if (!table.getResourceFlag()) continue;
            this.table = table;
            break;
        }
        if (!this.table.getResourceFlag()) {
            throw new IllegalArgumentException("task tables can not be used for a task sheet");
        }
        this.init();
    }

    private void init() {
        MSProjectResourceGanttChartNode root = new MSProjectResourceGanttChartNode(null, this.taskModel);
        root.setKey("ROOT");
        ProjectFile file = this.getProjectFile();
        ResourceContainer resources = file.getResources();
        for (Resource res : resources) {
            if (res.getName() == null) continue;
            root.add(new MSProjectResourceGanttChartNode(res, this.taskModel));
        }
        this.setRoot(root);
    }
}

