/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.msproject.model.gantt;

import com.dlsc.flexgantt.icons.IconId;
import com.dlsc.flexgantt.icons.IconRegistry;
import com.dlsc.flexgantt.model.treetable.DefaultColumnModel;
import com.dlsc.flexgantt.model.treetable.KeyColumn;
import com.dlsc.flexgantt.model.treetable.SortDirection;
import com.dlsc.flexgantt.model.treetable.TreeTableColumn;
import com.dlsc.flexgantt.msproject.model.gantt.FieldTypeColumn;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import net.sf.mpxj.Column;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.Table;
import net.sf.mpxj.TaskField;

public class MSProjectColumnModel
extends DefaultColumnModel {
    private int keyPosition;
    private ArrayList<TreeTableColumn<?>> availableColumns;

    public MSProjectColumnModel(Table table) {
        boolean keyColumnFound = false;
        LinkedList<FieldType> usedFields = new LinkedList<FieldType>();
        for (Column column : table.getColumns()) {
            FieldType ft = column.getFieldType();
            usedFields.add(ft);
            FieldTypeColumn ftColumn = new FieldTypeColumn(ft);
            ftColumn.setWidth(column.getWidth() * 10 + 20);
            if (ft.equals(TaskField.NAME) || ft.equals(ResourceField.NAME)) {
                keyColumnFound = true;
                KeyColumn keyColumn = new KeyColumn(ftColumn.getName(), ftColumn.getColumnClass());
                this.setKeyColumn(keyColumn);
                keyColumn.setWidth(ftColumn.getWidth());
            } else {
                this.addColumn(ftColumn);
            }
            if (keyColumnFound) continue;
            ++this.keyPosition;
        }
        this.availableColumns = new ArrayList();
        block6: for (TaskField field : TaskField.values()) {
            FieldTypeColumn column = new FieldTypeColumn(field);
            column.setSupportedSortDirections(new SortDirection[]{SortDirection.ASCENDING, SortDirection.DESCENDING});
            switch (field) {
                case NOTES: {
                    column.setHeaderValue(IconRegistry.getIcon(IconId.NOTE));
                    column.setColumnClass(ImageIcon.class);
                    column.setMaximumWidth(20);
                    column.setMinimumWidth(20);
                    column.setWidth(20);
                    column.setSupportedSortDirections(new SortDirection[]{SortDirection.NONE});
                    this.addColumn(column);
                    continue block6;
                }
                case CONSTRAINT_TYPE: {
                    column.setHeaderValue(IconRegistry.getIcon(IconId.CONSTRAINED));
                    column.setColumnClass(ImageIcon.class);
                    column.setMaximumWidth(20);
                    column.setMinimumWidth(20);
                    column.setWidth(20);
                    column.setSupportedSortDirections(new SortDirection[]{SortDirection.NONE});
                    this.addColumn(column);
                    continue block6;
                }
                case NAME: {
                    this.setKeyColumn(new KeyColumn(column.getName(), column.getColumnClass()));
                    continue block6;
                }
                default: {
                    this.availableColumns.add(column);
                }
            }
        }
    }

    public List<TreeTableColumn<?>> getAvailableColumns() {
        return this.availableColumns;
    }

    public int getKeyColumnPosition() {
        return this.keyPosition;
    }
}

