/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.msproject;

import com.dlsc.flexgantt.icons.IconId;
import com.dlsc.flexgantt.icons.IconRegistry;
import com.dlsc.flexgantt.msproject.AbstractMSProjectContentPanel;
import com.dlsc.flexgantt.msproject.MSProjectComponentFactory;
import com.dlsc.flexgantt.msproject.MSProjectUtil;
import com.dlsc.flexgantt.msproject.MSProjectWorkbench;
import com.dlsc.flexgantt.msproject.model.tasksheet.TaskSheetTreeTableModel;
import com.dlsc.flexgantt.msproject.renderer.table.DateTableCellRenderer;
import com.dlsc.flexgantt.msproject.renderer.table.DurationTableCellRenderer;
import com.dlsc.flexgantt.msproject.renderer.table.RateTableCellRenderer;
import com.dlsc.flexgantt.msproject.renderer.table.RelationListTableCellRenderer;
import com.dlsc.flexgantt.msproject.renderer.table.ResourceTypeTableCellRender;
import com.dlsc.flexgantt.msproject.util.TableHeaderUtils;
import com.dlsc.flexgantt.swing.StatusBar;
import com.dlsc.flexgantt.swing.util.TableUtils;
import de.centigrade.bizlaf.BizLafControl;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreePath;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Table;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.mpp.AbstractView;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.FontHighlighter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.HighlighterFactory;

public class TaskSheetPanel
extends AbstractMSProjectContentPanel {
    private TaskSheetTreeTableModel model;
    private JXTreeTable table;

    public TaskSheetPanel(MSProjectWorkbench workbench, ProjectFile file, AbstractView view) {
        super(workbench, file, "Task Sheet", view);
    }

    @Override
    protected JComponent createContent() {
        this.model = new TaskSheetTreeTableModel(this.getProjectFile(), this.getView());
        this.table = new JXTreeTable(this.model);
        this.table.setOpenIcon(IconRegistry.getIcon(IconId.FOLDER_OPEN));
        this.table.setClosedIcon(IconRegistry.getIcon(IconId.FOLDER_CLOSED));
        this.table.setLeafIcon(IconRegistry.getIcon(IconId.TASK));
        this.table.setDragEnabled(true);
        this.table.setDropMode(DropMode.ON_OR_INSERT_ROWS);
        this.table.setFont(MSProjectComponentFactory.FONT);
        FontHighlighter fh1 = new FontHighlighter(this.table.getFont().deriveFont(1));
        fh1.setHighlightPredicate(new HighlightPredicate(){

            @Override
            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                JXTreeTable table = (JXTreeTable)adapter.getComponent();
                TaskSheetTreeTableModel model = (TaskSheetTreeTableModel)table.getTreeTableModel();
                TreePath path = table.getPathForRow(adapter.row);
                Task task = (Task)path.getLastPathComponent();
                return task.getChildTasks().size() > 0;
            }
        });
        FontHighlighter fh2 = new FontHighlighter(this.table.getFont());
        fh2.setHighlightPredicate(new HighlightPredicate(){

            @Override
            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                JXTreeTable table = (JXTreeTable)adapter.getComponent();
                TaskSheetTreeTableModel model = (TaskSheetTreeTableModel)table.getTreeTableModel();
                TreePath path = table.getPathForRow(adapter.row);
                Task task = (Task)path.getLastPathComponent();
                return task.getChildTasks().size() == 0;
            }
        });
        this.table.setHighlighters(fh1, fh2, HighlighterFactory.createAlternateStriping(MSProjectComponentFactory.ALTERNATING_ROW_COLOR, Color.WHITE));
        this.table.setAutoResizeMode(0);
        this.table.setFillsViewportHeight(true);
        this.table.setIntercellSpacing(new Dimension(1, 0));
        this.table.setShowVerticalLines(true);
        this.table.setShowHorizontalLines(false);
        this.table.setOpaque(false);
        this.applyRenderers();
        TableHeaderUtils.makeHeaderFillEmptySpace(this.table);
        TableUtils.autoResizeTable(this.table, true, 30);
        JScrollPane scroll = new JScrollPane(this.table);
        scroll.getViewport().setOpaque(false);
        scroll.setBorder(BorderFactory.createEmptyBorder());
        com.jtechdev.widgets.TableUtils.makeStriped(this.table, MSProjectComponentFactory.ALTERNATING_ROW_COLOR);
        return scroll;
    }

    private void applyRenderers() {
        block16: for (TaskField field : TaskField.values()) {
            int modelIndex = this.model.getColumn(field);
            if (modelIndex == -1) continue;
            int viewIndex = this.table.convertColumnIndexToView(modelIndex);
            TableColumn col = this.table.getColumn(viewIndex);
            System.out.println(field.getName() + " = " + field.getDataType());
            switch (field.getDataType()) {
                case ACCRUE: {
                    continue block16;
                }
                case BOOLEAN: {
                    continue block16;
                }
                case CONSTRAINT: {
                    continue block16;
                }
                case CURRENCY: {
                    continue block16;
                }
                case DATE: {
                    col.setCellRenderer(new DateTableCellRenderer(this.getProjectFile()));
                    continue block16;
                }
                case DURATION: {
                    col.setCellRenderer(new DurationTableCellRenderer());
                    continue block16;
                }
                case NUMERIC: {
                    continue block16;
                }
                case PERCENTAGE: {
                    continue block16;
                }
                case PRIORITY: {
                    continue block16;
                }
                case RATE: {
                    col.setCellRenderer(new RateTableCellRenderer());
                    continue block16;
                }
                case RELATION_LIST: {
                    if (field.equals(TaskField.PREDECESSORS)) {
                        col.setCellRenderer(new RelationListTableCellRenderer(true));
                        continue block16;
                    }
                    col.setCellRenderer(new RelationListTableCellRenderer(false));
                    continue block16;
                }
                case RESOURCE_TYPE: {
                    col.setCellRenderer(new ResourceTypeTableCellRender());
                    continue block16;
                }
                case STRING: {
                    continue block16;
                }
                case TASK_TYPE: {
                    continue block16;
                }
            }
        }
    }

    @Override
    protected JComponent createStatusBar() {
        StatusBar statusBar = new StatusBar();
        BizLafControl.get().setStyle(statusBar, ":bizlaf:FooterBar");
        statusBar.getResizeIconLabel().setVisible(false);
        statusBar.setPreferredSize(new Dimension(10, 32));
        MSProjectUtil.makeLabelsShadowed(statusBar);
        return statusBar;
    }

    @Override
    public void setTable(Table t2) {
        this.model.setTable(t2);
        this.applyRenderers();
        TableUtils.autoResizeTable(this.table, true, 30);
    }
}

