/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.msproject;

import com.dlsc.flexgantt.msproject.AbstractMSProjectContentPanel;
import com.dlsc.flexgantt.msproject.MSProjectComponentFactory;
import com.dlsc.flexgantt.msproject.MSProjectUtil;
import com.dlsc.flexgantt.msproject.MSProjectWorkbench;
import com.dlsc.flexgantt.msproject.model.gantt.ID;
import com.dlsc.flexgantt.msproject.model.resourcesheet.ResourceSheetTableModel;
import com.dlsc.flexgantt.msproject.renderer.table.IDRenderer;
import com.dlsc.flexgantt.msproject.renderer.table.RateTableCellRenderer;
import com.dlsc.flexgantt.msproject.util.TableHeaderUtils;
import com.dlsc.flexgantt.swing.StatusBar;
import com.dlsc.flexgantt.swing.util.TableUtils;
import de.centigrade.bizlaf.BizLafControl;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Rate;
import net.sf.mpxj.Table;
import net.sf.mpxj.mpp.AbstractView;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdesktop.swingx.table.TableColumnExt;

public class ResourceSheetPanel
extends AbstractMSProjectContentPanel {
    private ResourceSheetTableModel model;
    private JXTable table;

    public ResourceSheetPanel(MSProjectWorkbench workbench, ProjectFile file, AbstractView view) {
        super(workbench, file, "Resource Sheet", view);
    }

    @Override
    protected boolean isTaskView() {
        return false;
    }

    @Override
    protected JComponent createContent() {
        this.model = new ResourceSheetTableModel(this.getProjectFile(), this.getView());
        this.table = new JXTable(this.model);
        this.table.setAutoResizeMode(0);
        this.table.setFillsViewportHeight(true);
        this.table.setShowHorizontalLines(false);
        this.table.setFont(MSProjectComponentFactory.FONT);
        this.table.setHighlighters(HighlighterFactory.createAlternateStriping(MSProjectComponentFactory.ALTERNATING_ROW_COLOR, Color.WHITE));
        for (int i2 = 0; i2 < this.table.getColumnCount(true); ++i2) {
            TableColumnExt col = this.table.getColumnExt(this.table.convertColumnIndexToView(i2));
            col.setWidth(this.model.getColumn(i2).getWidth());
        }
        this.table.setDefaultRenderer(Rate.class, new RateTableCellRenderer());
        this.table.setDefaultRenderer(ID.class, new IDRenderer());
        this.table.setOpaque(false);
        TableHeaderUtils.makeHeaderFillEmptySpace(this.table);
        com.jtechdev.widgets.TableUtils.makeStriped(this.table, MSProjectComponentFactory.ALTERNATING_ROW_COLOR);
        JScrollPane scroll = new JScrollPane(this.table);
        scroll.setBorder(BorderFactory.createEmptyBorder());
        scroll.setOpaque(false);
        scroll.getViewport().setOpaque(false);
        return scroll;
    }

    @Override
    protected JComponent createStatusBar() {
        StatusBar statusBar = new StatusBar();
        BizLafControl.get().setStyle(statusBar, ":bizlaf:FooterBar");
        statusBar.getResizeIconLabel().setVisible(false);
        statusBar.setPreferredSize(new Dimension(10, 32));
        MSProjectUtil.makeLabelsShadowed(statusBar);
        return statusBar;
    }

    @Override
    public void setTable(Table t2) {
        this.model.setTable(t2);
        TableUtils.autoResizeTable(this.table, true, 30);
    }
}

