/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.msproject;

import com.dlsc.flexgantt.icons.IconRegistry;
import com.dlsc.flexgantt.icons.png16xp.Png16XPIconMap;
import com.dlsc.flexgantt.msproject.MSProjectGanttChart;
import com.dlsc.flexgantt.msproject.MSProjectMenuBar;
import com.dlsc.flexgantt.msproject.MSProjectWorkbench;
import com.dlsc.flexgantt.msproject.components.AnimatedSplitPane;
import com.dlsc.flexgantt.msproject.session.AnimatedSplitPaneSessionStorageProperty;
import com.dlsc.flexgantt.msproject.session.MSProjectGanttChartPropertySupport;
import com.dlsc.flexgantt.msproject.session.XProperties;
import com.dlsc.flexgantt.swing.util.ColorUtil;
import com.dlsc.flexgantt.util.FlexGanttLicenseManager;
import de.centigrade.bizlaf.BizLookAndFeel;
import java.awt.Color;
import java.io.File;
import java.util.Locale;
import javax.swing.JFrame;
import javax.swing.UIManager;
import org.jdesktop.application.Application;
import org.jdesktop.application.SessionStorage;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.swingx.JXTable;

public class MSProjectViewer
extends SingleFrameApplication {
    private String[] args;

    @Override
    protected void initialize(String[] args) {
        super.initialize(args);
        this.args = args;
    }

    @Override
    protected void startup() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                MSProjectViewer.this.shutdown();
            }
        });
        SessionStorage sessionStorage = this.getContext().getSessionStorage();
        sessionStorage.putProperty(AnimatedSplitPane.class, new AnimatedSplitPaneSessionStorageProperty());
        sessionStorage.putProperty(MSProjectGanttChart.class, new MSProjectGanttChartPropertySupport());
        new XProperties().registerPersistenceDelegates();
        sessionStorage.putProperty(JXTable.class, new XProperties.XTableProperty());
        MSProjectViewer.applyLookAndFeel();
        JFrame frame = new JFrame(this.getContext().getResourceMap().getString("Application.title", new String[0]));
        frame.setDefaultCloseOperation(3);
        this.setMainFrame(frame);
        MSProjectWorkbench workbench = new MSProjectWorkbench(this);
        MSProjectMenuBar bar = new MSProjectMenuBar(workbench);
        this.getMainFrame().setJMenuBar(bar);
        if (this.args != null && this.args.length > 0) {
            try {
                workbench.load(new File(this.args[0]));
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        this.getMainFrame().setSize(900, 700);
        this.show(workbench);
    }

    @Override
    protected void shutdown() {
        super.shutdown();
    }

    public static void applyLookAndFeel() {
        ColorUtil.setGridColor(Color.LIGHT_GRAY);
        try {
            UIManager.setLookAndFeel(new BizLookAndFeel());
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static boolean isMacOSX() {
        return System.getProperty("os.name").toLowerCase().startsWith("mac os x");
    }

    public static boolean isAqua() {
        return UIManager.getLookAndFeel().getName().equals("Mac OS X");
    }

    public static void main(String[] args) {
        FlexGanttLicenseManager.setLicenseKey("LIC=DLSC;VEN=DLSC;VER=2;RUN=no;CTR=1;SignCode=1F;Signature=302D0215008F7E9DCB1A657E51E2FF09400388595003149C7B021448AC6616D5F09B8D822E14ECFD2BF52DE9A31B13");
        SecurityManager sm = System.getSecurityManager();
        try {
            String language;
            if (sm != null) {
                sm.checkPropertiesAccess();
            }
            if ((language = System.getProperty("language")) != null) {
                Locale.setDefault(new Locale(language));
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        IconRegistry.setIconMap(new Png16XPIconMap());
        Application.launch(MSProjectViewer.class, args);
    }
}

