/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.msproject;

import com.dlsc.flexgantt.model.TimeSpan;
import com.dlsc.flexgantt.msproject.MSProjectComponentFactory;
import com.dlsc.flexgantt.msproject.MSProjectRelationshipPolicy;
import com.dlsc.flexgantt.msproject.model.gantt.MSProjectColumnModel;
import com.dlsc.flexgantt.msproject.model.gantt.MSProjectTaskGanttChartModel;
import com.dlsc.flexgantt.msproject.model.gantt.MSProjectTaskGanttChartNode;
import com.dlsc.flexgantt.msproject.model.gantt.MSProjectTaskTimelineObject;
import com.dlsc.flexgantt.msproject.policy.MSProjectGranularityZoomPolicy;
import com.dlsc.flexgantt.msproject.renderer.MSProjectTaskRenderer;
import com.dlsc.flexgantt.msproject.renderer.MSProjectTreeTableCellRenderer;
import com.dlsc.flexgantt.policy.IPolicyProvider;
import com.dlsc.flexgantt.policy.dateline.IZoomPolicy;
import com.dlsc.flexgantt.policy.layer.IRelationshipPolicy;
import com.dlsc.flexgantt.swing.DualGanttChart;
import com.dlsc.flexgantt.swing.layer.system.DefaultPopupRenderer;
import com.dlsc.flexgantt.swing.layer.system.PopupLayer;
import com.dlsc.flexgantt.swing.mac.MacTreeTableRowHeaderRenderer;
import com.dlsc.flexgantt.swing.timeline.TimeNowThread;
import com.dlsc.flexgantt.swing.treetable.DefaultTreeTableRowHeaderRenderer;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.tree.TreePath;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Table;
import net.sf.mpxj.ViewContainer;
import net.sf.mpxj.ViewState;
import net.sf.mpxj.mpp.AbstractView;

public class MSProjectGanttChart
extends DualGanttChart {
    private TimeNowThread thread;
    private ProjectFile projectFile;

    public MSProjectGanttChart(ProjectFile projectFile, AbstractView view) {
        super(MSProjectComponentFactory.getInstance());
        this.projectFile = projectFile;
        Table table = view.getTable();
        if (table == null) {
            for (Table t2 : projectFile.getTables()) {
                if (t2.getResourceFlag()) continue;
                table = t2;
                break;
            }
            if (table != null && table.getResourceFlag()) {
                throw new IllegalArgumentException("resource tables can not be used for a task sheet");
            }
        }
        this.getEventline().setVisible(false);
        MSProjectColumnModel colModel = new MSProjectColumnModel(table);
        this.setColumnModel(colModel);
        this.setAvailableColumns(colModel.getAvailableColumns());
        this.getPrimaryTreeTable().setCellRenderer(Object.class, new MSProjectTreeTableCellRenderer());
        this.getPrimaryTreeTableRowHeader().setRowHeaderRenderer(Object.class, new MacTreeTableRowHeaderRenderer(DefaultTreeTableRowHeaderRenderer.Type.MODEL_OBJECT));
        this.getPrimaryLayerContainer().setTimelineObjectRenderer(MSProjectTaskTimelineObject.class, new MSProjectTaskRenderer());
        this.setPopupVisible(true);
        DefaultPopupRenderer popupRenderer = new DefaultPopupRenderer();
        popupRenderer.getTitleLabel().setFont(popupRenderer.getFont().deriveFont(1));
        PopupLayer popupLayer = this.getPrimaryLayerContainer().getSystemLayer(PopupLayer.class);
        popupLayer.setPopupRenderer(Object.class, popupRenderer);
        MSProjectGranularityZoomPolicy dp = new MSProjectGranularityZoomPolicy();
        IPolicyProvider pp = this.getDateline().getPolicyProvider();
        pp.setPolicy(IZoomPolicy.class, dp);
        pp = this.getPrimaryLayerContainer().getPolicyProvider();
        pp.setPolicy(IRelationshipPolicy.class, new MSProjectRelationshipPolicy());
    }

    public void updateHorizon() {
        MSProjectTaskGanttChartModel model = (MSProjectTaskGanttChartModel)this.getModel();
        ProjectFile mpx = model.getProjectFile();
        Date startDate = mpx.getStartDate();
        Date finishDate = mpx.getFinishDate();
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        if (startDate != null) {
            c1.setTimeInMillis(startDate.getTime());
        }
        if (finishDate != null) {
            c2.setTimeInMillis(finishDate.getTime());
        } else {
            c2.setTimeInMillis(c1.getTimeInMillis());
            c2.add(1, 2);
        }
        TimeSpan timeSpan = new TimeSpan(c1, c2);
        this.getDateline().setTimeSpan(timeSpan);
        this.showTime(c1.getTimeInMillis(), false);
    }

    public TimeNowThread getTimeNowThread() {
        return this.thread;
    }

    public String getTitle() {
        return "undefined";
    }

    public void restoreViewState() {
        MSProjectTaskGanttChartModel model = (MSProjectTaskGanttChartModel)this.getModel();
        ViewContainer views = this.projectFile.getViews();
        ViewState viewState = views.getViewState();
        if (viewState != null) {
            List<Integer> idList = viewState.getUniqueIdList();
            for (int taskID : idList) {
                MSProjectTaskGanttChartNode node = model.getTaskNodeByID(taskID);
                Object[] path = model.getPathToRoot(node);
                if (path == null || path.length <= 0) continue;
                this.getPrimaryTreeTable().expandPath(new TreePath(path));
            }
        } else {
            this.expandAll();
        }
    }
}

