/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.msproject;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.dateline.DatelineModelEvent;
import com.dlsc.flexgantt.model.dateline.DatelineModelVetoException;
import com.dlsc.flexgantt.model.dateline.IDatelineModelListener;
import com.dlsc.flexgantt.swing.DualGanttChart;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.LinkedList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class DatelineHistory
extends LinkedList<ITimeSpan>
implements IDatelineModelListener,
AdjustmentListener {
    private DualGanttChart gc;
    private ITimeSpan tempSpan;
    private EventListenerList listenerList = new EventListenerList();
    private boolean backInProgress;

    public DatelineHistory(DualGanttChart gc2) {
        this.gc = gc2;
        this.gc.getPrimaryLayerContainerScrollPane().getHorizontalScrollBar().addAdjustmentListener(this);
        this.gc.getDatelineModel().addDatelineModelListener(this);
    }

    @Override
    public void datelineModelChanged(DatelineModelEvent evt) {
    }

    @Override
    public void datelineModelWillChange(DatelineModelEvent evt) throws DatelineModelVetoException {
        if (!this.backInProgress) {
            switch (evt.getId()) {
                case GRANULARITY_CHANGED: 
                case REQUESTED_VISIBLE_TIME_SPAN_CHANGED: 
                case ZOOM_CHANGED: {
                    ITimeSpan span = this.gc.getDateline().getVisibleTimeSpan();
                    this.addToHistory(span);
                    break;
                }
            }
        } else {
            System.out.println("not adding to history, back in progress");
        }
    }

    private void addToHistory(ITimeSpan span) {
        this.add(span);
        if (this.size() > 10) {
            this.remove(0);
        }
        for (ITimeSpan stackSpan : this) {
            System.out.println("   " + stackSpan);
        }
        this.fireChangeEvent();
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e2) {
        if (this.tempSpan == null && e2.getValueIsAdjusting()) {
            this.tempSpan = this.gc.getDateline().getVisibleTimeSpan();
            this.addToHistory(this.tempSpan);
        }
        if (!e2.getValueIsAdjusting()) {
            this.tempSpan = null;
        }
    }

    public void addChangeListener(ChangeListener l2) {
        this.listenerList.add(ChangeListener.class, l2);
    }

    public void removeChangeListener(ChangeListener l2) {
        this.listenerList.remove(ChangeListener.class, l2);
    }

    protected void fireChangeEvent() {
        ChangeEvent e2 = new ChangeEvent(this);
        Object[] listeners = this.listenerList.getListenerList();
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i2 + 1]).stateChanged(e2);
        }
    }

    public void back() {
        ITimeSpan span = (ITimeSpan)this.getLast();
        if (span != null) {
            System.out.println("going back to " + span);
            this.remove(this.size() - 1);
            this.backInProgress = true;
            this.gc.getDateline().requestVisibleTimeSpan(span);
            this.backInProgress = false;
            this.fireChangeEvent();
        }
    }

    public boolean isBackPossible() {
        return this.size() > 0;
    }
}

