/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.model.treetable;

import com.dlsc.flexgantt.model.treetable.KeyColumn;
import com.dlsc.flexgantt.model.treetable.SortDirection;
import com.dlsc.flexgantt.swing.treetable.ITreeTableCellRenderer;
import com.dlsc.flexgantt.util.NamedObject;
import java.beans.PropertyChangeSupport;

public class TreeTableColumn<T>
extends NamedObject {
    public static final String PROPERTY_WIDTH = "columnWidth";
    public static final String PROPERTY_HEADER_VALUE = "columnHeaderValue";
    public static final String PROPERTY_MIN_WIDTH = "columnMinWidth";
    public static final String PROPERTY_MAX_WIDTH = "columnMaxWidth";
    public static final String PROPERTY_COLUMN_CLASS = "columnClass";
    public static final String PROPERTY_MODEL_INDEX = "columnIndex";
    private static final int DEFAULT_WIDTH = 80;
    private static final int DEFAULT_MINIMUM_WIDTH = 10;
    private T headerValue;
    private int width = 80;
    private int minWidth = 10;
    private int maxWidth = Integer.MAX_VALUE;
    private int modelIndex;
    private Class columnClass = Object.class;
    private PropertyChangeSupport changeSupport;
    private SortDirection[] supportedSortDirections = SortDirection.values();
    private ITreeTableCellRenderer cellRenderer;

    public TreeTableColumn(String name, Class columnClass, int modelIndex) {
        super(name);
        if (name == null) {
            throw new IllegalArgumentException("column name can not be NULL");
        }
        if (columnClass == null) {
            throw new IllegalArgumentException("column class can not be NULL");
        }
        if (modelIndex < 0 && !(this instanceof KeyColumn)) {
            throw new IllegalArgumentException("model index can not be negative: " + modelIndex);
        }
        this.changeSupport = this.getChangeSupport();
        this.columnClass = columnClass;
        this.modelIndex = modelIndex;
    }

    public TreeTableColumn(String name, Class columnClass) {
        this(name, columnClass, 0);
    }

    public T getHeaderValue() {
        return this.headerValue;
    }

    public void setHeaderValue(T value) {
        if (value == null) {
            throw new IllegalArgumentException("column header value can not be NULL");
        }
        T oldValue = this.headerValue;
        this.headerValue = value;
        this.changeSupport.firePropertyChange(PROPERTY_HEADER_VALUE, oldValue, value);
    }

    public boolean isSortable() {
        return this.isSupported(SortDirection.ASCENDING) || this.isSupported(SortDirection.DESCENDING);
    }

    public int getModelIndex() {
        return this.modelIndex;
    }

    public void setModelIndex(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("model index can not be a negative number but was " + index);
        }
        if (index == -1) {
            throw new IllegalArgumentException("the model index -1 is reserved for the key column");
        }
        int oldIndex = this.modelIndex;
        this.modelIndex = index;
        this.changeSupport.firePropertyChange(PROPERTY_MODEL_INDEX, oldIndex, index);
    }

    public void setWidth(int width) {
        if (width < 0) {
            throw new IllegalArgumentException("width can not be a negative number (min = " + width + ")");
        }
        if (width < this.minWidth) {
            throw new IllegalArgumentException("width can not be smaller than the minimum width (min = " + this.minWidth + ", width = " + width + ")");
        }
        if (width > this.maxWidth) {
            throw new IllegalArgumentException("width can not be larger than the maximum width (max = " + this.maxWidth + ", width = " + width + ")");
        }
        int oldWidth = this.width;
        this.width = width;
        this.changeSupport.firePropertyChange(PROPERTY_WIDTH, oldWidth, width);
    }

    public int getWidth() {
        return this.width;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public int getMinimumWidth() {
        return this.minWidth;
    }

    public void setMinimumWidth(int minWidth) {
        if (minWidth < 0) {
            throw new IllegalArgumentException("mimimum width can not be a negative number (min = " + minWidth + ")");
        }
        if (minWidth > this.maxWidth) {
            throw new IllegalArgumentException("mimimum width can not be larger than maximum width (min = " + minWidth + ", max = " + this.maxWidth + ")");
        }
        int oldMinWidth = this.minWidth;
        this.minWidth = minWidth;
        this.setWidth(Math.max(this.width, minWidth));
        this.changeSupport.firePropertyChange(PROPERTY_MIN_WIDTH, oldMinWidth, minWidth);
    }

    public int getMaximumWidth() {
        return this.maxWidth;
    }

    public void setMaximumWidth(int maxWidth) {
        if (maxWidth < 0) {
            throw new IllegalArgumentException("maximum width can not be a negative number (max = " + maxWidth + ")");
        }
        if (maxWidth < this.minWidth) {
            throw new IllegalArgumentException("maximum width can not be smaller than minimum width (min = " + this.minWidth + ", max = " + maxWidth + ")");
        }
        int oldMaxWidth = this.maxWidth;
        this.maxWidth = maxWidth;
        this.setWidth(Math.min(this.width, maxWidth));
        this.changeSupport.firePropertyChange(PROPERTY_MAX_WIDTH, oldMaxWidth, maxWidth);
    }

    public Class getColumnClass() {
        return this.columnClass;
    }

    public void setColumnClass(Class cl) {
        if (cl == null) {
            throw new IllegalArgumentException("column class can not be NULL");
        }
        Class oldClass = this.columnClass;
        this.columnClass = cl;
        this.changeSupport.firePropertyChange(PROPERTY_COLUMN_CLASS, oldClass, cl);
    }

    public SortDirection[] getSupportedSortDirections() {
        return this.supportedSortDirections;
    }

    public void setSupportedSortDirections(SortDirection[] directions) {
        if (directions == null) {
            throw new IllegalArgumentException("directions can not be NULL");
        }
        this.supportedSortDirections = directions;
    }

    public boolean isSupported(SortDirection direction) {
        if (direction == null) {
            throw new IllegalArgumentException("direction can not be NULL");
        }
        for (SortDirection sd : this.supportedSortDirections) {
            if (!sd.equals((Object)direction)) continue;
            return true;
        }
        return false;
    }

    public ITreeTableCellRenderer getCellRenderer() {
        return this.cellRenderer;
    }

    public void setCellRenderer(ITreeTableCellRenderer renderer) {
        this.cellRenderer = renderer;
    }
}

