/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.model.dateline;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.dateline.DatelineModelEvent;
import com.dlsc.flexgantt.model.dateline.DatelineModelException;
import com.dlsc.flexgantt.model.dateline.DatelineModelVetoException;
import com.dlsc.flexgantt.model.dateline.IDatelineModel;
import com.dlsc.flexgantt.model.dateline.IDatelineModelListener;
import com.dlsc.flexgantt.model.dateline.IGranularity;
import java.util.TimeZone;
import javax.swing.event.EventListenerList;

public abstract class AbstractDatelineModel<T extends IGranularity>
implements IDatelineModel<T> {
    protected ITimeSpan selectedTimeSpan;
    protected TimeZone timeZone;
    protected ITimeSpan timeSpan;
    protected T granularity;
    protected double zoom = 1.0;
    protected double datelineWidth;
    public int spreadsheetCellWidth = -1;
    private EventListenerList listenerList = new EventListenerList();

    protected AbstractDatelineModel(ITimeSpan timeSpan, TimeZone timeZone) {
        if (timeSpan == null) {
            throw new IllegalArgumentException("time span can not be NULL");
        }
        if (timeZone == null) {
            throw new IllegalArgumentException("time zone can not be NULL");
        }
        this.timeSpan = timeSpan;
        this.timeZone = timeZone;
    }

    @Override
    public void setSpreadsheetCellWidth(int width) throws DatelineModelException {
        if (width < 1) {
            throw new IllegalArgumentException("spreadsheet cell width must be larger than 0");
        }
        this.spreadsheetCellWidth = width;
        this.calculateDatelineWidth();
    }

    @Override
    public int getSpreadsheetCellWidth() {
        return this.spreadsheetCellWidth;
    }

    @Override
    public ITimeSpan getTimeSpan() {
        return this.timeSpan;
    }

    @Override
    public void setTimeSpan(ITimeSpan timeSpan) throws DatelineModelException {
        if (timeSpan == null) {
            throw new IllegalArgumentException("time span can not be NULL");
        }
        if (!this.timeSpan.equals(timeSpan)) {
            DatelineModelEvent event = new DatelineModelEvent(this, DatelineModelEvent.ID.TIME_SPAN_CHANGED);
            try {
                this.fireDatelineModelWillChangeEvent(event);
                ITimeSpan oldSpan = this.timeSpan;
                this.timeSpan = timeSpan;
                try {
                    this.calculateDatelineWidth();
                    this.fireDatelineModelChangeEvent(event);
                }
                catch (DatelineModelException e2) {
                    this.timeSpan = oldSpan;
                    throw e2;
                }
            }
            catch (DatelineModelVetoException vetoEx) {
                throw new DatelineModelException("the change was rejected by a listener", DatelineModelException.ID.VETO_EXCEPTION);
            }
        }
    }

    @Override
    public void setTimeZone(TimeZone zone) throws DatelineModelException {
        if (zone == null) {
            throw new IllegalArgumentException("time zone can not be NULL");
        }
        DatelineModelEvent event = new DatelineModelEvent(this, DatelineModelEvent.ID.TIME_ZONE_CHANGED);
        try {
            this.fireDatelineModelWillChangeEvent(event);
            TimeZone oldZone = this.timeZone;
            this.timeZone = zone;
            if (this.timeZone != oldZone) {
                this.fireDatelineModelChangeEvent(event);
            }
        }
        catch (DatelineModelVetoException ex) {
            throw new DatelineModelException("the change was rejected by a listener", DatelineModelException.ID.VETO_EXCEPTION);
        }
    }

    @Override
    public void setZoom(double zoom) throws DatelineModelException {
        block5: {
            if (zoom < 1.0) {
                throw new IllegalArgumentException("zoom factor can not be smaller than 1");
            }
            DatelineModelEvent event = new DatelineModelEvent(this, DatelineModelEvent.ID.ZOOM_CHANGED);
            try {
                this.fireDatelineModelWillChangeEvent(event);
                if (this.zoom == zoom) break block5;
                double oldZoom = this.zoom;
                this.zoom = zoom;
                try {
                    this.calculateDatelineWidth();
                    this.fireDatelineModelChangeEvent(event);
                }
                catch (DatelineModelException ex) {
                    this.zoom = oldZoom;
                    throw ex;
                }
            }
            catch (DatelineModelVetoException ex) {
                throw new DatelineModelException("the change was rejected by a listener", DatelineModelException.ID.VETO_EXCEPTION);
            }
        }
    }

    @Override
    public double getZoom() {
        return this.zoom;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @Override
    public void setSelectedTimeSpan(ITimeSpan newSpan) {
        ITimeSpan oldSpan = this.selectedTimeSpan;
        this.selectedTimeSpan = newSpan;
        if (newSpan == null && oldSpan != null || newSpan != null && !newSpan.equals(oldSpan)) {
            DatelineModelEvent e2 = new DatelineModelEvent(this, DatelineModelEvent.ID.SELECTED_TIME_SPAN_CHANGED);
            this.fireDatelineModelChangeEvent(e2);
        }
    }

    @Override
    public T getGranularity() {
        return this.granularity;
    }

    @Override
    public void setGranularity(T granularity) throws DatelineModelException {
        T oldGranularity = this.granularity;
        DatelineModelEvent event = new DatelineModelEvent(this, DatelineModelEvent.ID.GRANULARITY_CHANGED);
        try {
            this.fireDatelineModelWillChangeEvent(event);
            try {
                this.granularity = granularity;
                this.calculateDatelineWidth();
                this.fireDatelineModelChangeEvent(event);
            }
            catch (DatelineModelException ex) {
                this.granularity = oldGranularity;
                this.calculateDatelineWidth();
                throw ex;
            }
        }
        catch (DatelineModelVetoException ex) {
            throw new DatelineModelException("the change was rejected by a listener", DatelineModelException.ID.VETO_EXCEPTION);
        }
    }

    @Override
    public ITimeSpan getSelectedTimeSpan() {
        return this.selectedTimeSpan;
    }

    @Override
    public void addDatelineModelListener(IDatelineModelListener l2) {
        this.listenerList.add(IDatelineModelListener.class, l2);
    }

    @Override
    public void removeDatelineModelListener(IDatelineModelListener l2) {
        this.listenerList.remove(IDatelineModelListener.class, l2);
    }

    protected void fireDatelineModelWillChangeEvent(DatelineModelEvent evt) throws DatelineModelVetoException {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != IDatelineModelListener.class) continue;
            ((IDatelineModelListener)listeners[i2 + 1]).datelineModelWillChange(evt);
        }
    }

    protected void fireDatelineModelChangeEvent(DatelineModelEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != IDatelineModelListener.class) continue;
            ((IDatelineModelListener)listeners[i2 + 1]).datelineModelChanged(evt);
        }
    }

    @Override
    public int getDatelineWidth() {
        return Math.max(1, (int)this.datelineWidth);
    }

    protected abstract void calculateDatelineWidth() throws DatelineModelException;
}

