/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.model.bookmarks;

import com.dlsc.flexgantt.model.bookmarks.Bookmark;
import com.dlsc.flexgantt.model.bookmarks.BookmarkEvent;
import com.dlsc.flexgantt.model.bookmarks.IBookmarkModel;
import com.dlsc.flexgantt.model.bookmarks.IBookmarkModelListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;

public class DefaultBookmarkModel
implements IBookmarkModel {
    private static final Logger LOGGER = Logger.getLogger(DefaultBookmarkModel.class.getName());
    private EventListenerList listenerList = new EventListenerList();
    private ArrayList<Bookmark> bookmarks = new ArrayList();

    public DefaultBookmarkModel(List<Bookmark> pages) {
        this.setBookmarks(pages);
    }

    public DefaultBookmarkModel() {
    }

    public void setBookmarks(List<Bookmark> pages) {
        if (pages == null) {
            throw new IllegalArgumentException("bookmarks list can not be NULL");
        }
        this.clearBookmarks();
        for (Bookmark page : pages) {
            this.addBookmark(page);
        }
    }

    public void clearBookmarks() {
        ArrayList<Bookmark> list = new ArrayList<Bookmark>(this.bookmarks);
        for (Bookmark bookmark : list) {
            this.removeBookmark(bookmark);
        }
    }

    @Override
    public void addBookmark(Bookmark bookmark) {
        LOGGER.fine("adding bookmark " + bookmark);
        this.bookmarks.add(bookmark);
        Collections.sort(this.bookmarks);
        this.fireBookmarksChangedEvent(new BookmarkEvent(this, BookmarkEvent.ID.BOOKMARK_ADDED, bookmark));
    }

    @Override
    public void removeBookmark(Bookmark bookmark) {
        LOGGER.fine("removing bookmark " + bookmark);
        this.bookmarks.remove(bookmark);
        this.fireBookmarksChangedEvent(new BookmarkEvent(this, BookmarkEvent.ID.BOOKMARK_REMOVED, bookmark));
    }

    @Override
    public int getBookmarkCount() {
        return this.bookmarks.size();
    }

    @Override
    public Bookmark getBookmark(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("bookmark index must be larger than 0");
        }
        if (index > this.bookmarks.size() - 1) {
            throw new IllegalArgumentException("bookmark index must be smaller than " + this.bookmarks.size());
        }
        return this.bookmarks.get(index);
    }

    @Override
    public void addBookmarkModelListener(IBookmarkModelListener l2) {
        this.listenerList.add(IBookmarkModelListener.class, l2);
    }

    @Override
    public void removeBookmarkModelListener(IBookmarkModelListener l2) {
        this.listenerList.remove(IBookmarkModelListener.class, l2);
    }

    protected void fireBookmarksChangedEvent(BookmarkEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != IBookmarkModelListener.class) continue;
            ((IBookmarkModelListener)listeners[i2 + 1]).bookmarksChanged(evt);
        }
    }
}

