/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.command;

import com.dlsc.flexgantt.command.IProgressMonitor;
import com.dlsc.flexgantt.command.ProgressMonitorWrapper;

public class SubProgressMonitor
extends ProgressMonitorWrapper {
    public static final int SUPPRESS_SUBTASK_LABEL = 2;
    public static final int PREPEND_MAIN_LABEL_TO_SUBTASK = 4;
    private int parentTicks;
    private double sentToParent;
    private double scale;
    private int nestedBeginTasks;
    private boolean usedUp;
    private boolean hasSubTask;
    private int style;
    private String mainTaskLabel;

    public SubProgressMonitor(IProgressMonitor monitor, int ticks) {
        this(monitor, ticks, 0);
    }

    public SubProgressMonitor(IProgressMonitor monitor, int ticks, int style) {
        super(monitor);
        this.parentTicks = ticks;
        this.style = style;
    }

    @Override
    public void beginTask(String name, int totalWork) {
        ++this.nestedBeginTasks;
        if (this.nestedBeginTasks > 1) {
            return;
        }
        double d2 = this.scale = totalWork <= 0 ? 0.0 : (double)this.parentTicks / (double)totalWork;
        if ((this.style & 4) != 0) {
            this.mainTaskLabel = name;
        }
    }

    @Override
    public void done() {
        if (this.nestedBeginTasks == 0 || --this.nestedBeginTasks > 0) {
            return;
        }
        double remaining = (double)this.parentTicks - this.sentToParent;
        if (remaining > 0.0) {
            super.internalWorked(remaining);
        }
        if (this.hasSubTask) {
            this.subTask("");
        }
        this.sentToParent = 0.0;
    }

    @Override
    public void internalWorked(double work) {
        if (this.usedUp || this.nestedBeginTasks != 1) {
            return;
        }
        double realWork = this.scale * work;
        super.internalWorked(realWork);
        this.sentToParent += realWork;
        if (this.sentToParent >= (double)this.parentTicks) {
            this.usedUp = true;
        }
    }

    @Override
    public void subTask(String name) {
        if ((this.style & 2) != 0) {
            return;
        }
        this.hasSubTask = true;
        String label = name;
        if ((this.style & 4) != 0 && this.mainTaskLabel != null && this.mainTaskLabel.length() > 0) {
            label = this.mainTaskLabel + ' ' + label;
        }
        super.subTask(label);
    }

    @Override
    public void worked(int work) {
        this.internalWorked(work);
    }
}

