/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.command;

import com.dlsc.flexgantt.command.CommandExecutionThread;
import com.dlsc.flexgantt.command.CommandStackEvent;
import com.dlsc.flexgantt.command.ICommand;
import com.dlsc.flexgantt.command.ICommandStack;
import com.dlsc.flexgantt.command.ICommandStackListener;
import com.dlsc.flexgantt.command.IProgressMonitor;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;

public class DefaultCommandStack
implements ICommandStack {
    private static final Logger LOGGER = Logger.getLogger(DefaultCommandStack.class.getName());
    private static final int DEFAULT_COMMAND_STACK_SIZE = 100;
    private LinkedList<ICommand> executedCommands = new LinkedList();
    private LinkedList<ICommand> undoneCommands = new LinkedList();
    private EventListenerList listenersList = new EventListenerList();
    private int size;

    public DefaultCommandStack(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("command stack size can not be negative");
        }
        this.size = size;
    }

    public DefaultCommandStack() {
        this(100);
    }

    public int getSize() {
        return this.size;
    }

    @Override
    public void execute(final ICommand cmd, final IProgressMonitor monitor) {
        CommandExecutionThread thread = new CommandExecutionThread(){

            @Override
            public void run() {
                LOGGER.fine("executing command: " + cmd);
                DefaultCommandStack.this.undoneCommands.clear();
                try {
                    DefaultCommandStack.this.fireCommandStackChanged(new CommandStackEvent(DefaultCommandStack.this, cmd, CommandStackEvent.ID.COMMAND_STARTED));
                    cmd.executeCommand(monitor);
                    if (!monitor.isCanceled()) {
                        if (cmd.isRelevant()) {
                            if (cmd.isUndoable()) {
                                LOGGER.fine("command is undoable, adding it to list of executed commands");
                                DefaultCommandStack.this.executedCommands.addLast(cmd);
                            } else {
                                LOGGER.fine("command is not undoable, clearing the list of executed commands");
                                DefaultCommandStack.this.executedCommands.clear();
                            }
                        } else {
                            LOGGER.fine("command is not relevant and will not be considered for the list of executed and undoable commands");
                        }
                        DefaultCommandStack.this.fireCommandStackChanged(new CommandStackEvent(DefaultCommandStack.this, cmd, CommandStackEvent.ID.COMMAND_EXECUTED));
                        if (DefaultCommandStack.this.executedCommands.size() > DefaultCommandStack.this.size) {
                            ICommand cmd2 = (ICommand)DefaultCommandStack.this.executedCommands.get(0);
                            LOGGER.fine("permitted command stack size reached");
                            LOGGER.fine("removing oldest command = " + cmd2);
                            DefaultCommandStack.this.executedCommands.remove(0);
                        }
                    } else {
                        LOGGER.fine("command was canceled");
                        if (cmd.isUndoable()) {
                            LOGGER.warning("undoing command");
                            cmd.undoCommand(monitor);
                        } else {
                            LOGGER.warning("command is not undoable");
                        }
                        DefaultCommandStack.this.fireCommandStackChanged(new CommandStackEvent(DefaultCommandStack.this, cmd, CommandStackEvent.ID.COMMAND_CANCELED));
                    }
                }
                catch (Exception e2) {
                    LOGGER.throwing(DefaultCommandStack.class.getName(), "execute", e2);
                    DefaultCommandStack.this.fireCommandStackChanged(new CommandStackEvent(DefaultCommandStack.this, cmd, CommandStackEvent.ID.COMMAND_FAILED, e2));
                }
                finally {
                    monitor.done();
                }
            }
        };
        thread.setName("flexgantt command execution thread");
        this.runThread(thread);
    }

    @Override
    public void undo(final IProgressMonitor monitor) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                if (DefaultCommandStack.this.isUndoable()) {
                    ICommand cmd = (ICommand)DefaultCommandStack.this.executedCommands.getLast();
                    LOGGER.fine("undoing command: " + cmd);
                    try {
                        DefaultCommandStack.this.fireCommandStackChanged(new CommandStackEvent(DefaultCommandStack.this, cmd, CommandStackEvent.ID.COMMAND_STARTED));
                        cmd.undoCommand(monitor);
                        DefaultCommandStack.this.executedCommands.removeLast();
                        DefaultCommandStack.this.undoneCommands.addLast(cmd);
                        DefaultCommandStack.this.fireCommandStackChanged(new CommandStackEvent(DefaultCommandStack.this, cmd, CommandStackEvent.ID.COMMAND_UNDONE));
                    }
                    catch (Exception e2) {
                        LOGGER.throwing(DefaultCommandStack.class.getName(), "undo", e2);
                        DefaultCommandStack.this.fireCommandStackChanged(new CommandStackEvent(DefaultCommandStack.this, cmd, CommandStackEvent.ID.COMMAND_FAILED, e2));
                    }
                    finally {
                        monitor.done();
                    }
                }
            }
        };
        thread.setName("FlexganttCommandUndoThread");
        this.runThread(thread);
    }

    @Override
    public void redo(final IProgressMonitor monitor) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                if (DefaultCommandStack.this.isRedoable()) {
                    ICommand cmd = (ICommand)DefaultCommandStack.this.undoneCommands.getLast();
                    LOGGER.fine("redoing command: " + cmd);
                    try {
                        DefaultCommandStack.this.fireCommandStackChanged(new CommandStackEvent(DefaultCommandStack.this, cmd, CommandStackEvent.ID.COMMAND_STARTED));
                        cmd.redoCommand(monitor);
                        if (!monitor.isCanceled()) {
                            DefaultCommandStack.this.undoneCommands.removeLast();
                            DefaultCommandStack.this.executedCommands.addLast(cmd);
                            DefaultCommandStack.this.fireCommandStackChanged(new CommandStackEvent(DefaultCommandStack.this, cmd, CommandStackEvent.ID.COMMAND_EXECUTED));
                        } else {
                            LOGGER.fine("command was canceled, undoing it");
                            cmd.undoCommand(monitor);
                            DefaultCommandStack.this.fireCommandStackChanged(new CommandStackEvent(DefaultCommandStack.this, cmd, CommandStackEvent.ID.COMMAND_CANCELED));
                        }
                    }
                    catch (Exception e2) {
                        LOGGER.throwing(DefaultCommandStack.class.getName(), "redo", e2);
                        DefaultCommandStack.this.fireCommandStackChanged(new CommandStackEvent(DefaultCommandStack.this, cmd, CommandStackEvent.ID.COMMAND_FAILED, e2));
                    }
                    finally {
                        monitor.done();
                    }
                }
            }
        };
        thread.setName("FlexganttCommandRedoThread");
        this.runThread(thread);
    }

    private void runThread(Thread thread) {
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPropertyAccess("com.dlsc.flexgantt.unit.test");
            }
            if (Boolean.getBoolean("com.dlsc.flexgantt.unit.test")) {
                thread.run();
            } else {
                thread.start();
            }
        }
        catch (SecurityException ex) {
            thread.start();
        }
    }

    @Override
    public void clear() {
        LOGGER.fine("clearing command stack");
        this.executedCommands.clear();
        this.undoneCommands.clear();
    }

    @Override
    public boolean isUndoable() {
        if (this.executedCommands.size() > 0) {
            ICommand cmd = this.executedCommands.getLast();
            return cmd.isUndoable();
        }
        return false;
    }

    @Override
    public boolean isRedoable() {
        if (this.undoneCommands.size() > 0) {
            ICommand cmd = this.undoneCommands.getLast();
            return cmd.isRedoable();
        }
        return false;
    }

    @Override
    public void addCommandStackListener(ICommandStackListener l2) {
        LOGGER.log(Level.FINE, "adding listener: " + l2);
        this.listenersList.add(ICommandStackListener.class, l2);
    }

    @Override
    public void removeCommandStackListener(ICommandStackListener l2) {
        LOGGER.fine("removing listener: " + l2);
        this.listenersList.remove(ICommandStackListener.class, l2);
    }

    public ICommandStackListener[] getCommandStackListeners() {
        LinkedList<ICommandStackListener> result = new LinkedList<ICommandStackListener>();
        Object[] listeners = this.listenersList.getListenerList();
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != ICommandStackListener.class) continue;
            result.add((ICommandStackListener)listeners[i2 + 1]);
        }
        ICommandStackListener[] l2 = new ICommandStackListener[result.size()];
        return result.toArray(l2);
    }

    protected void fireCommandStackChanged(CommandStackEvent event) {
        LOGGER.fine("fireing command stack event: " + event);
        Object[] listeners = this.listenersList.getListenerList();
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != ICommandStackListener.class) continue;
            ((ICommandStackListener)listeners[i2 + 1]).commandStackChanged(event);
        }
    }

    @Override
    public ICommand getUndoableCommand() {
        ICommand cmd;
        if (!this.executedCommands.isEmpty() && (cmd = this.executedCommands.getLast()).isUndoable()) {
            return cmd;
        }
        return null;
    }

    @Override
    public ICommand getRedoableCommand() {
        if (!this.undoneCommands.isEmpty()) {
            return this.undoneCommands.getLast();
        }
        return null;
    }

    public List<ICommand> getExecutedCommands() {
        return new LinkedList<ICommand>(this.executedCommands);
    }

    public List<ICommand> getUndoneCommands() {
        return new LinkedList<ICommand>(this.undoneCommands);
    }
}

