/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.rollover;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jdesktop.swingx.rollover.RolloverRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RolloverController<T extends JComponent>
implements PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(RolloverController.class.getName());
    public static final String EXECUTE_BUTTON_ACTIONCOMMAND = "executeButtonAction";
    protected T component;

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.component == null || this.component != evt.getSource()) {
            return;
        }
        if ("swingx.rollover".equals(evt.getPropertyName())) {
            this.rollover((Point)evt.getOldValue(), (Point)evt.getNewValue());
        } else if ("swingx.clicked".equals(evt.getPropertyName())) {
            this.click((Point)evt.getNewValue());
        }
    }

    public void install(T table) {
        this.release();
        this.component = table;
        ((Container)table).addPropertyChangeListener("swingx.clicked", this);
        ((Container)table).addPropertyChangeListener("swingx.rollover", this);
        this.registerExecuteButtonAction();
    }

    public void release() {
        if (this.component == null) {
            return;
        }
        ((Component)this.component).removePropertyChangeListener("swingx.clicked", this);
        ((Component)this.component).removePropertyChangeListener("swingx.rollover", this);
        this.unregisterExecuteButtonAction();
        this.component = null;
    }

    protected abstract void rollover(Point var1, Point var2);

    protected void click(Point location) {
        if (!this.isClickable(location)) {
            return;
        }
        RolloverRenderer rollover = this.getRolloverRenderer(location, true);
        if (rollover != null) {
            rollover.doClick();
            ((Component)this.component).repaint();
        }
    }

    protected abstract RolloverRenderer getRolloverRenderer(Point var1, boolean var2);

    protected boolean isClickable(Point location) {
        return this.hasRollover(location);
    }

    protected boolean hasRollover(Point location) {
        if (location == null || location.x < 0 || location.y < 0) {
            return false;
        }
        return this.getRolloverRenderer(location, false) != null;
    }

    protected abstract Point getFocusedCell();

    protected void unregisterExecuteButtonAction() {
        ((JComponent)this.component).getActionMap().put(EXECUTE_BUTTON_ACTIONCOMMAND, null);
        KeyStroke space = KeyStroke.getKeyStroke("released SPACE");
        ((JComponent)this.component).getInputMap(1).put(space, null);
    }

    protected void registerExecuteButtonAction() {
        ((JComponent)this.component).getActionMap().put(EXECUTE_BUTTON_ACTIONCOMMAND, this.createExecuteButtonAction());
        KeyStroke space = KeyStroke.getKeyStroke("released SPACE");
        ((JComponent)this.component).getInputMap(1).put(space, EXECUTE_BUTTON_ACTIONCOMMAND);
    }

    protected Action createExecuteButtonAction() {
        return new AbstractAction(){

            public void actionPerformed(ActionEvent e2) {
                RolloverController.this.click(RolloverController.this.getFocusedCell());
            }

            public boolean isEnabled() {
                if (RolloverController.this.component == null || !((Component)RolloverController.this.component).isEnabled() || !((Component)RolloverController.this.component).hasFocus()) {
                    return false;
                }
                return RolloverController.this.isClickable(RolloverController.this.getFocusedCell());
            }
        };
    }
}

