/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.Timer;
import org.jdesktop.swingx.JXRootPane;
import org.jdesktop.swingx.JXStatusBar;
import org.jdesktop.swingx.util.WindowUtils;

public class JXFrame
extends JFrame {
    private Component waitPane = null;
    private Component glassPane = null;
    private boolean waitPaneVisible = false;
    private Cursor realCursor = null;
    private boolean waitCursorVisible = false;
    private boolean waiting = false;
    private StartPosition startPosition;
    private boolean hasBeenVisible = false;
    private AWTEventListener keyEventListener;
    private boolean keyPreview = false;
    private AWTEventListener idleListener;
    private Timer idleTimer;
    private long idleThreshold = 0L;
    private boolean idle;

    public JXFrame() {
        this(null, false);
    }

    public JXFrame(String title) {
        this(title, false);
    }

    public JXFrame(String title, boolean exitOnClose) {
        super(title);
        if (exitOnClose) {
            this.setDefaultCloseOperation(3);
        }
        this.keyEventListener = new AWTEventListener(){

            public void eventDispatched(AWTEvent aWTEvent) {
                if (aWTEvent instanceof KeyEvent) {
                    KeyEvent evt = (KeyEvent)aWTEvent;
                    block5: for (KeyListener kl : JXFrame.this.getKeyListeners()) {
                        int id2 = aWTEvent.getID();
                        switch (id2) {
                            case 401: {
                                kl.keyPressed(evt);
                                continue block5;
                            }
                            case 402: {
                                kl.keyReleased(evt);
                                continue block5;
                            }
                            case 400: {
                                kl.keyTyped(evt);
                                continue block5;
                            }
                            default: {
                                System.err.println("Unhandled Key ID: " + id2);
                            }
                        }
                    }
                }
            }
        };
        this.idleTimer = new Timer(100, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JXFrame.this.setIdle(true);
            }
        });
        this.idleListener = new AWTEventListener(){

            public void eventDispatched(AWTEvent aWTEvent) {
                JXFrame.this.idleTimer.stop();
                if (JXFrame.this.isIdle()) {
                    JXFrame.this.setIdle(false);
                }
                JXFrame.this.idleTimer.restart();
            }
        };
    }

    public void setCancelButton(JButton button) {
        this.getRootPaneExt().setCancelButton(button);
    }

    public JButton getCancelButton() {
        return this.getRootPaneExt().getCancelButton();
    }

    public void setDefaultButton(JButton button) {
        JButton old = this.getDefaultButton();
        this.getRootPane().setDefaultButton(button);
        this.firePropertyChange("defaultButton", old, this.getDefaultButton());
    }

    public JButton getDefaultButton() {
        return this.getRootPane().getDefaultButton();
    }

    public void setKeyPreview(boolean flag) {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.keyEventListener);
        if (flag) {
            Toolkit.getDefaultToolkit().addAWTEventListener(this.keyEventListener, 8L);
        }
        boolean old = this.keyPreview;
        this.keyPreview = flag;
        this.firePropertyChange("keyPreview", old, this.keyPreview);
    }

    public final boolean getKeyPreview() {
        return this.keyPreview;
    }

    public void setStartPosition(StartPosition position) {
        StartPosition old = this.getStartPosition();
        this.startPosition = position;
        this.firePropertyChange("startPosition", (Object)old, (Object)this.getStartPosition());
    }

    public StartPosition getStartPosition() {
        return this.startPosition == null ? StartPosition.Manual : this.startPosition;
    }

    public void setWaitCursorVisible(boolean flag) {
        boolean old = this.isWaitCursorVisible();
        if (flag != old) {
            this.waitCursorVisible = flag;
            if (this.isWaitCursorVisible()) {
                this.realCursor = this.getCursor();
                super.setCursor(Cursor.getPredefinedCursor(3));
            } else {
                super.setCursor(this.realCursor);
            }
            this.firePropertyChange("waitCursorVisible", old, this.isWaitCursorVisible());
        }
    }

    public boolean isWaitCursorVisible() {
        return this.waitCursorVisible;
    }

    public void setCursor(Cursor c2) {
        if (!this.isWaitCursorVisible()) {
            super.setCursor(c2);
        } else {
            this.realCursor = c2;
        }
    }

    public void setWaitPane(Component c2) {
        Component old = this.getWaitPane();
        this.waitPane = c2;
        this.firePropertyChange("waitPane", old, this.getWaitPane());
    }

    public Component getWaitPane() {
        return this.waitPane;
    }

    public void setWaitPaneVisible(boolean flag) {
        boolean old = this.isWaitPaneVisible();
        if (flag != old) {
            this.waitPaneVisible = flag;
            Component wp = this.getWaitPane();
            if (this.isWaitPaneVisible()) {
                this.glassPane = this.getRootPane().getGlassPane();
                if (wp != null) {
                    this.getRootPane().setGlassPane(wp);
                    wp.setVisible(true);
                }
            } else {
                if (wp != null) {
                    wp.setVisible(false);
                }
                this.getRootPane().setGlassPane(this.glassPane);
            }
            this.firePropertyChange("waitPaneVisible", old, this.isWaitPaneVisible());
        }
    }

    public boolean isWaitPaneVisible() {
        return this.waitPaneVisible;
    }

    public void setWaiting(boolean waiting) {
        boolean old = this.isWaiting();
        this.waiting = waiting;
        this.firePropertyChange("waiting", old, this.isWaiting());
        this.setWaitPaneVisible(waiting);
        this.setWaitCursorVisible(waiting);
    }

    public boolean isWaiting() {
        return this.waiting;
    }

    public void setVisible(boolean visible) {
        if (!this.hasBeenVisible && visible) {
            StartPosition pos = this.getStartPosition();
            switch (pos) {
                case CenterInParent: {
                    this.setLocationRelativeTo(this.getParent());
                    break;
                }
                case CenterInScreen: {
                    this.setLocation(WindowUtils.getPointForCentering(this));
                    break;
                }
            }
        }
        super.setVisible(visible);
    }

    public boolean isIdle() {
        return this.idle;
    }

    public void setIdle(boolean idle) {
        boolean old = this.isIdle();
        this.idle = idle;
        this.firePropertyChange("idle", old, this.isIdle());
    }

    public void setIdleThreshold(long threshold) {
        long old = this.getIdleThreshold();
        this.idleThreshold = threshold;
        this.firePropertyChange("idleThreshold", old, this.getIdleThreshold());
        threshold = this.getIdleThreshold();
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.idleListener);
        if (threshold > 0L) {
            Toolkit.getDefaultToolkit().addAWTEventListener(this.idleListener, 131128L);
        }
        this.idleTimer.stop();
        this.idleTimer.setInitialDelay((int)threshold);
        this.idleTimer.restart();
    }

    public long getIdleThreshold() {
        return this.idleThreshold;
    }

    public void setStatusBar(JXStatusBar statusBar) {
        this.getRootPaneExt().setStatusBar(statusBar);
    }

    public JXStatusBar getStatusBar() {
        return this.getRootPaneExt().getStatusBar();
    }

    public void setToolBar(JToolBar toolBar) {
        this.getRootPaneExt().setToolBar(toolBar);
    }

    public JToolBar getToolBar() {
        return this.getRootPaneExt().getToolBar();
    }

    protected JRootPane createRootPane() {
        return new JXRootPane();
    }

    public void setRootPane(JRootPane root) {
        super.setRootPane(root);
    }

    public JXRootPane getRootPaneExt() {
        if (this.rootPane instanceof JXRootPane) {
            return (JXRootPane)this.rootPane;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StartPosition {
        CenterInScreen,
        CenterInParent,
        Manual;

    }
}

