/*
 * Decompiled with CFR 0.152.
 */
package com.sun.animation.transitions;

import com.sun.animation.effects.ComponentState;
import com.sun.animation.transitions.AnimationLayer;
import com.sun.animation.transitions.AnimationManager;
import com.sun.animation.transitions.TransitionTarget;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;

public class ScreenTransition
implements TimingTarget {
    private AnimationManager animationManager;
    private AnimationLayer animationLayer;
    private JComponent containerLayer;
    private BufferedImage transitionImage;
    private BufferedImage transitionImageBG;
    private TransitionTarget transitionTarget;
    private Component savedGlassPane;
    private Animator timingController;

    public ScreenTransition(JComponent transitionComponent, TransitionTarget transitionTarget) {
        this.containerLayer = transitionComponent;
        this.transitionTarget = transitionTarget;
        this.animationManager = new AnimationManager();
        this.animationLayer = new AnimationLayer(this);
        this.animationLayer.setVisible(false);
    }

    public Container getContentPane() {
        return this.containerLayer;
    }

    Image getTransitionImage() {
        return this.transitionImage;
    }

    boolean isOpaque() {
        return this.containerLayer.isOpaque();
    }

    @Override
    public void timingEvent(float elapsedFraction) {
        Graphics2D gImg = (Graphics2D)this.transitionImage.getGraphics();
        gImg.drawImage((Image)this.transitionImageBG, 0, 0, null);
        this.animationManager.paint(gImg, elapsedFraction);
        gImg.dispose();
        this.animationLayer.repaint();
    }

    @Override
    public void begin() {
    }

    @Override
    public void end() {
        this.containerLayer.getRootPane().setGlassPane(this.savedGlassPane);
        this.containerLayer.getRootPane().getGlassPane().setVisible(false);
        this.animationLayer.setVisible(false);
        this.containerLayer.setVisible(true);
        this.containerLayer.repaint();
        this.timingController = null;
        this.transitionTarget.transitionComplete();
    }

    public boolean isTransitioning() {
        return this.animationLayer.isVisible();
    }

    public void startTransition(int transitionTimeMS) {
        if (this.isTransitioning() && this.timingController != null) {
            this.timingController.stop();
        }
        this.animationManager.reset();
        for (Component child : this.containerLayer.getComponents()) {
            if (!child.isVisible() || !(child instanceof JComponent)) continue;
            this.animationManager.addStart((JComponent)child);
        }
        this.transitionTarget.resetCurrentScreen();
        int cw = this.containerLayer.getWidth();
        int ch = this.containerLayer.getHeight();
        if (this.transitionImage == null || this.transitionImage.getWidth() != cw || this.transitionImage.getHeight() != ch) {
            this.transitionImage = (BufferedImage)this.containerLayer.createImage(cw, ch);
            this.transitionImageBG = (BufferedImage)this.containerLayer.createImage(cw, ch);
        }
        Graphics gImg = this.transitionImageBG.getGraphics();
        ComponentState.paintComponentHierarchySingleBuffered(this.containerLayer, gImg);
        gImg.dispose();
        this.animationLayer.setupBackground(this.containerLayer);
        this.savedGlassPane = this.containerLayer.getRootPane().getGlassPane();
        this.containerLayer.getRootPane().setGlassPane(this.animationLayer);
        this.containerLayer.getRootPane().getGlassPane().setVisible(true);
        this.containerLayer.setVisible(false);
        this.transitionTarget.setupNextScreen();
        this.containerLayer.validate();
        for (Component child : this.containerLayer.getComponents()) {
            if (!child.isVisible() || !(child instanceof JComponent)) continue;
            this.animationManager.addEnd((JComponent)child);
        }
        this.animationManager.init();
        this.timingEvent(0.0f);
        this.timingController = new Animator(transitionTimeMS, this);
        this.timingController.start();
    }

    @Override
    public void repeat() {
    }
}

