/*
 * Decompiled with CFR 0.152.
 */
package com.sun.animation.transitions;

import com.sun.animation.effects.ComponentState;
import com.sun.animation.transitions.AnimationState;
import java.awt.Component;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;

class AnimationManager {
    private Map<Component, AnimationState> componentAnimationStates = new HashMap<Component, AnimationState>();

    AnimationManager() {
    }

    private AnimationState getExistingAnimationState(Component component) {
        return this.componentAnimationStates.get(component);
    }

    void setFraction(float fraction) {
    }

    void reset() {
        this.componentAnimationStates.clear();
    }

    void init() {
        for (AnimationState state : this.componentAnimationStates.values()) {
            state.init();
        }
    }

    void addStart(JComponent component) {
        AnimationState existingAnimState = this.getExistingAnimationState(component);
        if (existingAnimState != null) {
            existingAnimState.setStart(new ComponentState(component));
        } else {
            AnimationState animState = new AnimationState(component, true);
            this.componentAnimationStates.put(component, animState);
        }
    }

    void addEnd(JComponent component) {
        AnimationState existingAnimState = this.getExistingAnimationState(component);
        if (existingAnimState != null) {
            existingAnimState.setEnd(new ComponentState(component));
        } else {
            AnimationState animState = new AnimationState(component, false);
            this.componentAnimationStates.put(component, animState);
        }
    }

    void paint(Graphics g2, float fraction) {
        for (AnimationState state : this.componentAnimationStates.values()) {
            state.paint(g2, fraction);
        }
    }
}

