/*
 * Decompiled with CFR 0.152.
 */
package com.sun.animation.effects;

import com.sun.animation.effects.ComponentEffect;
import com.sun.animation.effects.ComponentState;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;

public class CompositeEffect
extends ComponentEffect {
    private final List<ComponentEffect> effects = new ArrayList<ComponentEffect>();

    public CompositeEffect() {
    }

    public CompositeEffect(ComponentEffect effect) {
        this.addEffect(effect);
    }

    public void addEffect(ComponentEffect effect) {
        this.effects.add(effect);
        if (effect.getRenderComponent()) {
            this.setRenderComponent(true);
        }
        if (this.start == null) {
            this.start = effect.getStart();
        }
        if (this.end == null) {
            this.end = effect.getEnd();
        }
    }

    @Override
    public void setStart(ComponentState start) {
        for (ComponentEffect effect : this.effects) {
            effect.setStart(start);
        }
        super.setStart(start);
    }

    @Override
    public void setEnd(ComponentState end) {
        for (ComponentEffect effect : this.effects) {
            effect.setEnd(end);
        }
        super.setEnd(end);
    }

    @Override
    public void setup(Graphics2D g2d, float fraction) {
        for (int i2 = 0; i2 < this.effects.size(); ++i2) {
            ComponentEffect effect = this.effects.get(i2);
            effect.setup(g2d, fraction);
            if (this.renderComponent || this.componentImage != null) continue;
            this.setComponentImage(effect.componentImage);
        }
        super.setup(g2d, fraction);
    }
}

