/*
 * Decompiled with CFR 0.152.
 */
package com.sun.animation.effects;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

public class ComponentState {
    private JComponent component;
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private Image componentSnapshot;

    public ComponentState(JComponent component) {
        this.component = component;
        this.x = component.getX();
        this.y = component.getY();
        this.width = component.getWidth();
        this.height = component.getHeight();
        this.componentSnapshot = this.createSnapshot(component);
    }

    private Image createSnapshot(JComponent component) {
        GraphicsConfiguration gc2 = component.getGraphicsConfiguration();
        if (gc2 == null) {
            gc2 = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        BufferedImage snapshot = gc2.createCompatibleImage(this.width, this.height, component.isOpaque() ? 1 : 3);
        Graphics2D gImg = (Graphics2D)((Image)snapshot).getGraphics();
        Composite defaultComposite = gImg.getComposite();
        gImg.setComposite(AlphaComposite.Src);
        gImg.setColor(new Color(0, 0, 0, 0));
        gImg.fillRect(0, 0, this.width, this.height);
        gImg.setComposite(defaultComposite);
        ComponentState.paintComponentSingleBuffered(component, gImg);
        gImg.dispose();
        return snapshot;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public JComponent getComponent() {
        return this.component;
    }

    public Image getSnapshot() {
        if (this.componentSnapshot == null) {
            this.componentSnapshot = this.createSnapshot(this.component);
        }
        return this.componentSnapshot;
    }

    public static void paintComponentSingleBuffered(JComponent component, Graphics g2) {
        component.paint(g2);
    }

    public static void paintComponentHierarchySingleBuffered(JComponent component, Graphics g2) {
        int x2 = 0;
        int y2 = 0;
        int w2 = component.getWidth();
        int h2 = component.getHeight();
        JComponent topmost = component;
        JComponent prevTopmost = component;
        while (!topmost.isOpaque() && topmost.getParent() != null && topmost.getParent() instanceof JComponent) {
            topmost = (JComponent)topmost.getParent();
            x2 += prevTopmost.getX();
            y2 += prevTopmost.getY();
            prevTopmost = topmost;
        }
        g2.setClip(0, 0, w2, h2);
        g2.translate(-x2, -y2);
        topmost.paint(g2);
    }
}

