/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.Colormap;
import com.jhlabs.image.Gradient;
import com.jhlabs.image.ImageMath;
import com.jhlabs.image.PixelUtils;
import com.jhlabs.image.PointFilter;
import com.jhlabs.math.Function2D;
import com.jhlabs.math.Noise;
import java.io.Serializable;

public class TextureFilter
extends PointFilter
implements Serializable {
    static final long serialVersionUID = -7538331862272404352L;
    private float scale = 32.0f;
    private float stretch = 1.0f;
    private float angle = 0.0f;
    public float amount = 1.0f;
    public float turbulence = 1.0f;
    public float gain = 0.5f;
    public float bias = 0.5f;
    public int operation;
    private float m00 = 1.0f;
    private float m01 = 0.0f;
    private float m10 = 0.0f;
    private float m11 = 1.0f;
    private Colormap colormap = new Gradient();
    private Function2D function = new Noise();

    public void setAmount(float amount) {
        this.amount = amount;
    }

    public float getAmount() {
        return this.amount;
    }

    public void setFunction(Function2D function) {
        this.function = function;
    }

    public Function2D getFunction() {
        return this.function;
    }

    public void setOperation(int operation) {
        this.operation = operation;
    }

    public int getOperation() {
        return this.operation;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public float getScale() {
        return this.scale;
    }

    public void setStretch(float stretch) {
        this.stretch = stretch;
    }

    public float getStretch() {
        return this.stretch;
    }

    public void setAngle(float angle) {
        this.angle = angle;
        float cos = (float)Math.cos(angle);
        float sin = (float)Math.sin(angle);
        this.m00 = cos;
        this.m01 = sin;
        this.m10 = -sin;
        this.m11 = cos;
    }

    public float getAngle() {
        return this.angle;
    }

    public void setTurbulence(float turbulence) {
        this.turbulence = turbulence;
    }

    public float getTurbulence() {
        return this.turbulence;
    }

    public void setColormap(Colormap colormap) {
        this.colormap = colormap;
    }

    public Colormap getColormap() {
        return this.colormap;
    }

    public int filterRGB(int x2, int y2, int rgb) {
        int v2;
        float nx = this.m00 * (float)x2 + this.m01 * (float)y2;
        float ny = this.m10 * (float)x2 + this.m11 * (float)y2;
        float f2 = (double)this.turbulence == 1.0 ? Noise.noise2(nx, ny) : Noise.turbulence2(nx /= this.scale, ny /= this.scale * this.stretch, this.turbulence);
        f2 = f2 * 0.5f + 0.5f;
        f2 = ImageMath.gain(f2, this.gain);
        f2 = ImageMath.bias(f2, this.bias);
        f2 *= this.amount;
        int a2 = rgb & 0xFF000000;
        if (this.colormap != null) {
            v2 = this.colormap.getColor(f2);
        } else {
            v2 = PixelUtils.clamp((int)(f2 * 255.0f));
            int r2 = v2 << 16;
            int g2 = v2 << 8;
            int b2 = v2;
            v2 = a2 | r2 | g2 | b2;
        }
        if (this.operation != 0) {
            v2 = PixelUtils.combinePixels(rgb, v2, this.operation);
        }
        return v2;
    }

    public String toString() {
        return "Texture/Noise...";
    }
}

