/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.PointFilter;

public class FourColorFilter
extends PointFilter {
    private int width;
    private int height;
    private int colorNW;
    private int colorNE;
    private int colorSW;
    private int colorSE;
    private int rNW;
    private int gNW;
    private int bNW;
    private int rNE;
    private int gNE;
    private int bNE;
    private int rSW;
    private int gSW;
    private int bSW;
    private int rSE;
    private int gSE;
    private int bSE;

    public FourColorFilter() {
        this.setColorNW(-65536);
        this.setColorNE(-65281);
        this.setColorSW(-16776961);
        this.setColorSE(-16711681);
    }

    public void setColorNW(int color) {
        this.colorNW = color;
        this.rNW = color >> 16 & 0xFF;
        this.gNW = color >> 8 & 0xFF;
        this.bNW = color & 0xFF;
    }

    public int getColorNW() {
        return this.colorNW;
    }

    public void setColorNE(int color) {
        this.colorNE = color;
        this.rNE = color >> 16 & 0xFF;
        this.gNE = color >> 8 & 0xFF;
        this.bNE = color & 0xFF;
    }

    public int getColorNE() {
        return this.colorNE;
    }

    public void setColorSW(int color) {
        this.colorSW = color;
        this.rSW = color >> 16 & 0xFF;
        this.gSW = color >> 8 & 0xFF;
        this.bSW = color & 0xFF;
    }

    public int getColorSW() {
        return this.colorSW;
    }

    public void setColorSE(int color) {
        this.colorSE = color;
        this.rSE = color >> 16 & 0xFF;
        this.gSE = color >> 8 & 0xFF;
        this.bSE = color & 0xFF;
    }

    public int getColorSE() {
        return this.colorSE;
    }

    public void setDimensions(int width, int height) {
        this.width = width;
        this.height = height;
        super.setDimensions(width, height);
    }

    public int filterRGB(int x2, int y2, int rgb) {
        float fx = (float)x2 / (float)this.width;
        float fy = (float)y2 / (float)this.height;
        float p2 = (float)this.rNW + (float)(this.rNE - this.rNW) * fx;
        float q2 = (float)this.rSW + (float)(this.rSE - this.rSW) * fx;
        int r2 = (int)(p2 + (q2 - p2) * fy + 0.5f);
        p2 = (float)this.gNW + (float)(this.gNE - this.gNW) * fx;
        q2 = (float)this.gSW + (float)(this.gSE - this.gSW) * fx;
        int g2 = (int)(p2 + (q2 - p2) * fy + 0.5f);
        p2 = (float)this.bNW + (float)(this.bNE - this.bNW) * fx;
        q2 = (float)this.bSW + (float)(this.bSE - this.bSW) * fx;
        int b2 = (int)(p2 + (q2 - p2) * fy + 0.5f);
        return 0xFF000000 | r2 << 16 | g2 << 8 | b2;
    }

    public String toString() {
        return "Texture/Four Color Fill...";
    }
}

