/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.TransformFilter;
import java.awt.image.BufferedImage;

public class DisplaceFilter
extends TransformFilter {
    private float amount = 1.0f;
    private BufferedImage displacementMap = null;
    private int[] xmap;
    private int[] ymap;
    private int dw;
    private int dh;

    public void setDisplacementMap(BufferedImage displacementMap) {
        this.displacementMap = displacementMap;
    }

    public BufferedImage getDisplacementMap() {
        return this.displacementMap;
    }

    public void setAmount(float amount) {
        this.amount = amount;
    }

    public float getAmount() {
        return this.amount;
    }

    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        int y2;
        int w2 = src.getWidth();
        int h2 = src.getHeight();
        BufferedImage dm = this.displacementMap != null ? this.displacementMap : src;
        this.dw = dm.getWidth();
        this.dh = dm.getHeight();
        int[] mapPixels = new int[this.dw * this.dh];
        this.getRGB(dm, 0, 0, this.dw, this.dh, mapPixels);
        this.xmap = new int[this.dw * this.dh];
        this.ymap = new int[this.dw * this.dh];
        int i2 = 0;
        for (y2 = 0; y2 < this.dh; ++y2) {
            for (int x2 = 0; x2 < this.dw; ++x2) {
                int rgb = mapPixels[i2];
                int r2 = rgb >> 16 & 0xFF;
                int g2 = rgb >> 8 & 0xFF;
                int b2 = rgb & 0xFF;
                mapPixels[i2] = (r2 + g2 + b2) / 8;
                ++i2;
            }
        }
        i2 = 0;
        for (y2 = 0; y2 < this.dh; ++y2) {
            int j1 = (y2 + this.dh - 1) % this.dh * this.dw;
            int j2 = y2 * this.dw;
            int j3 = (y2 + 1) % this.dh * this.dw;
            for (int x3 = 0; x3 < this.dw; ++x3) {
                int k1 = (x3 + this.dw - 1) % this.dw;
                int k2 = x3;
                int k3 = (x3 + 1) % this.dw;
                this.xmap[i2] = mapPixels[k1 + j1] + mapPixels[k1 + j2] + mapPixels[k1 + j3] - mapPixels[k3 + j1] - mapPixels[k3 + j2] - mapPixels[k3 + j3];
                this.ymap[i2] = mapPixels[k1 + j3] + mapPixels[k2 + j3] + mapPixels[k3 + j3] - mapPixels[k1 + j1] - mapPixels[k2 + j1] - mapPixels[k3 + j1];
                ++i2;
            }
        }
        mapPixels = null;
        dst = super.filter(src, dst);
        this.ymap = null;
        this.xmap = null;
        return dst;
    }

    protected void transformInverse(int x2, int y2, float[] out) {
        float nx = x2;
        float ny = y2;
        int i2 = y2 % this.dh * this.dw + x2 % this.dw;
        out[0] = (float)x2 + this.amount * (float)this.xmap[i2];
        out[1] = (float)y2 + this.amount * (float)this.ymap[i2];
    }

    public String toString() {
        return "Distort/Displace...";
    }
}

