/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.WholeImageFilter;
import java.awt.Rectangle;

public class DespeckleFilter
extends WholeImageFilter {
    protected short pepperAndSalt(short c2, short v1, short v2) {
        if (c2 < v1) {
            c2 = (short)(c2 + 1);
        }
        if (c2 < v2) {
            c2 = (short)(c2 + 1);
        }
        if (c2 > v1) {
            c2 = (short)(c2 - 1);
        }
        if (c2 > v2) {
            c2 = (short)(c2 - 1);
        }
        return c2;
    }

    protected int[] filterPixels(int width, int height, int[] inPixels, Rectangle transformedSpace) {
        int index = 0;
        short[][] r2 = new short[3][width];
        short[][] g2 = new short[3][width];
        short[][] b2 = new short[3][width];
        int[] outPixels = new int[width * height];
        for (int x2 = 0; x2 < width; ++x2) {
            int rgb = inPixels[x2];
            r2[1][x2] = (short)(rgb >> 16 & 0xFF);
            g2[1][x2] = (short)(rgb >> 8 & 0xFF);
            b2[1][x2] = (short)(rgb & 0xFF);
        }
        for (int y2 = 0; y2 < height; ++y2) {
            int x3;
            boolean yIn = y2 > 0 && y2 < height - 1;
            int nextRowIndex = index + width;
            if (y2 < height - 1) {
                for (x3 = 0; x3 < width; ++x3) {
                    int rgb = inPixels[nextRowIndex++];
                    r2[2][x3] = (short)(rgb >> 16 & 0xFF);
                    g2[2][x3] = (short)(rgb >> 8 & 0xFF);
                    b2[2][x3] = (short)(rgb & 0xFF);
                }
            }
            for (x3 = 0; x3 < width; ++x3) {
                boolean xIn = x3 > 0 && x3 < width - 1;
                short or = r2[1][x3];
                short og = g2[1][x3];
                short ob2 = b2[1][x3];
                int w2 = x3 - 1;
                int e2 = x3 + 1;
                if (yIn) {
                    or = this.pepperAndSalt(or, r2[0][x3], r2[2][x3]);
                    og = this.pepperAndSalt(og, g2[0][x3], g2[2][x3]);
                    ob2 = this.pepperAndSalt(ob2, b2[0][x3], b2[2][x3]);
                }
                if (xIn) {
                    or = this.pepperAndSalt(or, r2[1][w2], r2[1][e2]);
                    og = this.pepperAndSalt(og, g2[1][w2], g2[1][e2]);
                    ob2 = this.pepperAndSalt(ob2, b2[1][w2], b2[1][e2]);
                }
                if (yIn && xIn) {
                    or = this.pepperAndSalt(or, r2[0][w2], r2[2][e2]);
                    og = this.pepperAndSalt(og, g2[0][w2], g2[2][e2]);
                    ob2 = this.pepperAndSalt(ob2, b2[0][w2], b2[2][e2]);
                    or = this.pepperAndSalt(or, r2[2][w2], r2[0][e2]);
                    og = this.pepperAndSalt(og, g2[2][w2], g2[0][e2]);
                    ob2 = this.pepperAndSalt(ob2, b2[2][w2], b2[0][e2]);
                }
                outPixels[index] = inPixels[index] & 0xFF000000 | or << 16 | og << 8 | ob2;
                ++index;
            }
            short[] t2 = r2[0];
            r2[0] = r2[1];
            r2[1] = r2[2];
            r2[2] = t2;
            t2 = g2[0];
            g2[0] = g2[1];
            g2[1] = g2[2];
            g2[2] = t2;
            t2 = b2[0];
            b2[0] = b2[1];
            b2[1] = b2[2];
            b2[2] = t2;
        }
        return outPixels;
    }

    public String toString() {
        return "Blur/Despeckle...";
    }
}

