/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.AbstractBufferedImageOp;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;

public class CropFilter
extends AbstractBufferedImageOp {
    private int x;
    private int y;
    private int width;
    private int height;

    public CropFilter() {
        this(0, 0, 32, 32);
    }

    public CropFilter(int x2, int y2, int width, int height) {
        this.x = x2;
        this.y = y2;
        this.width = width;
        this.height = height;
    }

    public void setX(int x2) {
        this.x = x2;
    }

    public int getX() {
        return this.x;
    }

    public void setY(int y2) {
        this.y = y2;
    }

    public int getY() {
        return this.y;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getWidth() {
        return this.width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getHeight() {
        return this.height;
    }

    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        int w2 = src.getWidth();
        int h2 = src.getHeight();
        if (dst == null) {
            ColorModel dstCM = src.getColorModel();
            dst = new BufferedImage(dstCM, dstCM.createCompatibleWritableRaster(this.width, this.height), dstCM.isAlphaPremultiplied(), null);
        }
        Graphics2D g2 = dst.createGraphics();
        g2.drawRenderedImage(src, AffineTransform.getTranslateInstance(-this.x, -this.y));
        g2.dispose();
        return dst;
    }

    public String toString() {
        return "Distort/Crop";
    }
}

