/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.plaf.metal.MetalLookAndFeel;

public final class PlasticXPUtils {
    private PlasticXPUtils() {
    }

    static void drawPlainButtonBorder(Graphics g2, int x2, int y2, int w2, int h2) {
        PlasticXPUtils.drawButtonBorder(g2, x2, y2, w2, h2, PlasticLookAndFeel.getControl(), PlasticLookAndFeel.getControlDarkShadow(), LookUtils.getSlightlyBrighter(PlasticLookAndFeel.getControlDarkShadow(), 1.25f));
    }

    static void drawPressedButtonBorder(Graphics g2, int x2, int y2, int w2, int h2) {
        PlasticXPUtils.drawPlainButtonBorder(g2, x2, y2, w2, h2);
        Color darkColor = PlasticXPUtils.translucentColor(PlasticLookAndFeel.getControlDarkShadow(), 128);
        Color lightColor = PlasticXPUtils.translucentColor(PlasticLookAndFeel.getControlHighlight(), 80);
        g2.translate(x2, y2);
        g2.setColor(darkColor);
        g2.fillRect(2, 1, w2 - 4, 1);
        g2.setColor(lightColor);
        g2.fillRect(2, h2 - 2, w2 - 4, 1);
        g2.translate(-x2, -y2);
    }

    static void drawDefaultButtonBorder(Graphics g2, int x2, int y2, int w2, int h2) {
        PlasticXPUtils.drawPlainButtonBorder(g2, x2, y2, w2, h2);
        PlasticXPUtils.drawInnerButtonDecoration(g2, x2, y2, w2, h2, PlasticLookAndFeel.getPrimaryControlDarkShadow());
    }

    static void drawFocusedButtonBorder(Graphics g2, int x2, int y2, int w2, int h2) {
        PlasticXPUtils.drawPlainButtonBorder(g2, x2, y2, w2, h2);
        PlasticXPUtils.drawInnerButtonDecoration(g2, x2, y2, w2, h2, PlasticLookAndFeel.getFocusColor());
    }

    static void drawDisabledButtonBorder(Graphics g2, int x2, int y2, int w2, int h2) {
        PlasticXPUtils.drawButtonBorder(g2, x2, y2, w2, h2, PlasticLookAndFeel.getControl(), MetalLookAndFeel.getControlShadow(), LookUtils.getSlightlyBrighter(MetalLookAndFeel.getControlShadow()));
    }

    public static void drawButtonBorder(Graphics g2, int x2, int y2, int w2, int h2, Color backgroundColor, Color edgeColor, Color cornerColor) {
        g2.translate(x2, y2);
        g2.setColor(edgeColor);
        PlasticXPUtils.drawRect(g2, 0, 0, w2 - 1, h2 - 1);
        g2.setColor(cornerColor);
        g2.fillRect(0, 0, 2, 2);
        g2.fillRect(0, h2 - 2, 2, 2);
        g2.fillRect(w2 - 2, 0, 2, 2);
        g2.fillRect(w2 - 2, h2 - 2, 2, 2);
        g2.setColor(backgroundColor);
        g2.fillRect(0, 0, 1, 1);
        g2.fillRect(0, h2 - 1, 1, 1);
        g2.fillRect(w2 - 1, 0, 1, 1);
        g2.fillRect(w2 - 1, h2 - 1, 1, 1);
        g2.translate(-x2, -y2);
    }

    private static void drawInnerButtonDecoration(Graphics g2, int x2, int y2, int w2, int h2, Color baseColor) {
        Color lightColor = PlasticXPUtils.translucentColor(baseColor, 90);
        Color mediumColor = PlasticXPUtils.translucentColor(baseColor, 120);
        Color darkColor = PlasticXPUtils.translucentColor(baseColor, 200);
        g2.translate(x2, y2);
        g2.setColor(lightColor);
        g2.fillRect(2, 1, w2 - 4, 1);
        g2.setColor(mediumColor);
        g2.fillRect(1, 2, 1, h2 - 4);
        g2.fillRect(w2 - 2, 2, 1, h2 - 4);
        PlasticXPUtils.drawRect(g2, 2, 2, w2 - 5, h2 - 5);
        g2.setColor(darkColor);
        g2.fillRect(2, h2 - 2, w2 - 4, 1);
        g2.translate(-x2, -y2);
    }

    static void drawRect(Graphics g2, int x2, int y2, int w2, int h2) {
        g2.fillRect(x2, y2, w2 + 1, 1);
        g2.fillRect(x2, y2 + 1, 1, h2);
        g2.fillRect(x2 + 1, y2 + h2, w2, 1);
        g2.fillRect(x2 + w2, y2 + 1, 1, h2);
    }

    private static Color translucentColor(Color baseColor, int alpha) {
        return new Color(baseColor.getRed(), baseColor.getGreen(), baseColor.getBlue(), alpha);
    }
}

