/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.print;

import com.dlsc.flexgantt.swing.AbstractGanttChart;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.io.IOException;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class PrintSetup {
    private static final Logger LOGGER = Logger.getLogger(PrintSetup.class.getName());
    private String centerFooter = "Date / Time: $DATE$, $TIME$";
    private boolean footerVisible = true;
    private boolean headerVisible = true;
    private String leftFooter = "Printed by $USER$";
    private int headerHeight = 50;
    private int footerHeight = 20;
    private Image logo;
    private String rightFooter = "Page $PAGE_NUMBER$ / $PAGE_TOTAL$";
    private String title = "Gantt Chart";
    private Font titleFont = new Font("SansSerif", 1, 18);
    private Color titleColor = Color.BLACK;
    private Font footerFont = new Font("SansSerif", 0, 12);
    private Color footerColor = Color.GRAY;
    private int verticalGap = 10;

    public PrintSetup() {
        try {
            this.logo = ImageIO.read(AbstractGanttChart.class.getResource("printlogo.png"));
        }
        catch (IOException ex) {
            LOGGER.throwing(this.getClass().getName(), "<init>", ex);
        }
    }

    public String getCenterFooter() {
        return this.centerFooter;
    }

    public String getLeftFooter() {
        return this.leftFooter;
    }

    public Image getLogo() {
        return this.logo;
    }

    public String getRightFooter() {
        return this.rightFooter;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isFooterVisible() {
        return this.footerVisible;
    }

    public boolean isHeaderVisible() {
        return this.headerVisible;
    }

    public void setCenterFooter(String text) {
        this.centerFooter = text;
    }

    public void setFooterVisible(boolean v2) {
        this.footerVisible = v2;
    }

    public void setHeaderVisible(boolean v2) {
        this.headerVisible = v2;
    }

    public void setLeftFooter(String text) {
        this.leftFooter = text;
    }

    public void setLogo(Image logo) {
        this.logo = logo;
    }

    public void setRightFooter(String text) {
        this.rightFooter = text;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public void setTitleFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("title font can not be NULL");
        }
        this.titleFont = font;
    }

    public Color getTitleColor() {
        return this.titleColor;
    }

    public void setTitleColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("title color can not be NULL");
        }
        this.titleColor = color;
    }

    public Font getFooterFont() {
        return this.footerFont;
    }

    public void setFooterFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("footer font can not be NULL");
        }
        this.footerFont = font;
    }

    public Color getFooterColor() {
        return this.footerColor;
    }

    public void setFooterColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("footer color can not be NULL");
        }
        this.footerColor = color;
    }

    public int getHeaderHeight() {
        return this.headerHeight;
    }

    public void setHeaderHeight(int height) {
        if (height < 0) {
            throw new IllegalArgumentException("header height can not be smaller than 0, but was " + height);
        }
        this.headerHeight = height;
    }

    public int getFooterHeight() {
        return this.footerHeight;
    }

    public void setFooterHeight(int height) {
        if (height < 0) {
            throw new IllegalArgumentException("footer height can not be smaller than 0, but was " + height);
        }
        this.footerHeight = height;
    }

    public int getVerticalGap() {
        return this.verticalGap;
    }

    public void setVerticalGap(int gap) {
        if (gap < 0) {
            throw new IllegalArgumentException("vertical print gap can not be smaller than 0, but was " + gap);
        }
        this.verticalGap = gap;
    }
}

