/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.mac;

import com.dlsc.flexgantt.icons.IconId;
import com.dlsc.flexgantt.icons.IconRegistry;
import com.dlsc.flexgantt.model.gantt.DefaultResourceNode;
import com.dlsc.flexgantt.model.gantt.IGanttChartModel;
import com.dlsc.flexgantt.model.treetable.ITreeTableModel;
import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.DefaultComponentFactory;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.LayerContainerRowHeader;
import com.dlsc.flexgantt.swing.layer.LayerContainerScrollPane;
import com.dlsc.flexgantt.swing.layer.system.DefaultResourceRowRenderer;
import com.dlsc.flexgantt.swing.layer.system.RowLayer;
import com.dlsc.flexgantt.swing.mac.EmphasizedLabelUI;
import com.dlsc.flexgantt.swing.mac.MacColumnHeaderRenderer;
import com.dlsc.flexgantt.swing.mac.MacDateline;
import com.dlsc.flexgantt.swing.mac.MacEventline;
import com.dlsc.flexgantt.swing.mac.MacLayerContainerRowHeader;
import com.dlsc.flexgantt.swing.mac.MacLayerFactory;
import com.dlsc.flexgantt.swing.mac.MacTimeGranularityDatelineRenderer;
import com.dlsc.flexgantt.swing.mac.MacTreeTableRowHeader;
import com.dlsc.flexgantt.swing.mac.MacTreeTableRowHeaderRenderer;
import com.dlsc.flexgantt.swing.selector.ISelectorFactory;
import com.dlsc.flexgantt.swing.selector.Selector;
import com.dlsc.flexgantt.swing.timeline.Dateline;
import com.dlsc.flexgantt.swing.timeline.Eventline;
import com.dlsc.flexgantt.swing.timeline.TimeGranularityDatelineModel;
import com.dlsc.flexgantt.swing.timeline.Timeline;
import com.dlsc.flexgantt.swing.treetable.TreeTable;
import com.dlsc.flexgantt.swing.treetable.TreeTableHeader;
import com.dlsc.flexgantt.swing.treetable.TreeTableRowHeader;
import com.dlsc.flexgantt.swing.treetable.TreeTableScrollPane;
import com.dlsc.flexgantt.swing.util.CornerStone;
import com.dlsc.flexgantt.swing.util.CustomizableLineBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class MacComponentFactory
extends DefaultComponentFactory {
    private static MacComponentFactory instance;
    private static Image glossyImage;

    protected MacComponentFactory() {
        try {
            glossyImage = ImageIO.read(MacComponentFactory.class.getResource("shiny_background.png"));
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public static synchronized MacComponentFactory getInstance() {
        if (instance == null) {
            instance = new MacComponentFactory();
        }
        return instance;
    }

    @Override
    public LayerContainer createLayerContainer(AbstractGanttChart gc2, TreeTable table, IGanttChartModel model) {
        LayerContainer lc2 = new LayerContainer(gc2, model, table, new MacLayerFactory());
        lc2.setBackground(Color.WHITE);
        lc2.setAlternatingBackground(new Color(240, 240, 240));
        lc2.setTimelineObjectStatusColor("ERROR", Color.RED);
        lc2.setTimelineObjectStatusIcon("WARNING", IconRegistry.getIcon(IconId.WARNING));
        DefaultResourceRowRenderer rowRenderer = new DefaultResourceRowRenderer();
        rowRenderer.setMajorCapacityLineColor(Color.LIGHT_GRAY);
        RowLayer rl = lc2.getSystemLayer(RowLayer.class);
        rl.setRowRenderer(DefaultResourceNode.class, rowRenderer);
        return lc2;
    }

    @Override
    public JComponent createLayerContainerCorner(LayerContainer lc2, String corner) {
        if (corner.equals("UPPER_LEFT_CORNER")) {
            JPanel control = new JPanel(){

                @Override
                protected void paintComponent(Graphics g2) {
                    super.paintComponent(g2);
                    MacComponentFactory.paintGlossyBackground(this, g2, this.getWidth(), this.getHeight());
                }
            };
            control.setBorder(new CustomizableLineBorder(true, false, true, true));
            control.setBackground(new Color(230, 230, 230));
            return control;
        }
        return super.createLayerContainerCorner(lc2, corner);
    }

    @Override
    public LayerContainerRowHeader createLayerContainerRowHeader(LayerContainer lc2) {
        MacLayerContainerRowHeader header = new MacLayerContainerRowHeader(lc2);
        header.setBackground(new Color(230, 230, 230));
        header.setBorder(new CustomizableLineBorder(false, false, false, true));
        return header;
    }

    @Override
    public TreeTable createTreeTable(AbstractGanttChart gc2, ITreeTableModel model) {
        TreeTable table = super.createTreeTable(gc2, model);
        table.setRootVisible(true);
        table.setBackground(Color.WHITE);
        table.setAlternatingBackground(new Color(240, 240, 240));
        return table;
    }

    @Override
    public Dateline createDateline(Timeline timeline) {
        MacDateline dateline = new MacDateline(timeline);
        dateline.setOpaque(false);
        dateline.setDatelineRenderer(TimeGranularityDatelineModel.class, new MacTimeGranularityDatelineRenderer());
        return dateline;
    }

    @Override
    public Eventline createEventline(Timeline timeline, Dateline dateline) {
        MacEventline eventline = new MacEventline(timeline, dateline);
        eventline.setOpaque(false);
        return eventline;
    }

    @Override
    public TreeTableRowHeader createTreeTableRowHeader(TreeTable table) {
        MacTreeTableRowHeader header = new MacTreeTableRowHeader(table);
        header.setBackground(new Color(230, 230, 230));
        header.setBorder(new CustomizableLineBorder(false, false, false, true));
        MacTreeTableRowHeaderRenderer renderer = new MacTreeTableRowHeaderRenderer();
        renderer.setShowingSelection(false);
        renderer.setShowingFocus(false);
        header.setRowHeaderRenderer(Object.class, renderer);
        return header;
    }

    @Override
    public TreeTableHeader createTreeTableHeader(AbstractGanttChart gc2) {
        TreeTableHeader header = super.createTreeTableHeader(gc2);
        header.setBackground(Color.WHITE);
        header.setColumnHeaderRenderer(Object.class, new MacColumnHeaderRenderer());
        return header;
    }

    @Override
    public JComponent createTreeTableCorner(TreeTable table, String corner) {
        JPanel comp = null;
        if (corner.equals("UPPER_RIGHT_CORNER")) {
            comp = new CornerStone(table.getGanttChart());
            comp.setBorder(new CustomizableLineBorder(true, false, true, true));
        } else if (corner.equals("LOWER_RIGHT_CORNER")) {
            comp = new CornerStone(table.getGanttChart());
        } else if (corner.equals("LOWER_LEFT_CORNER")) {
            comp = new CornerStone(table.getGanttChart());
            comp.setBorder(new CustomizableLineBorder(false, false, false, true));
        } else if (corner.equals("UPPER_LEFT_CORNER")) {
            final JPanel control = new JPanel(){

                @Override
                protected void paintComponent(Graphics g2) {
                    super.paintComponent(g2);
                    MacComponentFactory.paintGlossyBackground(this, g2, this.getWidth(), this.getHeight());
                }
            };
            control.setBorder(new CustomizableLineBorder(true, false, true, true));
            final TreeTable fTable = table;
            control.addMouseListener(new MouseAdapter(){
                private Selector selector;

                @Override
                public void mouseClicked(MouseEvent e2) {
                    if (this.selector == null) {
                        ISelectorFactory sf = fTable.getGanttChart().getSelectorFactory();
                        this.selector = sf.createSelector(fTable.getGanttChart(), (JComponent)control, ISelectorFactory.SelectorID.COLUMNS);
                    }
                    this.selector.setVisible(!this.selector.isVisible());
                    this.selector.requestFocusInWindow();
                }
            });
            comp = control;
        }
        comp.setBackground(new Color(230, 230, 230));
        return comp;
    }

    @Override
    public Timeline createTimeline(AbstractGanttChart gc2) {
        Timeline timeline = new Timeline(gc2){

            @Override
            protected void paintComponent(Graphics g2) {
                super.paintComponent(g2);
                MacComponentFactory.paintGlossyBackground(this, g2, this.getWidth(), this.getHeight());
            }
        };
        return timeline;
    }

    public static void makeEmphasizedLabelsRecursively(Component comp) {
        if (comp instanceof JLabel) {
            MacComponentFactory.makeEmphasizedLabel((JLabel)comp);
        } else if (comp instanceof Container) {
            Container container = (Container)comp;
            for (Component child : container.getComponents()) {
                MacComponentFactory.makeEmphasizedLabelsRecursively(child);
            }
        }
    }

    public static JLabel createEmphasizedLabel(String text) {
        return MacComponentFactory.makeEmphasizedLabel(new JLabel(text));
    }

    public static JLabel makeEmphasizedLabel(JLabel label) {
        label.setUI(new EmphasizedLabelUI());
        return label;
    }

    public static JLabel makeEmphasizedLabel(JLabel label, Color focusedColor, Color unfocusedColor, Color emphasisColor) {
        label.setUI(new EmphasizedLabelUI(focusedColor, unfocusedColor, emphasisColor));
        return label;
    }

    @Override
    public LayerContainerScrollPane createLayerContainerScrollPane(LayerContainer lc2, LayerContainerRowHeader rowHeader, Timeline timeline, boolean primary) {
        LayerContainerScrollPane pane = super.createLayerContainerScrollPane(lc2, rowHeader, timeline, primary);
        pane.setBorder(BorderFactory.createEmptyBorder());
        return pane;
    }

    @Override
    public TreeTableScrollPane createTreeTableScrollPane(TreeTable table, TreeTableRowHeader rowHeader, TreeTableHeader header, boolean primary) {
        TreeTableScrollPane pane = super.createTreeTableScrollPane(table, rowHeader, header, primary);
        pane.setBorder(BorderFactory.createEmptyBorder());
        return pane;
    }

    @Override
    public JSplitPane createSplitPane() {
        JSplitPane pane = super.createSplitPane();
        pane.setContinuousLayout(true);
        pane.setBorder(BorderFactory.createEmptyBorder());
        if (pane.getUI() instanceof BasicSplitPaneUI) {
            ((BasicSplitPaneUI)pane.getUI()).getDivider().setBorder(new Border(){
                private Insets insets = new Insets(1, 1, 1, 1);

                @Override
                public Insets getBorderInsets(Component c2) {
                    return this.insets;
                }

                @Override
                public boolean isBorderOpaque() {
                    return false;
                }

                @Override
                public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
                    Graphics2D g2d = (Graphics2D)g2;
                    g2d.setPaint(new GradientPaint(x2, y2, Color.WHITE, x2 + width, x2, Color.LIGHT_GRAY));
                    g2d.fillRect(x2, y2, width, height);
                    g2d.setColor(Color.LIGHT_GRAY);
                    g2d.drawLine(x2, y2, x2, y2 + height);
                    g2d.drawLine(x2 + width - 1, y2, x2 + width - 1, y2 + height - 1);
                }
            });
        }
        return pane;
    }

    public static void paintGlossyBackground(Component comp, Graphics g2, int w2, int h2) {
        g2.drawImage(glossyImage, 0, 0, w2, h2, comp);
    }
}

