/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer.timeline;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.TimeSpan;
import com.dlsc.flexgantt.model.dateline.IDatelineModel;
import com.dlsc.flexgantt.model.gantt.IGanttChartModel;
import com.dlsc.flexgantt.model.gantt.ILayer;
import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.policy.IPolicyProvider;
import com.dlsc.flexgantt.policy.layer.ILinePolicy;
import com.dlsc.flexgantt.policy.layer.ISelectionPolicy;
import com.dlsc.flexgantt.swing.ObjectBounds;
import com.dlsc.flexgantt.swing.layer.AbstractLayer;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.system.DragLayer;
import com.dlsc.flexgantt.swing.layer.system.IEditModeController;
import com.dlsc.flexgantt.swing.layer.system.SpreadsheetLayer;
import com.dlsc.flexgantt.swing.layer.timeline.ITimelineObjectRenderer;
import com.dlsc.flexgantt.swing.layer.timeline.ITimelineObjectSelectionListener;
import com.dlsc.flexgantt.swing.layer.timeline.ITimelineObjectSelectionModel;
import com.dlsc.flexgantt.swing.layer.timeline.TimelineObjectSelectionEvent;
import com.dlsc.flexgantt.swing.timeline.Dateline;
import com.dlsc.flexgantt.swing.treetable.TreeTable;
import com.dlsc.flexgantt.swing.treetable.TreeTableNode;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;

public class TimelineObjectLayer
extends AbstractLayer
implements MouseListener,
MouseMotionListener,
ITimelineObjectSelectionListener {
    private static final Logger LOGGER = Logger.getLogger(TimelineObjectLayer.class.getName());
    private ObjectBounds activeBounds;
    private ILayer layer;
    private boolean debuggingObjectBounds;

    public TimelineObjectLayer(LayerContainer lc2, ILayer layer) {
        super(layer.getName(), lc2);
        this.layer = layer;
        lc2.getSelectionModel(layer).addTimelineObjectSelectionModelListener(this);
    }

    @Override
    public boolean isVisible() {
        if (this.layerContainer.getSystemLayer(SpreadsheetLayer.class).isVisible()) {
            return false;
        }
        return super.isVisible();
    }

    @Override
    public void tearDown() {
        super.tearDown();
        this.layerContainer.getSelectionModel(this.layer).removeTimelineObjectSelectionModelListener(this);
    }

    public ObjectBounds getObjectBounds(TimelineObjectPath path) {
        TreeTable treeTable = this.getTreeTable();
        if (treeTable.isTreePathExpanded(path)) {
            int row;
            IGanttChartModel model = this.getModel();
            Object timelineObject = path.getTimelineObject();
            ITimelineObjectRenderer renderer = this.layerContainer.getTimelineObjectRenderer(timelineObject.getClass());
            ITimeSpan entrySpan = model.getTimeSpan(timelineObject);
            if (!entrySpan.isUndefined() && (row = treeTable.getRowForPath(path)) != -1) {
                int rowHeight = treeTable.getRowHeight(row) - 1;
                TreeTableNode treeTableNode = treeTable.getTreeTableNodes().get(row);
                int y2 = treeTableNode.getY();
                TreeTableNode animatedNode = treeTable.getAnimationNode();
                if (animatedNode != null && row > animatedNode.getRow()) {
                    int offset = (int)((double)animatedNode.getTotalChildrenHeight() * (1.0 - treeTable.getAnimationPercentage()));
                    y2 -= offset;
                }
                int x1 = this.getTimeLocation(entrySpan.getStartTime());
                int x2 = this.getTimeLocation(entrySpan.getEndTime());
                Object node = path.getLastPathComponent();
                IPolicyProvider pp = this.getLayerPolicyProvider();
                ILinePolicy lp = pp.getPolicy(ILinePolicy.class);
                int lineCount = lp.getLineCount(node, model);
                int lineIndex = -1;
                if (lineCount > 1) {
                    lineIndex = lp.getLineIndex(node, model, timelineObject);
                }
                int lineY = y2;
                int lineHeight = rowHeight;
                if (lineIndex >= 0) {
                    lineHeight = lp.getLineHeight(node, model, lineIndex, rowHeight);
                    lineY = y2 + lp.getLineLocation(node, model, lineIndex, rowHeight);
                }
                renderer.getTimelineObjectRendererComponent(this, path, false, false, false, row);
                Insets insets = renderer.getTimelineObjectRendererInsets(x1, lineY, x2 - x1, lineHeight);
                return new ObjectBounds(path, model, x1 += insets.left, lineY += insets.top, Math.max(1, (x2 -= insets.right) - x1), lineHeight -= insets.top + insets.bottom, treeTableNode, this);
            }
        }
        return null;
    }

    public ObjectBounds getObjectBoundsAt(MouseEvent evt) {
        return this.getObjectBoundsAt(evt.getPoint());
    }

    public ObjectBounds getObjectBoundsAt(Point p2) {
        return this.getObjectBoundsAt(p2.x, p2.y);
    }

    public ObjectBounds getObjectBoundsAt(int x2, int y2) {
        return this.getObjectBoundsAt(x2, y2, 0);
    }

    public ObjectBounds getObjectBoundsAt(int x2, int y2, int proximity) {
        List<TreeTableNode> nodes;
        if (proximity < 0) {
            throw new IllegalArgumentException("proximity has to be larger than 0");
        }
        TreeTable table = this.getTreeTable();
        int row = table.getRowAt(y2);
        if (row != -1 && row < (nodes = table.getTreeTableNodes()).size()) {
            IDatelineModel datelineModel = this.ganttChart.getDatelineModel();
            int extra = this.layerContainer.getClippingExtra();
            long st = Math.max(0L, datelineModel.getTimeAt(x2 - extra));
            long et = datelineModel.getTimeAt(x2 + extra);
            TimeSpan span = new TimeSpan(st, et);
            TreeTableNode node = nodes.get(row);
            Object modelNode = node.getModelNode();
            IGanttChartModel model = this.getModel();
            Iterator iter = model.getTimelineObjectsIterator(modelNode, this.layer, span);
            ObjectBounds last = null;
            long lastTime = Long.MIN_VALUE;
            LayerContainer.RenderingDirection ro = this.layerContainer.getRenderingDirection();
            if (ro.equals((Object)LayerContainer.RenderingDirection.RIGHT_TO_LEFT)) {
                lastTime = Long.MAX_VALUE;
            }
            TreePath path = node.getPath();
            while (iter.hasNext()) {
                Object obj = iter.next();
                TimelineObjectPath top = new TimelineObjectPath(path, obj, this.layer);
                ObjectBounds bounds = this.getObjectBounds(top);
                Rectangle proximityRect = new Rectangle(bounds);
                if (proximity > 0) {
                    proximityRect.translate(-proximity, -proximity);
                    proximityRect.grow(2 * proximity, 2 * proximity);
                }
                if (!proximityRect.contains(x2, y2)) continue;
                long time = model.getTimeSpan(obj).getStartTime();
                if (ro.equals((Object)LayerContainer.RenderingDirection.LEFT_TO_RIGHT) && time >= lastTime) {
                    last = bounds;
                    lastTime = time;
                    continue;
                }
                if (!ro.equals((Object)LayerContainer.RenderingDirection.RIGHT_TO_LEFT) || time > lastTime) continue;
                last = bounds;
                lastTime = time;
            }
            return last;
        }
        return null;
    }

    public Collection<ObjectBounds> getAllObjectBoundsAt(int x2, int y2) {
        List<TreeTableNode> nodes;
        ArrayList<ObjectBounds> list = new ArrayList<ObjectBounds>();
        TreeTable table = this.getTreeTable();
        int row = table.getRowAt(y2);
        if (row != -1 && row < (nodes = table.getTreeTableNodes()).size()) {
            IDatelineModel datelineModel = this.ganttChart.getDatelineModel();
            ITimeSpan span = datelineModel.getTimeSpan();
            TreeTableNode node = nodes.get(row);
            Object modelNode = node.getModelNode();
            IGanttChartModel model = this.getModel();
            Iterator iter = model.getTimelineObjectsIterator(modelNode, this.layer, span);
            while (iter.hasNext()) {
                Object obj = iter.next();
                TreePath path = node.getPath();
                TimelineObjectPath top = new TimelineObjectPath(path, obj, this.layer);
                ObjectBounds bounds = this.getObjectBounds(top);
                if (!bounds.contains(x2, y2)) continue;
                list.add(this.getObjectBounds(top));
            }
        }
        return list;
    }

    @Override
    protected void paintLayer(Graphics g2) {
        super.paintLayer(g2);
        int startNode = this.layerContainer.getStartRow();
        if (startNode != -1) {
            Graphics2D g2d = (Graphics2D)g2;
            LayerContainer lc2 = this.getLayerContainer();
            TreeTable table = lc2.getTreeTable();
            List<TreeTableNode> treeTableNodes = table.getTreeTableNodes();
            if (treeTableNodes != null) {
                Dateline dateline = lc2.getDateline();
                ITimeSpan horizon = dateline.getTimeSpan();
                Rectangle clip = g2d.getClipBounds();
                int eventWidth = this.layerContainer.getClippingExtra();
                long st = Math.max(0L, this.getTimeAt(clip.x - eventWidth));
                long et = Math.max(0L, this.getTimeAt(clip.x + clip.width + eventWidth));
                ITimeSpan clipSpan = horizon.intersection(new TimeSpan(st, et));
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("g.getClipBounds() = " + g2d.getClipBounds());
                    LOGGER.finest("time span for clip = " + clipSpan);
                    LOGGER.finest("first visible node = " + startNode);
                }
                if (startNode < treeTableNodes.size()) {
                    IGanttChartModel model = lc2.getModel();
                    Composite composite = g2d.getComposite();
                    if (this.alpha < 1.0f) {
                        g2d.setComposite(AlphaComposite.getInstance(3, this.alpha));
                    }
                    IPolicyProvider pp = lc2.getPolicyProvider();
                    ILinePolicy lp = pp.getPolicy(ILinePolicy.class);
                    ITimelineObjectSelectionModel selectionModel = this.layerContainer.getSelectionModel(this.layer);
                    int y2 = treeTableNodes.get(startNode).getY();
                    int clipLine = 0;
                    for (int row = startNode; row < treeTableNodes.size(); ++row) {
                        TreeTableNode node = treeTableNodes.get(row);
                        TreePath path = node.getPath();
                        Object modelNode = node.getModelNode();
                        int rowHeight = node.getHeight();
                        int lineCount = lp.getLineCount(modelNode, model);
                        Iterator iter = model.getTimelineObjectsIterator(modelNode, this.layer, clipSpan);
                        g2d.clipRect(0, Math.max(clipLine, y2), this.getWidth(), this.getHeight());
                        Composite innerComp = g2d.getComposite();
                        TreeTableNode animatedNode = table.getAnimationNode();
                        if (animatedNode != null) {
                            int firstAnimRow = animatedNode.getRow();
                            int lastAnimRow = firstAnimRow + animatedNode.getTotalChildrenCount() - 1;
                            if (row > firstAnimRow && row <= lastAnimRow) {
                                g2d.setComposite(AlphaComposite.getInstance(3, (float)((double)this.alpha * table.getAnimationPercentage())));
                            }
                        }
                        while (iter.hasNext()) {
                            Object timelineObject = iter.next();
                            ITimeSpan timeSpan = model.getTimeSpan(timelineObject);
                            if (timeSpan.isUndefined() || !timeSpan.intersects(horizon) || !timeSpan.isEvent() && !clipSpan.intersects(timeSpan)) continue;
                            int lineIndex = -1;
                            if (lineCount > 1) {
                                lineIndex = lp.getLineIndex(modelNode, model, timelineObject);
                            }
                            int lineY = y2;
                            int lineHeight = rowHeight - 1;
                            if (lineIndex >= 0) {
                                lineHeight = lp.getLineHeight(modelNode, model, lineIndex, rowHeight);
                                lineY = y2 + lp.getLineLocation(modelNode, model, lineIndex, rowHeight);
                            }
                            ITimelineObjectRenderer renderer = this.layerContainer.getTimelineObjectRenderer(timelineObject.getClass());
                            int x1 = dateline.getTimeLocation(timeSpan.getStartTime());
                            int x2 = dateline.getTimeLocation(timeSpan.getEndTime());
                            TimelineObjectPath tlop = new TimelineObjectPath(path, timelineObject, this.layer);
                            boolean selected = selectionModel.isSelected(tlop);
                            boolean hasFocus = this.activeBounds != null && this.activeBounds.getPath().equals(tlop);
                            boolean highlight = this.layerContainer.isHighlighting() && this.layerContainer.isHighlighted(tlop);
                            Component rendererComponent = renderer.getTimelineObjectRendererComponent(this, tlop, selected, hasFocus, highlight, row);
                            Insets insets = renderer.getTimelineObjectRendererInsets(x1, lineY, x2 - x1, lineHeight);
                            int yy = Math.min(y2 + rowHeight - 1, lineY + insets.top);
                            int height = Math.max(1, lineHeight - insets.top - insets.bottom);
                            this.layerContainer.getRendererPane().paintComponent(g2d, rendererComponent, this.layerContainer, x1 += insets.left, yy, Math.max(1, (x2 -= insets.right) - x1), height, true);
                            if (!this.debuggingObjectBounds) continue;
                            g2.setColor(Color.RED);
                            g2.drawRect(x1, yy, Math.max(1, x2 - x1), height);
                        }
                        g2d.setComposite(innerComp);
                        g2d.setClip(clip);
                        if ((y2 += rowHeight) > clip.y + clip.height) break;
                        if (node != table.getAnimationNode()) continue;
                        clipLine = y2;
                        y2 -= (int)((double)node.getTotalChildrenHeight() * (1.0 - table.getAnimationPercentage()));
                    }
                    g2d.setComposite(composite);
                }
            }
        }
    }

    @Override
    public ITimeSpan getTimeSpanUsed() {
        IGanttChartModel model = this.getModel();
        ITimeSpan span = this.getDateline().getTimeSpan();
        List<TreeTableNode> nodes = this.getTreeTable().getTreeTableNodes();
        ITimeSpan result = TimeSpan.UNDEFINED;
        for (TreeTableNode node : nodes) {
            Object data = node.getModelNode();
            Iterator iter = model.getTimelineObjectsIterator(data, this.layer, span);
            while (iter.hasNext()) {
                Object timelineObject = iter.next();
                ITimeSpan objSpan = model.getTimeSpan(timelineObject);
                result = result.union(objSpan);
            }
        }
        return result;
    }

    @Override
    public void mouseMoved(MouseEvent e2) {
        if (this.isVisible() && !e2.isConsumed()) {
            ObjectBounds previousBounds = this.activeBounds;
            this.activeBounds = this.getObjectBoundsAt(e2);
            if (this.activeBounds == null && previousBounds != null || this.activeBounds != null && !this.activeBounds.equals(previousBounds)) {
                if (this.activeBounds != null) {
                    this.repaint(this.activeBounds);
                }
                if (previousBounds != null) {
                    this.repaint(previousBounds);
                }
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e2) {
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
    }

    @Override
    public void mouseExited(MouseEvent e2) {
        if (this.isVisible()) {
            this.activeBounds = null;
            this.repaint();
        }
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        if (this.isVisible() && !this.layerContainer.isPopupShowing() && !e2.isConsumed() && SwingUtilities.isLeftMouseButton(e2) && e2.getClickCount() == 1 && !e2.isAltDown()) {
            this.performSelection(e2);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
    }

    private void performSelection(MouseEvent e2) {
        DragLayer dl;
        if (!this.layerContainer.isIgnoringTreeTableSelection()) {
            this.getTreeTable().clearSelection();
        }
        if ((dl = this.layerContainer.getSystemLayer(DragLayer.class)).getEditMode().equals((Object)IEditModeController.EditMode.CHANGE_PERCENTAGE_COMPLETE)) {
            return;
        }
        ObjectBounds bounds = this.getObjectBoundsAt(e2);
        ITimelineObjectSelectionModel selectionModel = this.layerContainer.getSelectionModel(this.layer);
        if (bounds != null) {
            TimelineObjectPath path;
            IGanttChartModel model = this.getModel();
            ISelectionPolicy sp = this.getLayerPolicyProvider().getPolicy(ISelectionPolicy.class);
            if (sp.isSelectable(path = bounds.getPath(), model)) {
                boolean selected = selectionModel.isSelected(bounds.getPath());
                int mask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
                if (!selected) {
                    if (!e2.isShiftDown() && (e2.getModifiers() & mask) == 0) {
                        this.layerContainer.clearTimelineObjectSelection();
                    }
                    selectionModel.addSelection(path);
                } else if (e2.isShiftDown() || (e2.getModifiers() & mask) != 0) {
                    selectionModel.removeSelection(path);
                }
            }
            e2.consume();
        }
    }

    @Override
    public void valueChanged(TimelineObjectSelectionEvent evt) {
        this.repaint();
    }

    public ILayer getLayer() {
        return this.layer;
    }

    public boolean isDebuggingObjectBounds() {
        return this.debuggingObjectBounds;
    }

    public void setDebuggingObjectBounds(boolean debug) {
        this.debuggingObjectBounds = debug;
    }
}

