/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer.timeline;

import com.dlsc.flexgantt.icons.IconId;
import com.dlsc.flexgantt.icons.IconRegistry;
import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.swing.layer.system.EditingLayer;
import com.dlsc.flexgantt.swing.layer.timeline.ITimelineObjectEditor;
import com.dlsc.flexgantt.swing.layer.timeline.ITimelineObjectEditorListener;
import com.dlsc.flexgantt.swing.util.DropShadowBorder;
import com.dlsc.flexgantt.util.Messages;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;

public abstract class AbstractTimelineObjectEditor
extends JPanel
implements ITimelineObjectEditor,
MouseListener,
MouseMotionListener {
    private DragMode dragMode = DragMode.NONE;
    private TimelineObjectPath timelineObjectPath;
    private JComponent content;
    private JPanel buttonBar;
    private Point dragStart;
    private String title;
    private JLabel titleLabel = new JLabel();
    private JLabel closeLabel = new JLabel();
    private JLabel packLabel = new JLabel();

    protected AbstractTimelineObjectEditor(String title, JComponent content) {
        if (content == null) {
            throw new IllegalArgumentException("content can not be NULL");
        }
        this.content = content;
        this.content.setBorder(new CompoundBorder(new EmptyBorder(7, 7, 7, 7), content.getBorder()));
        this.setTitle(title);
        this.setBorder(new CompoundBorder(new DropShadowBorder(Color.BLACK, 10), new LineBorder(Color.BLACK, 1)));
        this.setLayout(new BorderLayout(0, 0));
        this.setOpaque(false);
        this.setCursor(Cursor.getPredefinedCursor(0));
        JComponent header = this.createHeader();
        this.add("North", header);
        this.add("Center", content);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
            }
        });
        this.buttonBar = this.createButtonBar();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    protected AbstractTimelineObjectEditor(JComponent content) {
        this(Messages.getString("AbstractTimelineObjectEditor.TITLE"), content);
    }

    @Override
    protected void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        Insets insets = this.getInsets();
        Graphics2D g2d = (Graphics2D)g2.create();
        g2d.setColor(this.getBackground());
        g2d.setComposite(AlphaComposite.getInstance(3, 0.85f));
        g2d.fillRect(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
        g2d.dispose();
    }

    protected JPanel createButtonBar() {
        JPanel bar = new JPanel(){

            @Override
            protected void paintComponent(Graphics g2) {
                super.paintComponent(g2);
                g2.setColor(this.getForeground());
                g2.drawLine(2, 0, this.getWidth() - 3, 0);
            }
        };
        bar.setOpaque(false);
        bar.setLayout(new FlowLayout(2, 5, 5));
        JButton ok = new JButton(Messages.getString("AbstractTimelineObjectEditor.OK_BUTTON"));
        ok.setOpaque(false);
        bar.add(ok);
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                AbstractTimelineObjectEditor.this.stopEditing();
            }
        });
        JButton cancel = new JButton(Messages.getString("AbstractTimelineObjectEditor.CANCEL_BUTTON"));
        cancel.setOpaque(false);
        bar.add(cancel);
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                AbstractTimelineObjectEditor.this.cancelEditing();
            }
        });
        JPanel wrapper = new JPanel();
        wrapper.setBorder(new EmptyBorder(0, 5, 0, 5));
        wrapper.setLayout(new BorderLayout());
        wrapper.add("South", bar);
        wrapper.setOpaque(false);
        this.add("South", wrapper);
        return bar;
    }

    protected JComponent createHeader() {
        this.titleLabel.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.titleLabel.setHorizontalAlignment(0);
        this.titleLabel.setBackground(Color.BLACK);
        this.titleLabel.setForeground(Color.WHITE);
        this.titleLabel.setOpaque(true);
        this.titleLabel.addMouseListener(this);
        this.titleLabel.addMouseMotionListener(this);
        this.titleLabel.setCursor(Cursor.getPredefinedCursor(13));
        this.closeLabel.setIcon(IconRegistry.getIcon(IconId.TIMELINE_OBJECT_EDITOR_CLOSE));
        this.closeLabel.setOpaque(true);
        this.closeLabel.setBackground(Color.BLACK);
        this.closeLabel.setForeground(Color.WHITE);
        this.closeLabel.setVerticalAlignment(0);
        this.closeLabel.setBorder(new EmptyBorder(2, 2, 2, 5));
        this.closeLabel.setToolTipText(Messages.getString("AbstractTimelineObjectEditor.TTT_CLOSE_EDITOR"));
        this.closeLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                AbstractTimelineObjectEditor.this.cancelEditing();
            }
        });
        this.packLabel.setIcon(IconRegistry.getIcon(IconId.TIMELINE_OBJECT_EDITOR_PACK));
        this.packLabel.setOpaque(true);
        this.packLabel.setBackground(Color.BLACK);
        this.packLabel.setForeground(Color.WHITE);
        this.packLabel.setVerticalAlignment(0);
        this.packLabel.setBorder(new EmptyBorder(2, 5, 2, 2));
        this.packLabel.setToolTipText(Messages.getString("AbstractTimelineObjectEditor.TTT_APPLY_MINIMUM_SIZE"));
        this.packLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                Rectangle bounds = AbstractTimelineObjectEditor.this.getBounds();
                Dimension ps = AbstractTimelineObjectEditor.this.getMinimumSize();
                AbstractTimelineObjectEditor.this.setBounds(bounds.x, bounds.y, ps.width, ps.height);
                AbstractTimelineObjectEditor.this.setPreferredSize(ps);
                AbstractTimelineObjectEditor.this.revalidate();
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add("West", this.packLabel);
        panel.add("Center", this.titleLabel);
        panel.add("East", this.closeLabel);
        return panel;
    }

    @Override
    public Component getTimelineObjectEditorComponent(EditingLayer layer, TimelineObjectPath path) {
        this.timelineObjectPath = path;
        return this;
    }

    @Override
    public void addTimelineObjectEditorListener(ITimelineObjectEditorListener l2) {
        this.listenerList.add(ITimelineObjectEditorListener.class, l2);
    }

    @Override
    public void removeTimelineObjectEditorListener(ITimelineObjectEditorListener l2) {
        this.listenerList.remove(ITimelineObjectEditorListener.class, l2);
    }

    protected void fireEditingStopped() {
        Object[] listeners = this.listenerList.getListenerList();
        ChangeEvent evt = null;
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != ITimelineObjectEditorListener.class) continue;
            if (evt == null) {
                evt = new ChangeEvent(this);
            }
            ((ITimelineObjectEditorListener)listeners[i2 + 1]).editingStopped(evt);
        }
    }

    protected void fireEditingCanceled() {
        Object[] listeners = this.listenerList.getListenerList();
        ChangeEvent evt = null;
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != ITimelineObjectEditorListener.class) continue;
            if (evt == null) {
                evt = new ChangeEvent(this);
            }
            ((ITimelineObjectEditorListener)listeners[i2 + 1]).editingCanceled(evt);
        }
    }

    @Override
    public abstract void cancelEditing();

    @Override
    public abstract boolean stopEditing();

    public Object getTimelineObject() {
        if (this.timelineObjectPath != null) {
            return this.timelineObjectPath.getTimelineObject();
        }
        return null;
    }

    public Object getTimelineObjectPath() {
        return this.timelineObjectPath;
    }

    public JComponent getContent() {
        return this.content;
    }

    public JPanel getButtonBar() {
        return this.buttonBar;
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
    }

    @Override
    public void mouseExited(MouseEvent e2) {
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        if (this.isResizeLocation(e2)) {
            this.dragMode = DragMode.RESIZING;
        } else if (e2.getSource().equals(this.titleLabel)) {
            this.dragMode = DragMode.MOVE;
        }
        this.dragStart = e2.getPoint();
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
        this.dragMode = DragMode.NONE;
    }

    @Override
    public void mouseDragged(MouseEvent e2) {
        Point p2 = e2.getPoint();
        int dx = p2.x - this.dragStart.x;
        int dy = p2.y - this.dragStart.y;
        switch (this.dragMode) {
            case MOVE: {
                Point loc = this.getLocation();
                loc.translate(dx, dy);
                this.setLocation(loc);
                break;
            }
            case RESIZING: {
                Dimension min = this.getMinimumSize();
                this.setBounds(this.getX(), this.getY(), Math.max(min.width, this.getWidth()) + dx, Math.max(min.height, this.getHeight() + dy));
                this.setPreferredSize(new Dimension(this.getWidth(), this.getHeight()));
                this.revalidate();
                this.dragStart = p2;
                break;
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e2) {
        if (this.isResizeLocation(e2)) {
            this.setCursor(Cursor.getPredefinedCursor(5));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private boolean isResizeLocation(MouseEvent e2) {
        Insets insets = this.getInsets();
        int w2 = this.getWidth() - insets.left - insets.right;
        int h2 = this.getHeight() - insets.top - insets.right;
        return e2.getX() > w2 - 5 && e2.getY() > h2 - 5;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.titleLabel.setText(title);
    }

    public JLabel getTitleLabel() {
        return this.titleLabel;
    }

    public JLabel getCloseLabel() {
        return this.closeLabel;
    }

    public JLabel getPackLabel() {
        return this.packLabel;
    }

    private static enum DragMode {
        RESIZING,
        MOVE,
        NONE;

    }
}

