/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing;

import com.dlsc.flexgantt.model.bookmarks.BookmarkEvent;
import com.dlsc.flexgantt.model.bookmarks.IBookmarkModel;
import com.dlsc.flexgantt.model.bookmarks.IBookmarkModelListener;
import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.GanttChartControl;
import com.dlsc.flexgantt.swing.NavigationControl;
import com.dlsc.flexgantt.swing.NavigationControlType;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EnumMap;

public class NavigationControlPanel
extends GanttChartControl
implements IBookmarkModelListener,
LayoutManager {
    private EnumMap<NavigationControlType, NavigationControl> controlMap;
    private boolean centeringTimeNow = true;
    private LayerContainer layerContainer;
    private AbstractGanttChart ganttChart;

    public NavigationControlPanel(LayerContainer lc2) {
        super(lc2.getGanttChart());
        this.setLayout(this);
        this.layerContainer = lc2;
        this.ganttChart = lc2.getGanttChart();
        this.controlMap = new EnumMap(NavigationControlType.class);
        this.controlMap.put(NavigationControlType.ALL_OBJECTS, new NavigationControl(this, NavigationControlType.ALL_OBJECTS));
        this.controlMap.put(NavigationControlType.BOOKMARKS, new NavigationControl(this, NavigationControlType.BOOKMARKS));
        this.controlMap.put(NavigationControlType.EARLIEST_OBJECT, new NavigationControl(this, NavigationControlType.EARLIEST_OBJECT));
        this.controlMap.put(NavigationControlType.LATEST_OBJECT, new NavigationControl(this, NavigationControlType.LATEST_OBJECT));
        if (lc2.isPrimary()) {
            this.controlMap.put(NavigationControlType.GRANULARITY, new NavigationControl(this, NavigationControlType.GRANULARITY));
            this.controlMap.put(NavigationControlType.TIME_SPAN, new NavigationControl(this, NavigationControlType.TIME_SPAN));
            this.controlMap.put(NavigationControlType.ZOOM_IN, new NavigationControl(this, NavigationControlType.ZOOM_IN));
            this.controlMap.put(NavigationControlType.ZOOM_OUT, new NavigationControl(this, NavigationControlType.ZOOM_OUT));
            this.controlMap.put(NavigationControlType.TIME_NOW, new NavigationControl(this, NavigationControlType.TIME_NOW));
            this.controlMap.put(NavigationControlType.GOTO, new NavigationControl(this, NavigationControlType.GOTO));
        }
        this.setName("NavigationControlPanel");
        if (lc2.isPrimary()) {
            this.add(this.controlMap.get((Object)NavigationControlType.ZOOM_IN));
            this.add(this.controlMap.get((Object)NavigationControlType.ZOOM_OUT));
            this.add(this.controlMap.get((Object)NavigationControlType.GRANULARITY));
            this.add(this.controlMap.get((Object)NavigationControlType.TIME_SPAN));
            this.add(this.controlMap.get((Object)NavigationControlType.TIME_NOW));
            this.add(this.controlMap.get((Object)NavigationControlType.GOTO));
        }
        this.add(this.controlMap.get((Object)NavigationControlType.ALL_OBJECTS));
        this.add(this.controlMap.get((Object)NavigationControlType.EARLIEST_OBJECT));
        this.add(this.controlMap.get((Object)NavigationControlType.LATEST_OBJECT));
        this.add(this.controlMap.get((Object)NavigationControlType.BOOKMARKS));
        IBookmarkModel model = this.layerContainer.getBookmarkModel();
        model.addBookmarkModelListener(this);
        this.updateBookmarksButton();
        for (NavigationControl control : this.controlMap.values()) {
            control.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("visible")) {
                        NavigationControlPanel.this.invalidate();
                        NavigationControlPanel.this.validate();
                    }
                }
            });
        }
    }

    @Override
    public void bookmarksChanged(BookmarkEvent evt) {
        this.updateBookmarksButton();
    }

    private void updateBookmarksButton() {
        IBookmarkModel model = this.layerContainer.getBookmarkModel();
        int count = model.getBookmarkCount();
        if (count > 0) {
            this.controlMap.get((Object)NavigationControlType.BOOKMARKS).setEnabled(true);
        } else {
            this.controlMap.get((Object)NavigationControlType.BOOKMARKS).setEnabled(false);
        }
    }

    public boolean isCenterTimeNow() {
        return this.centeringTimeNow;
    }

    public void setCenterTimeNow(boolean center) {
        this.centeringTimeNow = center;
    }

    public NavigationControl getNavigationControl(NavigationControlType type) {
        return this.controlMap.get((Object)type);
    }

    public LayerContainer getLayerContainer() {
        return this.layerContainer;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if (evt.getSource().equals(this.layerContainer)) {
            if (evt.getPropertyName().equals("bookmarkModel")) {
                IBookmarkModel oldModel = (IBookmarkModel)evt.getOldValue();
                IBookmarkModel newModel = (IBookmarkModel)evt.getNewValue();
                oldModel.removeBookmarkModelListener(this);
                newModel.addBookmarkModelListener(this);
                this.updateBookmarksButton();
            }
        } else if (evt.getSource().equals(this.ganttChart) && evt.getPropertyName().equals("activeSpreadsheet")) {
            this.setSpreadsheetVisible(evt.getNewValue() != null);
        }
    }

    public void setSpreadsheetVisible(boolean visible) {
        this.getNavigationControl(NavigationControlType.ZOOM_IN).setEnabled(!visible);
        this.getNavigationControl(NavigationControlType.ZOOM_OUT).setEnabled(!visible);
        this.getNavigationControl(NavigationControlType.ALL_OBJECTS).setEnabled(!visible);
        this.getNavigationControl(NavigationControlType.BOOKMARKS).setEnabled(!visible);
        this.getNavigationControl(NavigationControlType.EARLIEST_OBJECT).setEnabled(!visible);
        this.getNavigationControl(NavigationControlType.LATEST_OBJECT).setEnabled(!visible);
        this.getNavigationControl(NavigationControlType.GRANULARITY).setEnabled(!visible);
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        int x2 = insets.left;
        int y2 = insets.top;
        int w2 = parent.getWidth() - insets.left - insets.right;
        for (Component comp : this.getComponents()) {
            if (!comp.isVisible()) continue;
            Dimension dim = comp.getPreferredSize();
            comp.setBounds(x2, y2, w2, dim.height);
            y2 += dim.height;
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        int width = 0;
        int height = 0;
        for (Component comp : this.getComponents()) {
            if (!comp.isVisible()) continue;
            Dimension ps = comp.getPreferredSize();
            height += ps.height;
            width = Math.max(width, ps.height);
        }
        Dimension dim = new Dimension(width, height);
        Insets insets = parent.getInsets();
        dim.width += insets.left + insets.right;
        dim.height += insets.top + insets.bottom;
        return dim;
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }
}

