/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing;

import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.IMultiGanttChartContainer;
import com.dlsc.flexgantt.swing.IMultiGanttChartContainerListener;
import com.dlsc.flexgantt.swing.MultiGanttChartContainerEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MultiGanttChartContainer<T extends AbstractGanttChart>
extends JPanel
implements IMultiGanttChartContainer<T>,
ChangeListener {
    private JTabbedPane tabbedPane;

    public MultiGanttChartContainer() {
        this.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setTabLayoutPolicy(1);
        this.tabbedPane.addChangeListener(this);
        this.tabbedPane.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e2) {
                Object gc2 = MultiGanttChartContainer.this.getSelectedGanttChart();
                if (gc2 != null) {
                    ((JComponent)gc2).requestFocusInWindow();
                }
            }
        });
        this.add("Center", this.tabbedPane);
    }

    @Override
    public T getGanttChart(int index) {
        return (T)((AbstractGanttChart)this.tabbedPane.getComponent(index));
    }

    @Override
    public int getGanttChartCount() {
        return this.tabbedPane.getTabCount();
    }

    @Override
    public T getSelectedGanttChart() {
        return (T)((AbstractGanttChart)this.tabbedPane.getSelectedComponent());
    }

    public void addGanttChart(String title, T gc2) {
        this.addGanttChart(title, null, gc2, null);
    }

    public void addGanttChart(String title, Icon icon, T gc2) {
        this.addGanttChart(title, icon, gc2, null);
    }

    public void addGanttChart(String title, Icon icon, T gc2, String tip) {
        this.tabbedPane.addTab(title, icon, (Component)gc2, tip);
        MultiGanttChartContainerEvent evt = new MultiGanttChartContainerEvent(this, MultiGanttChartContainerEvent.ID.GANTT_CHART_ADDED, (AbstractGanttChart)gc2);
        this.fireContainerChanged(evt);
    }

    public void setSelectedGanttChart(int index) {
        this.tabbedPane.setSelectedIndex(index);
    }

    public void setSelectedGanttChart(T gc2) {
        this.tabbedPane.setSelectedComponent((Component)gc2);
        ((JComponent)gc2).requestFocusInWindow();
    }

    @Override
    public int getGanttChartIndex(T gc2) {
        return this.tabbedPane.indexOfComponent((Component)gc2);
    }

    public void insertGanttChart(String title, T gc2, int index) {
        this.insertGanttChart(title, null, gc2, null, index);
    }

    public void insertGanttChart(String title, Icon icon, T gc2, int index) {
        this.insertGanttChart(title, icon, gc2, null, index);
    }

    public void insertGanttChart(String title, Icon icon, T gc2, String tip, int index) {
        this.tabbedPane.insertTab(title, icon, (Component)gc2, tip, index);
        MultiGanttChartContainerEvent evt = new MultiGanttChartContainerEvent(this, MultiGanttChartContainerEvent.ID.GANTT_CHART_INSERTED, (AbstractGanttChart)gc2);
        this.fireContainerChanged(evt);
    }

    public void removeGanttChart(T gc2) {
        this.tabbedPane.remove((Component)gc2);
        MultiGanttChartContainerEvent evt = new MultiGanttChartContainerEvent(this, MultiGanttChartContainerEvent.ID.GANTT_CHART_REMOVED, (AbstractGanttChart)gc2);
        this.fireContainerChanged(evt);
    }

    public void removeGanttChart(int index) {
        T gc2 = this.getGanttChart(index);
        this.removeGanttChart(gc2);
    }

    public void removeAllGanttCharts() {
        int count;
        for (int i2 = count = this.getGanttChartCount(); i2 >= 0; --i2) {
            this.removeGanttChart(i2);
        }
    }

    @Override
    public void addMultiGanttChartContainerListener(IMultiGanttChartContainerListener l2) {
        this.listenerList.add(IMultiGanttChartContainerListener.class, l2);
    }

    @Override
    public void removeMultiGanttChartContainerListener(IMultiGanttChartContainerListener l2) {
        this.listenerList.remove(IMultiGanttChartContainerListener.class, l2);
    }

    protected void fireContainerChanged(MultiGanttChartContainerEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != IMultiGanttChartContainerListener.class) continue;
            ((IMultiGanttChartContainerListener)listeners[i2 + 1]).containerChanged(evt);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e2) {
        T gc2 = this.getSelectedGanttChart();
        ((JComponent)gc2).requestFocusInWindow();
        MultiGanttChartContainerEvent evt = new MultiGanttChartContainerEvent(this, MultiGanttChartContainerEvent.ID.GANTT_CHART_CHANGED, (AbstractGanttChart)gc2);
        this.fireContainerChanged(evt);
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }
}

