/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.showcase.util.scanner;

import com.dlsc.flexgantt.showcase.util.scanner.Scanner;
import com.dlsc.flexgantt.showcase.util.scanner.Token;
import com.dlsc.flexgantt.showcase.util.scanner.TokenTypes;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.io.IOException;
import java.io.Reader;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Segment;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class SyntaxHighlighter
extends JTextPane
implements DocumentListener,
TokenTypes {
    private StyledDocument doc;
    private Scanner scanner;
    private int height;
    private int width;
    Style[] styles;
    Segment text = new Segment();
    int firstRehighlightToken;
    int smallAmount = 100;

    public SyntaxHighlighter(int height, int width, Scanner scanner) {
        super(new DefaultStyledDocument());
        this.doc = (StyledDocument)this.getDocument();
        this.height = height;
        this.width = width;
        this.scanner = scanner;
        this.doc.addDocumentListener(this);
        Font font = new Font("Monospaced", 0, this.getFont().getSize());
        this.changeFont(font);
        this.initStyles();
    }

    public void changeFont(Font font) {
        int borderOfJTextPane = 3;
        this.setFont(font);
        FontMetrics metrics = this.getFontMetrics(font);
        int paneWidth = this.width * metrics.charWidth('m') + 2 * borderOfJTextPane;
        int paneHeight = this.height * metrics.getHeight() + 2 * borderOfJTextPane;
        Dimension size = new Dimension(paneWidth, paneHeight);
        this.setMinimumSize(size);
        this.setPreferredSize(size);
        this.invalidate();
    }

    @Override
    public void read(Reader in, Object desc) throws IOException {
        int oldLength = this.getDocument().getLength();
        this.doc.removeDocumentListener(this);
        super.read(in, desc);
        this.doc = (StyledDocument)this.getDocument();
        this.doc.addDocumentListener(this);
        int newLength = this.getDocument().getLength();
        this.firstRehighlightToken = this.scanner.change(0, oldLength, newLength);
        this.repaint();
    }

    private void initStyles() {
        this.styles = new Style[typeNames.length];
        this.changeStyle(0, Color.red);
        this.changeStyle(1, Color.black);
        this.changeStyle(2, Color.black);
        this.changeStyle(3, Color.orange.darker());
        this.changeStyle(4, Color.orange.darker());
        this.changeStyle(5, Color.green.darker());
        this.changeStyle(6, Color.green.darker());
        this.changeStyle(7, Color.green.darker());
        this.changeStyle(8, Color.green.darker());
        this.changeStyle(9, Color.blue, 1);
        this.changeStyle(10, Color.blue, 1);
        this.changeStyle(11, Color.blue);
        this.changeStyle(12, Color.blue);
        this.changeStyle(13, Color.black);
        this.changeStyle(14, Color.magenta);
        this.changeStyle(15, Color.magenta);
        this.changeStyle(16, Color.magenta);
        this.changeStyle(17, Color.black, 1);
        this.changeStyle(18, Color.orange.darker());
        this.changeStyle(19, Color.orange.darker());
        this.changeStyle(20, Color.blue.darker());
        for (int i2 = 0; i2 < this.styles.length; ++i2) {
            if (this.styles[i2] != null) continue;
            this.styles[i2] = this.styles[1];
        }
    }

    public void changeStyle(int type, Color color) {
        Style style = this.addStyle(typeNames[type], null);
        StyleConstants.setForeground(style, color);
        this.styles[type] = style;
    }

    public void changeStyle(int type, Color color, int fontStyle) {
        Style style = this.addStyle(typeNames[type], null);
        StyleConstants.setForeground(style, color);
        if ((fontStyle & 1) != 0) {
            StyleConstants.setBold(style, true);
        }
        if ((fontStyle & 2) != 0) {
            StyleConstants.setItalic(style, true);
        }
        this.styles[type] = style;
    }

    @Override
    public void insertUpdate(DocumentEvent e2) {
        int offset = e2.getOffset();
        int length = e2.getLength();
        this.firstRehighlightToken = this.scanner.change(offset, 0, length);
        this.repaint();
    }

    @Override
    public void removeUpdate(DocumentEvent e2) {
        int offset = e2.getOffset();
        int length = e2.getLength();
        this.firstRehighlightToken = this.scanner.change(offset, length, 0);
        this.repaint();
    }

    @Override
    public void changedUpdate(DocumentEvent e2) {
    }

    @Override
    protected void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        int offset = this.scanner.position();
        if (offset < 0) {
            return;
        }
        int tokensToRedo = 0;
        int amount = this.smallAmount;
        while (tokensToRedo == 0 && offset >= 0) {
            int length = this.doc.getLength() - offset;
            if (length > amount) {
                length = amount;
            }
            try {
                this.doc.getText(offset, length, this.text);
            }
            catch (BadLocationException e2) {
                return;
            }
            tokensToRedo = this.scanner.scan(this.text.array, this.text.offset, this.text.count);
            offset = this.scanner.position();
            amount = 2 * amount;
        }
        for (int i2 = 0; i2 < tokensToRedo; ++i2) {
            Token t2 = this.scanner.getToken(this.firstRehighlightToken + i2);
            int length = t2.symbol.name.length();
            int type = t2.symbol.type;
            if (type < 0) {
                type = 0;
            }
            this.doc.setCharacterAttributes(t2.position, length, this.styles[type], false);
        }
        this.firstRehighlightToken += tokensToRedo;
        if (offset >= 0) {
            this.repaint(2L);
        }
    }
}

