/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.showcase.util;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.TimeSpan;
import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.border.EmptyBorder;

public class TimeSpanDialog
extends JDialog {
    protected JSpinner startTimeSpinner;
    protected JSpinner endTimeSpinner;
    protected SpinnerDateModel startTimeModel;
    protected SpinnerDateModel endTimeModel;
    protected JButton okButton;
    protected JButton cancelButton;
    private ITimeSpan result;

    public TimeSpanDialog() throws HeadlessException {
        this.init();
    }

    public TimeSpanDialog(Frame owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    public TimeSpanDialog(Dialog owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    public TimeSpanDialog(Frame owner, boolean modal) throws HeadlessException {
        super(owner, modal);
        this.init();
    }

    public TimeSpanDialog(Frame owner, String title) throws HeadlessException {
        super(owner, title);
        this.init();
    }

    public TimeSpanDialog(Dialog owner, boolean modal) throws HeadlessException {
        super(owner, modal);
        this.init();
    }

    public TimeSpanDialog(Dialog owner, String title) throws HeadlessException {
        super(owner, title);
        this.init();
    }

    public TimeSpanDialog(Frame owner, String title, boolean modal) throws HeadlessException {
        super(owner, title, modal);
        this.init();
    }

    public TimeSpanDialog(Dialog owner, String title, boolean modal) throws HeadlessException {
        super(owner, title, modal);
        this.init();
    }

    public TimeSpanDialog(Frame owner, String title, boolean modal, GraphicsConfiguration gc2) {
        super(owner, title, modal, gc2);
        this.init();
    }

    public TimeSpanDialog(Dialog owner, String title, boolean modal, GraphicsConfiguration gc2) throws HeadlessException {
        super(owner, title, modal, gc2);
        this.init();
    }

    public void setTimeSpan(ITimeSpan span) {
        this.startTimeModel.setValue(new Date(span.getStartTime()));
        this.endTimeModel.setValue(new Date(span.getEndTime()));
    }

    private void init() {
        this.setDefaultCloseOperation(1);
        this.setLayout(new BorderLayout());
        this.add("North", this.createContent());
        this.add("South", this.createButtonBar());
        this.setModal(true);
        this.pack();
    }

    protected JPanel createContent() {
        this.startTimeModel = new SpinnerDateModel();
        this.endTimeModel = new SpinnerDateModel();
        this.startTimeSpinner = new JSpinner(this.startTimeModel);
        this.endTimeSpinner = new JSpinner(this.endTimeModel);
        JLabel startLabel = new JLabel("Start time:");
        JLabel endLabel = new JLabel("End time:");
        startLabel.setHorizontalTextPosition(4);
        endLabel.setHorizontalTextPosition(4);
        JPanel panel = new JPanel();
        panel.setBorder(new EmptyBorder(20, 20, 20, 20));
        panel.setLayout(new GridLayout(2, 2));
        panel.add(startLabel);
        panel.add(this.startTimeSpinner);
        panel.add(endLabel);
        panel.add(this.endTimeSpinner);
        return panel;
    }

    protected JPanel createButtonBar() {
        JPanel panel = new JPanel();
        panel.setBorder(new EmptyBorder(20, 20, 20, 20));
        panel.setLayout(new FlowLayout(2));
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TimeSpanDialog.this.result = new TimeSpan(TimeSpanDialog.this.startTimeModel.getDate(), TimeSpanDialog.this.endTimeModel.getDate());
                TimeSpanDialog.this.setVisible(false);
            }
        });
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TimeSpanDialog.this.result = null;
                TimeSpanDialog.this.setVisible(false);
            }
        });
        panel.add(this.cancelButton);
        panel.add(this.okButton);
        return panel;
    }

    public ITimeSpan open() {
        this.setVisible(true);
        return this.result;
    }
}

