/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.showcase.demo.resources;

import com.dlsc.flexgantt.showcase.demo.resources.Resource;
import com.dlsc.flexgantt.swing.treetable.ITreeTableCellRenderer;
import com.dlsc.flexgantt.swing.treetable.TreeTable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class ResourceTreeTableCellRenderer
extends JPanel
implements ITreeTableCellRenderer {
    private JLabel iconLabel = new JLabel("");
    private JLabel locationLabel = new JLabel("Test");
    private JLabel capacityLabel = new JLabel();
    private JLabel nameLabel = new JLabel();
    private JLabel statusLabel = new JLabel();
    private JLabel averageLoadLabel = new JLabel();
    private JPanel contentPanel;

    public ResourceTreeTableCellRenderer() {
        this.setLayout(new BorderLayout());
        this.iconLabel.setVerticalAlignment(1);
        this.iconLabel.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.iconLabel.setOpaque(true);
        this.add("West", this.iconLabel);
        this.contentPanel = new JPanel();
        this.add("Center", this.contentPanel);
        this.contentPanel.setLayout(new GridLayout(5, 1));
        this.contentPanel.add(this.nameLabel);
        this.contentPanel.add(this.locationLabel);
        this.contentPanel.add(this.capacityLabel);
        this.contentPanel.add(this.averageLoadLabel);
        this.contentPanel.add(this.statusLabel);
        this.contentPanel.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.nameLabel.setFont(new Font("courier", 0, 12));
        this.locationLabel.setFont(new Font("courier", 0, 12));
        this.capacityLabel.setFont(new Font("courier", 0, 12));
        this.averageLoadLabel.setFont(new Font("courier", 0, 12));
        this.statusLabel.setFont(new Font("courier", 0, 12));
    }

    @Override
    public Component getTreeTableCellRendererComponent(TreeTable tree, Object node, Object value, int depth, boolean selected, boolean expanded, boolean leaf, int row, int column, boolean hasFocus) {
        if (selected) {
            this.setBackground(tree.getSelectionBackground());
            this.contentPanel.setForeground(tree.getSelectionForeground());
            this.contentPanel.setBackground(tree.getSelectionBackground());
            this.iconLabel.setForeground(tree.getSelectionForeground());
            this.iconLabel.setBackground(tree.getSelectionBackground());
            this.nameLabel.setForeground(tree.getSelectionForeground());
            this.nameLabel.setBackground(tree.getSelectionBackground());
            this.locationLabel.setForeground(tree.getSelectionForeground());
            this.locationLabel.setBackground(tree.getSelectionBackground());
            this.capacityLabel.setForeground(tree.getSelectionForeground());
            this.capacityLabel.setBackground(tree.getSelectionBackground());
            this.averageLoadLabel.setForeground(tree.getSelectionForeground());
            this.averageLoadLabel.setBackground(tree.getSelectionBackground());
            this.statusLabel.setForeground(tree.getSelectionForeground());
            this.statusLabel.setBackground(tree.getSelectionBackground());
        } else {
            this.setBackground(tree.getBackground(row));
            this.contentPanel.setForeground(tree.getForeground());
            this.contentPanel.setBackground(tree.getBackground(row));
            this.iconLabel.setForeground(tree.getForeground());
            this.iconLabel.setBackground(tree.getBackground(row));
            this.nameLabel.setForeground(tree.getForeground());
            this.nameLabel.setBackground(tree.getBackground());
            this.locationLabel.setForeground(tree.getForeground());
            this.locationLabel.setBackground(tree.getBackground());
            this.capacityLabel.setForeground(tree.getForeground());
            this.capacityLabel.setBackground(tree.getBackground());
            this.averageLoadLabel.setForeground(tree.getForeground());
            this.averageLoadLabel.setBackground(tree.getBackground());
            this.statusLabel.setForeground(tree.getForeground());
            this.statusLabel.setBackground(tree.getBackground());
        }
        this.setBorder(null);
        if (column == Integer.MIN_VALUE) {
            this.setBorder(new LineBorder(Color.BLACK));
        }
        Resource resource = (Resource)value;
        this.iconLabel.setIcon(resource.getIcon());
        this.nameLabel.setText(resource.getName());
        this.locationLabel.setText(resource.getLocation());
        this.capacityLabel.setText(Double.toString(resource.getCapacity()));
        this.averageLoadLabel.setText(Double.toString(resource.getAverageLoad()));
        this.statusLabel.setText(resource.getStatus().toString());
        return this;
    }
}

